/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.xml;

import com.bowman.xml.XMLEncoder;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    public static void print(PrintWriter writer, boolean flag, Node node) {
        DOMWriter.write(writer, node);
    }

    private static void write(PrintWriter writer, NamedNodeMap nodeMap) {
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            DOMWriter.write(writer, nodeMap.item(i));
        }
    }

    public static void write(PrintWriter writer, Node node) {
        switch (node.getNodeType()) {
            case 2: {
                writer.print(' ');
                writer.print(node.getNodeName());
                writer.print("=\"");
                writer.print(XMLEncoder.encode(node.getNodeValue()));
                writer.print("\"");
                break;
            }
            case 4: {
                writer.print("<![CDATA[");
                writer.print(node.getNodeValue());
                writer.print("]]>");
                break;
            }
            case 9: {
                writer.println("<?xml version=\"1.0\"?>");
                DOMWriter.write(writer, ((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                writer.print('<');
                writer.print(node.getNodeName());
                DOMWriter.write(writer, node.getAttributes());
                writer.print('>');
                DOMWriter.write(writer, node.getChildNodes());
                writer.print("</");
                writer.print(node.getNodeName());
                writer.print('>');
                break;
            }
            case 5: {
                writer.print('&');
                writer.print(node.getNodeName());
                writer.print(';');
                break;
            }
            case 3: {
                writer.print(XMLEncoder.encode(node.getNodeValue()));
            }
        }
        writer.flush();
    }

    private static void write(PrintWriter writer, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DOMWriter.write(writer, nodeList.item(i));
        }
    }
}

