/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.xml;

import com.bowman.xml.NodeCoalescer;
import com.bowman.xml.XMLConfigException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLConfig {
    public static final int FORMATTED = 1;
    public static final int UNFORMATTED = 0;
    private String DTD_DIR = System.getProperty("xmlconfig.dtd.dir");
    private Node root;
    private List subconfigs;
    private Properties attributes;
    private static ErrorHandler errorhandler = new ErrorHandler(){

        public void error(SAXParseException spe) throws SAXException {
            throw spe;
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            throw spe;
        }

        public void warning(SAXParseException spe) throws SAXException {
            throw spe;
        }
    };

    public XMLConfig(InputStream inputStream) throws XMLConfigException {
        this(inputStream, true);
    }

    public XMLConfig(InputStream inputStream, boolean validate) throws XMLConfigException {
        this(inputStream, validate, null);
    }

    public XMLConfig(InputStream inputStream, boolean validate, String encoding) throws XMLConfigException {
        Document document;
        DocumentBuilder docBuilder;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setValidating(validate);
        try {
            docBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new XMLConfigException(pce.getMessage());
        }
        docBuilder.setErrorHandler(errorhandler);
        try {
            if (this.DTD_DIR == null) {
                this.DTD_DIR = "config";
            }
            this.DTD_DIR = "file:///" + new File(this.DTD_DIR).getAbsolutePath().replace('\\', '/');
            InputSource source = new InputSource(inputStream);
            if (encoding == null) {
                source.setEncoding(System.getProperty("file.encoding"));
            } else {
                source.setEncoding(encoding);
            }
            source.setSystemId(this.DTD_DIR + "/");
            document = docBuilder.parse(source);
        }
        catch (Exception e) {
            throw new XMLConfigException(e.getMessage());
        }
        Element element = document.getDocumentElement();
        this.initialize(element);
    }

    public XMLConfig(String s) throws XMLConfigException {
        this(s, true);
    }

    public XMLConfig(String s, boolean validate) throws XMLConfigException {
        this(new ByteArrayInputStream(s.getBytes()), validate);
    }

    private XMLConfig(Node node) {
        this.initialize(node);
    }

    public Enumeration getAllSubConfigs() {
        Vector<XMLConfig> vector = new Vector<XMLConfig>();
        for (int i = 0; i < this.subconfigs.size(); ++i) {
            Node node = (Node)this.subconfigs.get(i);
            vector.addElement(new XMLConfig(node));
        }
        return vector.elements();
    }

    public String getContents() {
        return this.getContents(1);
    }

    public String getContents(int i) {
        if (i == 1) {
            return this.removeSpaces(NodeCoalescer.coalesce(this.root));
        }
        return NodeCoalescer.coalesce(this.root);
    }

    public Enumeration getMultipleStrings(String s) {
        return this.getMultipleStrings(s, 1);
    }

    public Enumeration getMultipleStrings(String s, int i) {
        Vector<String> vector = new Vector<String>();
        String s1 = this.attributes.getProperty(s);
        if (s1 != null) {
            if (i == 1) {
                vector.addElement(this.removeSpaces(s1));
            } else {
                vector.addElement(s1);
            }
        }
        for (int j = 0; j < this.subconfigs.size(); ++j) {
            String s3;
            Node node = (Node)this.subconfigs.get(j);
            String s2 = node.getNodeName();
            if (!s2.equals(s) || (s3 = NodeCoalescer.coalesce(node)) == null) continue;
            if (i == 1) {
                vector.addElement(this.removeSpaces(s3));
                continue;
            }
            vector.addElement(s3);
        }
        return vector.elements();
    }

    public Enumeration getMultipleSubConfigs(String s) {
        Vector<XMLConfig> vector = new Vector<XMLConfig>();
        for (int i = 0; i < this.subconfigs.size(); ++i) {
            Node node = (Node)this.subconfigs.get(i);
            if (!node.getNodeName().equals(s)) continue;
            vector.addElement(new XMLConfig(node));
        }
        return vector.elements();
    }

    public String[] getParentNames() {
        Node previous;
        Vector<String> v = new Vector<String>();
        Node parent = this.root.getParentNode();
        if (parent != null) {
            v.addElement(parent.getNodeName());
        }
        do {
            previous = parent;
            if ((parent = parent.getParentNode()) == null) break;
            v.addElement(parent.getNodeName());
        } while (parent != previous);
        v.removeElementAt(v.size() - 1);
        String[] names = new String[v.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)v.elementAt(names.length - (i + 1));
        }
        return names;
    }

    public String getName() {
        return this.root.getNodeName();
    }

    public String getString(String s) {
        return this.getString(s, 1);
    }

    public String getString(String s, int i) {
        boolean flag = false;
        String s1 = this.attributes.getProperty(s);
        if (s1 == null) {
            for (int j = 0; !flag && j < this.subconfigs.size(); ++j) {
                Node node = (Node)this.subconfigs.get(j);
                if (!node.getNodeName().equals(s)) continue;
                s1 = NodeCoalescer.coalesce(node);
                flag = true;
            }
        }
        if (i == 1) {
            return this.removeSpaces(s1);
        }
        return s1;
    }

    public XMLConfig getSubConfig(String s) {
        boolean flag = false;
        Node node = null;
        for (int i = 0; !flag && i < this.subconfigs.size(); ++i) {
            node = (Node)this.subconfigs.get(i);
            if (!node.getNodeName().equals(s)) continue;
            flag = true;
        }
        if (flag) {
            return new XMLConfig(node);
        }
        return null;
    }

    private void initialize(Node node) {
        this.attributes = new Properties();
        this.subconfigs = new ArrayList();
        this.root = node;
        NamedNodeMap nodeMap = node.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            this.attributes.setProperty(nodeMap.item(i).getNodeName(), nodeMap.item(i).getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node childNode = nodeList.item(j);
            NamedNodeMap childNodeMap = childNode.getAttributes();
            if (!childNode.hasChildNodes() && (childNodeMap == null || childNodeMap.getLength() <= 0)) continue;
            this.subconfigs.add(childNode);
        }
    }

    private String removeSpaces(String s) {
        String s1 = "";
        boolean flag = true;
        if (s != null) {
            s = s.replace('\n', ' ');
            s = s.replace('\t', ' ');
            for (int i = 0; i < s.length(); ++i) {
                boolean flag1;
                boolean bl = flag1 = s.charAt(i) == ' ';
                if (flag && flag1) continue;
                s1 = s1 + s.substring(i, i + 1);
                flag = flag1;
            }
            return s1.trim();
        }
        return null;
    }

    public String toString() {
        return this.root.toString();
    }

    protected void flatten(String prefix, Properties p, boolean attribsOnly) {
        prefix = prefix != null ? prefix + "." + this.getName() : this.getName();
        if (this.attributes.getProperty("name") != null) {
            prefix = prefix + "[" + this.attributes.getProperty("name") + "]";
        }
        if (attribsOnly) {
            prefix = "";
        }
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String pkey = prefix.length() > 0 ? prefix + "." + key : key;
            while (p.getProperty(pkey) != null) {
                pkey = pkey + "_";
            }
            p.setProperty(pkey, this.attributes.getProperty(key));
        }
        if (!"".equals(this.getContents(1))) {
            p.setProperty(prefix, this.getContents(1));
        }
        e = this.getAllSubConfigs();
        while (e.hasMoreElements()) {
            XMLConfig subConf = (XMLConfig)e.nextElement();
            subConf.flatten(prefix, p, attribsOnly);
        }
    }

    public Properties flatten() {
        Properties p = new Properties();
        this.flatten(null, p, false);
        return p;
    }

    public Properties flatten(boolean attribsOnly) {
        Properties p = new Properties();
        this.flatten(null, p, true);
        return p;
    }
}

