/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.crypto.DESUtil;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CardData {
    private byte[] data;
    private int caId;
    private int userId;
    private int providerCount;
    private String cardNumber;
    private String label;
    private List providers = new ArrayList();
    private List provIds = new ArrayList();
    private Exception parseException;

    public CardData(byte[] raw) {
        this(raw, null);
    }

    public CardData(byte[] raw, String label) {
        this.label = label;
        this.data = raw;
        this.userId = raw[0] & 0xFF;
        this.caId = (raw[1] & 0xFF) * 256 + (raw[2] & 0xFF);
        try {
            this.cardNumber = DESUtil.bytesToString(raw, 3, 8);
        }
        catch (Exception e) {
            this.parseException = e;
            e.printStackTrace();
            this.cardNumber = "00 00 00 00 00 00 00 00";
        }
        this.providerCount = raw[11];
        for (int i = 0; i < this.providerCount; ++i) {
            try {
                this.providers.add(DESUtil.bytesToString(raw, 12 + i * 11, 3));
                this.provIds.add(DESUtil.bytesToString(raw, 15 + i * 11, 8));
                continue;
            }
            catch (Exception e) {
                this.parseException = e;
                e.printStackTrace();
            }
        }
    }

    public byte[] getData(boolean anonymize) {
        int i;
        if (!anonymize) {
            return this.data;
        }
        byte[] anonData = new byte[12 + this.providerCount * 11];
        System.arraycopy(this.data, 0, anonData, 0, Math.min(anonData.length, this.data.length));
        for (i = 3; i < 11; ++i) {
            anonData[i] = 0;
        }
        for (i = 0; i < this.providerCount; ++i) {
            for (int n = 0; n < 8; ++n) {
                anonData[15 + i * 11 + n] = 0;
            }
        }
        if (anonData[0] == 1) {
            anonData[0] = 2;
        }
        return anonData;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getProviderCount() {
        return this.providerCount;
    }

    public int getCaId() {
        return this.caId;
    }

    public String getCaIdStr() {
        String s = Integer.toHexString(this.caId);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return s;
    }

    public String getProvidersStr() {
        return this.providers.toString();
    }

    public String[] getProviders() {
        return this.providers.toArray(new String[this.providers.size()]);
    }

    public Integer[] getProvidersAsInt() {
        Integer[] i = new Integer[this.providers.size()];
        for (int n = 0; n < i.length; ++n) {
            i[n] = new Integer(DESUtil.byteStringToInt((String)this.providers.get(n)));
        }
        return i;
    }

    public String getProvIdsStr() {
        return this.provIds.toString();
    }

    public String[] getProvIds() {
        return this.provIds.toArray(new String[this.provIds.size()]);
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String toString() {
        if (this.parseException != null) {
            return "Failed parse: " + this.parseException;
        }
        String label = this.isAnonymous() ? "Yes" : "No (" + this.label + ")";
        return "UserID [" + this.userId + "] CaID [" + this.getCaIdStr() + "] Providers [" + this.getProviderCount() + "] " + this.getProvidersStr() + " Anonymous [" + label + "]";
    }

    public Exception getParseException() {
        return this.parseException;
    }

    public boolean isAnonymous() {
        return "00 00 00 00 00 00 00 00".equals(this.cardNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardData cardData = (CardData)o;
        return Arrays.equals(this.data, cardData.data);
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public boolean dump(File f) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(this.data);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static CardData createEmptyData(int caId) {
        byte[] buf = new byte[23];
        buf[0] = 2;
        buf[1] = (byte)(caId >> 8 & 0xFF);
        buf[2] = (byte)(caId & 0xFF);
        buf[11] = 1;
        return new CardData(buf);
    }

    public static CardData createFromFile(File f) throws IOException {
        byte[] buf = new byte[(int)f.length()];
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        dis.readFully(buf);
        return new CardData(buf, f.getName());
    }

    public static CardData createMergedData(CardData card, Integer[] addProviders) {
        if (addProviders == null || addProviders.length == 0) {
            return card;
        }
        byte[] buf = new byte[card.data.length + 11 * addProviders.length];
        System.arraycopy(card.data, 0, buf, 0, card.data.length);
        buf[11] = (byte)(buf[11] + addProviders.length);
        int n = 0;
        for (int i = card.getProviderCount(); i < buf[11]; ++i) {
            byte[] prov = DESUtil.intToBytes(addProviders[n++], 3);
            buf[12 + i * 11] = prov[0];
            buf[13 + i * 11] = prov[1];
            buf[14 + i * 11] = prov[2];
        }
        return new CardData(buf);
    }

    public static CardData createData(int caId, String[] providers) {
        Integer[] pis = new Integer[providers.length];
        for (int i = 0; i < pis.length; ++i) {
            pis[i] = new Integer(DESUtil.byteStringToInt(providers[i].trim()));
        }
        return CardData.createData(caId, pis);
    }

    public static CardData createData(int caId, Integer[] providers) {
        if (providers == null || providers.length == 0) {
            providers = new Integer[]{new Integer(0)};
        }
        byte[] buf = new byte[12 + 11 * providers.length];
        buf[0] = 2;
        buf[1] = (byte)(caId >> 8 & 0xFF);
        buf[2] = (byte)(caId & 0xFF);
        buf[11] = (byte)(providers.length & 0xFF);
        for (int i = 0; i < providers.length; ++i) {
            byte[] prov = DESUtil.intToBytes(providers[i], 3);
            buf[12 + i * 11] = prov[0];
            buf[13 + i * 11] = prov[1];
            buf[14 + i * 11] = prov[2];
        }
        return new CardData(buf);
    }
}

