/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.tv;

import com.bowman.cardserv.tv.TvService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CccamParser {
    private File chanInfoFile;
    public int conflicts;

    public CccamParser(String fileName) {
        this.chanInfoFile = new File(fileName);
    }

    public Map parse(String caId, String providers, String profile, String networkIdStr) throws IOException {
        String line;
        this.conflicts = 0;
        if ("".equals(providers)) {
            providers = null;
        }
        Set<Object> providerSet = providers == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(providers.toLowerCase().split(" ")));
        HashMap services = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.chanInfoFile), "ISO-8859-1"));
        while ((line = br.readLine()) != null) {
            String[] tokens;
            if ((line = line.trim()).startsWith("#") || line.length() == 0 || (tokens = line.split("\"")).length != 2) continue;
            String name = tokens[1].trim();
            int idx = (name = name.split("\\[")[0].trim()).indexOf(45);
            if (idx != -1 && !name.endsWith("-")) {
                name = name.split("-")[1].trim();
            }
            if (!(tokens = tokens[0].trim().split(":"))[0].equalsIgnoreCase(caId) || !providerSet.isEmpty() && !providerSet.contains(tokens[1].toLowerCase())) continue;
            TvService service = new TvService(new String[]{tokens[2], "00000000", "0000", networkIdStr, "1", "0"}, profile);
            service.setName(name);
            this.addService(services, service);
        }
        return services;
    }

    public int getConflicts() {
        return this.conflicts;
    }

    private void addService(Map services, TvService service) {
        Integer i = new Integer(service.getId());
        if (services.containsKey(i)) {
            TvService existing = (TvService)services.get(i);
            if (!service.getName().equalsIgnoreCase(existing.getName())) {
                existing.addConflicting(service);
                ++this.conflicts;
            }
        } else {
            services.put(i, service);
        }
    }
}

