/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.tv;

import com.bowman.cardserv.tv.TvService;
import com.bowman.util.IniFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DvbviewerParser {
    private String fileName;

    public DvbviewerParser(String fileName) {
        this.fileName = fileName;
    }

    public Map parse(String filter, String profile, int networkId) throws IOException {
        HashSet<String> filterSet = null;
        if (filter != null) {
            String[] s = filter.toLowerCase().split(",");
            filterSet = new HashSet<String>();
            for (int i = 0; i < s.length; ++i) {
                filterSet.add(s[i].trim().toLowerCase());
            }
        }
        if (filterSet != null && filterSet.isEmpty()) {
            filterSet = null;
        }
        IniFile iniFile = new IniFile(this.fileName);
        HashMap<Integer, TvService> services = new HashMap<Integer, TvService>();
        int[] tokens = new int[6];
        Iterator iter = iniFile.getSections().iterator();
        while (iter.hasNext()) {
            String section = (String)iter.next();
            if (filterSet != null && !filterSet.contains(iniFile.getProperty(section, "Root").toLowerCase())) continue;
            tokens[0] = Integer.parseInt(iniFile.getProperty(section, "SID"));
            tokens[1] = 0;
            tokens[2] = Integer.parseInt(iniFile.getProperty(section, "StreamID"));
            tokens[3] = Integer.parseInt(iniFile.getProperty(section, "NetworkID"));
            tokens[4] = 1;
            tokens[5] = Integer.parseInt(section.substring(section.lastIndexOf(108) + 1));
            TvService service = new TvService(tokens, profile);
            String name = iniFile.getProperty(section, "Name");
            if (name.indexOf(40) != -1) {
                name = name.substring(0, name.indexOf(40));
            }
            service.setName(name);
            if (networkId > 0 && networkId != tokens[3]) continue;
            Integer sid = new Integer(tokens[0]);
            if (filterSet != null) {
                service.setNetworkId(networkId);
            }
            if (services.containsKey(sid)) continue;
            services.put(sid, service);
        }
        return services;
    }

    public int getConflicts() {
        return 0;
    }
}

