/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.cardserv.util.UnixUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CustomFormatter
extends Formatter {
    private static SimpleDateFormat fmt = new SimpleDateFormat("yyMMdd HH:mm:ss.SSS");
    private static final int MB = 0x100000;
    private static boolean debug = false;
    private static boolean hideIPs = false;
    private static String logBase = "";
    private static boolean checkFileDescriptors = true;
    private static String jvmStats;
    private static long jvmStatsAge;
    private boolean skipLead = false;

    public static void setLogBase(String lb) {
        logBase = lb;
    }

    public static void setDebug(boolean b) {
        debug = b;
    }

    public static void setHideIPs(boolean b) {
        hideIPs = b;
    }

    public static void setDateFormat(SimpleDateFormat sdf) {
        fmt = sdf;
    }

    public static boolean isDebug() {
        return debug;
    }

    private static String getJvmStats() {
        long now = System.currentTimeMillis();
        if (now - jvmStatsAge > 1000L || jvmStats == null) {
            Runtime rt = Runtime.getRuntime();
            StringBuffer sb = new StringBuffer();
            long tm = rt.totalMemory();
            long used = tm - rt.freeMemory();
            sb.append("H:").append(used / 0x100000L).append('/').append(tm / 0x100000L).append("M");
            sb.append(" TC:").append(Thread.activeCount());
            if (checkFileDescriptors) {
                try {
                    long openFd = UnixUtil.getOpenFileDescriptorCount();
                    long maxFd = UnixUtil.getMaxFileDescriptorCount();
                    if (openFd > 0L && maxFd > 0L) {
                        sb.append(" FD:").append(openFd).append('/').append(maxFd);
                    }
                }
                catch (Throwable e) {
                    checkFileDescriptors = false;
                }
            }
            jvmStats = sb.toString();
            jvmStatsAge = now;
        }
        return jvmStats;
    }

    public boolean isSkipLead() {
        return this.skipLead;
    }

    public void setSkipLead(boolean skipLead) {
        this.skipLead = skipLead;
    }

    public static String formatLabel(String sourceClass) {
        if (sourceClass.startsWith(logBase)) {
            return sourceClass.substring(logBase.length() + 1);
        }
        return sourceClass;
    }

    public String format(LogRecord lr) {
        Object label = null;
        String sourceClass = lr.getSourceClassName();
        if (sourceClass.startsWith(logBase)) {
            sourceClass = sourceClass.substring(logBase.length() + 1);
            if (lr.getParameters() != null && lr.getParameters().length > 0) {
                label = lr.getParameters()[0];
            }
        } else {
            label = sourceClass;
        }
        StringBuffer sb = new StringBuffer();
        if (!this.skipLead) {
            sb.append(fmt.format(new Date(lr.getMillis())));
            sb.append(' ').append(lr.getLevel().getName());
            if (lr.getThrown() != null) {
                sb.append(" [").append(lr.getThrown().toString()).append(']');
            }
            sb.append(" -> ");
            if (label != null) {
                sb.append(label);
                sb.append(" <- ");
            }
        }
        sb.append(lr.getMessage());
        if (debug) {
            sb.append("\n\t DEBUG -> [").append(CustomFormatter.getJvmStats()).append("] ");
            sb.append('\"').append(Thread.currentThread().getName()).append('\"');
            sb.append(" in ").append(sourceClass).append(' ').append(lr.getSourceMethodName()).append("()");
        }
        if (lr.getThrown() != null) {
            sb.append('\n').append(CustomFormatter.getStackTrace(lr.getThrown()));
        } else if (debug) {
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        sw.flush();
        return sw.getBuffer().toString();
    }

    public static String formatAddress(String addr) {
        if (!hideIPs || addr == null || addr.startsWith("0.") || addr.indexOf(46) == -1) {
            return addr;
        }
        boolean isIp = true;
        try {
            if (Integer.parseInt(addr.substring(0, addr.indexOf(46))) > 255) {
                isIp = false;
            }
        }
        catch (NumberFormatException nfe) {
            isIp = false;
        }
        if (isIp) {
            return "xxx.xxx.xxx." + addr.substring(addr.lastIndexOf(46) + 1);
        }
        return addr.substring(0, addr.indexOf(46)) + ".xxx.xxx";
    }

    static {
        jvmStatsAge = System.currentTimeMillis();
    }
}

