/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.interfaces.LogListener;
import com.bowman.cardserv.util.CustomFormatter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ProxyLogger {
    public static final String LOG_BASE = "com.bowman.cardserv";
    private static ConsoleHandler console;
    private static LogListener listener;
    private Logger logger;
    private FileHandler fileHandler;
    private String label;
    private static Map levelMap;

    public static void setLogListener(LogListener logListener) {
        listener = logListener;
    }

    public static ProxyLogger getProxyLogger(String name) {
        return new ProxyLogger(Logger.getLogger(name));
    }

    private ProxyLogger(Logger logger) {
        this.logger = logger;
    }

    public void throwing(String msg, Throwable throwable, Level level) {
        String sourceMethod;
        StackTraceElement caller = this.getCallerStackFrame();
        String sourceClass = caller == null ? "<unknown>" : caller.getClassName();
        String string = sourceMethod = caller == null ? "<unknown>" : caller.getMethodName();
        if (msg == null) {
            msg = "THROW";
        }
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(throwable);
            lr.setParameters(new Object[]{this.label});
            this.logger.log(lr);
        }
    }

    public void throwing(String msg, Throwable throwable) {
        this.throwing(msg, throwable, CustomFormatter.isDebug() ? Level.WARNING : Level.FINER);
    }

    public void throwing(Throwable throwable) {
        this.throwing(null, throwable);
    }

    public void severe(String msg, Throwable throwable) {
        this.throwing(msg, throwable, Level.SEVERE);
    }

    protected void logb(Level l, String msg) {
        String sourceMethod;
        StackTraceElement caller = this.getCallerStackFrame();
        String sourceClass = caller == null ? "<unknown>" : caller.getClassName();
        String string = sourceMethod = caller == null ? "<unknown>" : caller.getMethodName();
        if (listener != null) {
            try {
                listener.onLog(l, this.label, msg);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.logger.logp(l, sourceClass, sourceMethod, msg, this.label);
    }

    public void severe(String msg) {
        this.logb(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.logb(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.logb(Level.INFO, msg);
    }

    public void fine(String msg) {
        this.logb(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.logb(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.logb(Level.FINEST, msg);
    }

    public void setLevel(String level) throws ConfigException {
        this.logger.setLevel(ProxyLogger.getLogLevel(level));
        console.setLevel(ProxyLogger.getLogLevel(level));
    }

    public void setSilent(boolean silent) {
        this.logger.removeHandler(console);
        if (!silent) {
            this.logger.addHandler(console);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void close() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }

    public Logger getWrappedLogger() {
        return this.logger;
    }

    private StackTraceElement getCallerStackFrame() {
        int index;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        for (index = 0; index < stackTrace.length && !stackTrace[index].getClassName().equals(this.getClass().getName()); ++index) {
        }
        while (index < stackTrace.length && stackTrace[index].getClassName().equals(this.getClass().getName())) {
            ++index;
        }
        return index < stackTrace.length ? stackTrace[index] : null;
    }

    public static ProxyLogger getLabeledLogger(String name) {
        return ProxyLogger.getLabeledLogger(name, null);
    }

    public static ProxyLogger getLabeledLogger(String name, String label) {
        ProxyLogger logger = ProxyLogger.getProxyLogger(name);
        logger.logger.setUseParentHandlers(true);
        if (label == null && name.indexOf(46) > -1) {
            label = name.substring(name.lastIndexOf(46) + 1);
        }
        logger.setLabel(label);
        return logger;
    }

    public static Level getLogLevel(String level) throws ConfigException {
        if (!levelMap.containsKey(level.toUpperCase())) {
            throw new ConfigException("log-level", "Illegal log-level '" + level + "'  " + levelMap.keySet() + " are supported");
        }
        return (Level)levelMap.get(level.toUpperCase());
    }

    public static ProxyLogger getFileLogger(String name, File logFile, String level, int count, int limit, boolean skipLead) throws ConfigException, IOException {
        Level l = ProxyLogger.getLogLevel(level);
        ProxyLogger logger = ProxyLogger.getProxyLogger(name);
        logger.fileHandler = count < 1 || limit < 1 ? new FileHandler(logFile.getAbsolutePath(), true) : new FileHandler(logFile.getAbsolutePath(), limit * 1024, count, true);
        CustomFormatter formatter = new CustomFormatter();
        formatter.setSkipLead(skipLead);
        logger.fileHandler.setFormatter(formatter);
        logger.logger.addHandler(logger.fileHandler);
        logger.logger.setUseParentHandlers(false);
        logger.logger.setLevel(l);
        return logger;
    }

    public static void initConsole(String level) throws ConfigException {
        console = new ConsoleHandler();
        console.setFormatter(new CustomFormatter());
        console.setLevel(ProxyLogger.getLogLevel(level));
    }

    public static void initFormatter(boolean debug, boolean hideIPs) {
        CustomFormatter.setDebug(debug);
        CustomFormatter.setHideIPs(hideIPs);
        CustomFormatter.setLogBase(LOG_BASE);
    }

    static {
        levelMap = new HashMap();
        Field[] fields = Level.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getType() != (class$java$util$logging$Level == null ? ProxyLogger.class$("java.util.logging.Level") : class$java$util$logging$Level)) continue;
            try {
                levelMap.put(fields[i].getName().toUpperCase(), fields[i].get(null));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

