/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class TimedAverageList {
    private int maxAge;
    private int maxValue;
    private int minValue;
    private LinkedList list = new LinkedList();

    public TimedAverageList(int maxAge) {
        this.maxAge = maxAge * 1000;
    }

    public void addRecord(int i) {
        this.addRecord(System.currentTimeMillis(), i);
    }

    public synchronized void addRecord(long timeStamp, int i) {
        this.list.addLast(new TimedEntry(timeStamp, i));
        if (i < this.minValue || this.minValue == 0) {
            this.minValue = i;
        }
        if (i > this.maxValue || this.maxValue == 0) {
            this.maxValue = i;
        }
        this.removeOldest();
    }

    boolean removeOldest() {
        TimedEntry t = (TimedEntry)this.list.getFirst();
        if (System.currentTimeMillis() - t.timeStamp > (long)this.maxAge) {
            this.list.removeFirst();
            return true;
        }
        return false;
    }

    public synchronized int getAverage(boolean current) {
        if (this.list.isEmpty()) {
            return -1;
        }
        int total = 0;
        int count = 0;
        long now = System.currentTimeMillis();
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            TimedEntry t = (TimedEntry)iter.next();
            if (t == null) continue;
            if (current) {
                if (now - t.timeStamp > (long)this.maxAge) continue;
                total += t.value;
                ++count;
                continue;
            }
            total += t.value;
            ++count;
        }
        if (count == 0) {
            return -1;
        }
        return total / count;
    }

    public synchronized int getTotal(boolean current) {
        if (this.list.isEmpty()) {
            return 0;
        }
        int total = 0;
        long now = System.currentTimeMillis();
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            TimedEntry t = (TimedEntry)iter.next();
            if (t == null) continue;
            if (current) {
                if (now - t.timeStamp > (long)this.maxAge) continue;
                total += t.value;
                continue;
            }
            total += t.value;
        }
        return total;
    }

    public synchronized int getLowest() {
        if (this.list.isEmpty()) {
            return -1;
        }
        int lowest = -1;
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            TimedEntry t = (TimedEntry)iter.next();
            if (t == null || lowest != -1 && t.value >= lowest) continue;
            lowest = t.value;
        }
        int avg = this.getAverage(false);
        if (lowest < avg / 2) {
            lowest = avg / 2;
        }
        return lowest;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized int size(boolean current) {
        if (!current || this.list.isEmpty()) {
            return this.list.size();
        }
        long now = System.currentTimeMillis();
        int index = 0;
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            TimedEntry t = (TimedEntry)iter.next();
            if (now - t.timeStamp <= (long)this.maxAge) {
                return this.list.size() - index;
            }
            ++index;
        }
        return 0;
    }

    public synchronized int size(long maxAge) {
        if (this.list.isEmpty()) {
            return 0;
        }
        long now = System.currentTimeMillis();
        int count = 0;
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            TimedEntry t = (TimedEntry)iter.next();
            if (now - t.timeStamp > maxAge) continue;
            ++count;
        }
        return count;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public synchronized Set getCurrentSet(long maxAge) {
        HashSet<Integer> current = new HashSet<Integer>();
        if (this.list.isEmpty()) {
            return current;
        }
        long now = System.currentTimeMillis();
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            TimedEntry t = (TimedEntry)iter.next();
            if (now - t.timeStamp > maxAge) continue;
            current.add(new Integer(t.value));
        }
        return current;
    }

    private static class TimedEntry {
        long timeStamp;
        int value;

        private TimedEntry(long timeStamp, int value) {
            this.timeStamp = timeStamp;
            this.value = value;
        }
    }
}

