/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.rmi.RemoteEvent;
import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.rmi.RemoteListener;
import com.bowman.cardserv.rmi.RemoteProxy;
import com.bowman.cardserv.session.CspSession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.XmlHelper;
import com.bowman.httpd.HttpRequest;
import com.bowman.httpd.HttpRequestListener;
import com.bowman.httpd.HttpResponse;
import com.bowman.httpd.PseudoHttpd;
import com.bowman.httpd.SecurePseudoHttpd;
import com.bowman.util.Base64Encoder;
import com.bowman.util.Globber;
import com.bowman.xml.XMLConfig;
import com.bowman.xml.XMLConfigException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebBackend
implements HttpRequestListener,
RemoteListener,
XmlConfigurable {
    private static final int MAX_EVENTS = 40;
    private static final int MAX_ECMS = 100;
    private static final String PLUGIN_SCRIPT = "load.js";
    private static final String xmlHandlerPattern = "/xmlHandler*";
    private static final String cfgHandlerPattern = "/cfgHandler*";
    private static final String bouquetPattern = "/userbouquet.*.tv";
    private static final String piconPattern = "/picon/*";
    private static final String pluginPattern = "/plugin/*";
    private static final String connectPattern = "/cspHandler";
    Map sessions = new HashMap();
    Map bouquets = new HashMap();
    Map userTransactions = new HashMap();
    Map cwsTransactions = new HashMap();
    Set superUsers = new HashSet();
    List eventLog = Collections.synchronizedList(new ArrayList());
    List warningLog = Collections.synchronizedList(new ArrayList());
    List fileLog = Collections.synchronizedList(new ArrayList());
    private Set connecting = new HashSet();
    private Set invalid = new HashSet();
    private XmlHelper helper;
    private PseudoHttpd httpd;
    private ProxyLogger httpdLogger;
    private boolean debugXml = false;
    private boolean allowCspConnect = true;
    private boolean ignoreCacheRequests = false;
    RemoteProxy proxy;
    ProxyLogger logger;

    public WebBackend(RemoteHandler proxy) {
        this.proxy = proxy;
        try {
            this.proxy.addRemoteListener(this);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
        this.helper = new XmlHelper(this);
        try {
            new CtrlCommand("debug-xml", "Toggle xml debugging", "Write all incoming and outgoing xml to sysout.").register(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public CtrlCommandResult runCtrlCmdDebugXml() {
        this.debugXml = !this.debugXml;
        return new CtrlCommandResult(true, "Debugging is now " + (this.debugXml ? "on." : "off."));
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        boolean useSsl = false;
        String keyStorePath = null;
        String keyStorePasswd = null;
        ProxyXmlConfig sslXml = null;
        try {
            sslXml = xml.getSubConfig("ssl");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (sslXml != null && "true".equalsIgnoreCase(sslXml.getStringValue("enabled"))) {
            keyStorePath = sslXml.getFileValue("keystore", false);
            keyStorePasswd = sslXml.getSubConfig("keystore").getStringValue("password");
            useSsl = true;
        }
        InetAddress bindAddr = null;
        String bindIp = null;
        try {
            bindIp = xml.getStringValue("bind-ip");
            bindAddr = InetAddress.getByName(bindIp);
        }
        catch (ConfigException e) {
        }
        catch (UnknownHostException e) {
            throw new ConfigException(xml.getFullName(), "bind-ip", "Invalid status-web bind-ip: " + bindIp);
        }
        boolean autoStart = false;
        int listenPort = xml.getPortValue("listen-port");
        try {
            if (this.httpd != null) {
                if (this.httpd.getListenPort() != listenPort) {
                    this.httpd.stop();
                    this.httpd = useSsl ? new SecurePseudoHttpd(listenPort, bindAddr, keyStorePath, keyStorePasswd) : new PseudoHttpd(listenPort, bindAddr);
                    autoStart = true;
                }
            } else {
                this.httpd = useSsl ? new SecurePseudoHttpd(listenPort, bindAddr, keyStorePath, keyStorePasswd) : new PseudoHttpd(listenPort, bindAddr);
            }
        }
        catch (GeneralSecurityException e) {
            throw new ConfigException(xml.getSubConfig("ssl").getFullName(), "Unable to initialize ssl: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigException(xml.getSubConfig("ssl").getFullName(), "Unable to load keystore '" + keyStorePath + "' for ssl: " + e.getMessage(), e);
        }
        this.allowCspConnect = true;
        ProxyXmlConfig cspcXml = null;
        try {
            cspcXml = xml.getSubConfig("csp-connect");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (cspcXml != null) {
            if ("false".equalsIgnoreCase(cspcXml.getStringValue("enabled"))) {
                this.allowCspConnect = false;
            }
            try {
                boolean debug = "true".equalsIgnoreCase(cspcXml.getStringValue("debug"));
                CaProfile.MULTIPLE.setDebug(debug);
            }
            catch (ConfigException e) {
                // empty catch block
            }
            this.ignoreCacheRequests = "true".equalsIgnoreCase(cspcXml.getStringValue("ignore-cache-requests", "false"));
        }
        if (this.allowCspConnect) {
            ((ListenPort)CaProfile.MULTIPLE.getListenPorts().get(0)).setPort(this.httpd.getListenPort());
        } else {
            ((ListenPort)CaProfile.MULTIPLE.getListenPorts().get(0)).setPort(0);
        }
        String warFile = xml.getFileValue("war-file", "cs-status.war", false);
        try {
            this.httpd.setWar(new File(warFile));
        }
        catch (IOException e) {
            throw new ConfigException(xml.getSubConfig("war-file").getFullName(), "Bad war archive '" + warFile + "': " + e, e);
        }
        String indexFile = "cs-status.html";
        try {
            indexFile = xml.getStringValue("welcome-file");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.httpd.setIndexFile(indexFile);
        this.httpd.setSilent(true);
        String logFile = null;
        int count = 0;
        int limit = 0;
        try {
            ProxyXmlConfig logXml = xml.getSubConfig("log-file");
            count = logXml.getIntValue("rotate-count");
            if (count < 1) {
                count = 0;
            }
            if ((limit = logXml.getIntValue("rotate-max-size")) < 1) {
                limit = 0;
            }
        }
        catch (ConfigException e) {
            // empty catch block
        }
        try {
            if (this.httpdLogger != null) {
                this.httpdLogger.close();
            }
            logFile = xml.getFileValue("log-file", true);
            if (count <= 0 || limit <= 0 || !new File(logFile).delete()) {
                // empty if block
            }
            this.httpdLogger = ProxyLogger.getFileLogger("WebBackend", new File(logFile), "FINER", count, limit, true);
            this.httpd.setLogger(this.httpdLogger.getWrappedLogger());
        }
        catch (ConfigException e) {
            this.httpd.setLogger(null);
        }
        catch (IOException e) {
            throw new ConfigException(xml.getSubConfig("log-file").getFullName(), "Unable to assign log-file: " + logFile, e);
        }
        this.superUsers.clear();
        String su = xml.getStringValue("super-users", "");
        if (su.length() > 0) {
            this.superUsers.addAll(Arrays.asList(su.toLowerCase().split(" ")));
        }
        this.httpd.addHttpRequestListener(xmlHandlerPattern, (HttpRequestListener)this);
        this.httpd.addHttpRequestListener(cfgHandlerPattern, (HttpRequestListener)this);
        this.httpd.addHttpRequestListener(bouquetPattern, (HttpRequestListener)this);
        this.httpd.addHttpRequestListener(piconPattern, (HttpRequestListener)this);
        this.httpd.addHttpRequestListener(pluginPattern, (HttpRequestListener)this);
        this.httpd.addHttpRequestListener(connectPattern, (HttpRequestListener)this);
        if (autoStart) {
            try {
                this.start();
            }
            catch (IOException e) {
                throw new ConfigException(xml.getFullName(), "Unable to start httpd: " + e, e);
            }
        }
    }

    public void start() throws IOException {
        this.httpd.start();
    }

    public void stop() {
        if (this.httpd != null) {
            this.httpd.stop();
        }
    }

    private String checkBasicAuth(HttpRequest req) {
        String userPass;
        int idx;
        String basicAuth = req.getHeader("authorization");
        if (basicAuth != null && basicAuth.toLowerCase().startsWith("basic ") && (idx = (userPass = new String(Base64Encoder.decode(basicAuth.substring(6).toCharArray()))).indexOf(":")) > 1) {
            String pass;
            String user = userPass.substring(0, idx);
            if (this.authUser(user, pass = userPass.substring(idx + 1))) {
                return user;
            }
            this.logger.warning("Http auth failed for user '" + user + "' (" + CustomFormatter.formatAddress(req.getRemoteAddress()) + ").");
            SessionManager.getInstance().fireUserLoginFailed(user, "Web/" + CaProfile.MULTIPLE.getName(), req.getRemoteAddress(), "http basic auth failed (bad password)");
            return null;
        }
        return null;
    }

    public HttpResponse doGet(String urlPattern, HttpRequest getRequest) {
        if (xmlHandlerPattern.equals(urlPattern)) {
            HttpResponse resp;
            String cmd;
            String session = getRequest.getCookie("JSESSIONID");
            String user = null;
            boolean newSession = false;
            if (session == null || !this.sessions.containsKey(session)) {
                user = this.checkBasicAuth(getRequest);
                if (user != null) {
                    session = this.createSession(user);
                    newSession = true;
                } else {
                    return HttpResponse.getAuthReqResponse("Cardservproxy");
                }
            }
            if (user == null) {
                user = (String)this.sessions.get(session);
            }
            if ((cmd = getRequest.getParameter("command")) == null) {
                resp = HttpResponse.getErrorResponse(500, "Missing parameter: command");
            } else {
                Map params = getRequest.getParams();
                params.remove("command");
                try {
                    String reply = null;
                    if (this.helper.statusCommands.containsKey(cmd.toLowerCase())) {
                        reply = this.helper.onQryStatusCommand(cmd, params, user);
                    } else if (this.helper.ctrlCommands.containsKey(cmd.toLowerCase())) {
                        reply = this.helper.onQryControlCommand(cmd, params, user);
                    }
                    resp = reply != null ? new HttpResponse(reply, "text/xml") : HttpResponse.getErrorResponse(500, "Unknown command: " + cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resp = HttpResponse.getErrorResponse(e);
                }
            }
            if (newSession) {
                resp.setCookie("JSESSIONID", session);
            }
            resp.setHeader("Expires", new Date(0L));
            return resp;
        }
        if (bouquetPattern.equals(urlPattern)) {
            String bouquet = (String)this.bouquets.get(getRequest.getQueryString());
            if (bouquet == null) {
                return null;
            }
            HttpResponse resp = new HttpResponse(bouquet, "text/plain");
            resp.setHeader("Content-Disposition", "attachment; filename=" + getRequest.getQueryString().substring(1));
            return resp;
        }
        if (piconPattern.equals(urlPattern)) {
            String imgName;
            String[] id;
            if (!this.httpd.fileExists(getRequest.getQueryString()) && (id = (imgName = getRequest.getQueryString().substring(piconPattern.length() - 1)).split("\\.")).length == 3) {
                try {
                    TvService chan = new TvService(Integer.parseInt(id[0]), id[1]);
                    ArrayList services = new ArrayList(this.helper.getServices(null, true));
                    int idx = services.indexOf(chan);
                    if (idx <= -1) {
                        return null;
                    }
                    chan = (TvService)services.get(idx);
                    String piconName = "/picon/" + chan.getName().trim().toLowerCase().replace(' ', '_') + '.' + id[2];
                    if (!this.httpd.fileExists(piconName)) {
                        piconName = "/picon/unknown." + id[2];
                    }
                    getRequest.setQueryString(piconName);
                }
                catch (NumberFormatException e) {
                }
                catch (RemoteException e) {}
            }
        } else {
            if (cfgHandlerPattern.equals(urlPattern)) {
                return HttpResponse.getErrorResponse(405, getRequest.getMethod());
            }
            if (pluginPattern.equals(urlPattern)) {
                try {
                    return this.doPluginAccess(getRequest, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return HttpResponse.getErrorResponse(e);
                }
            }
        }
        return null;
    }

    private void setHostName(String host) {
        String[] s = host.split(":");
        if (s.length > 1) {
            host = s[0];
        }
        CtrlCommand cmd = (CtrlCommand)this.helper.ctrlCommands.get("gen-keystore");
        cmd.getParam("host").setValue(host);
        if (cmd.getParam((String)"validity").value == null) {
            cmd.getParam("validity").setValue("1000");
        }
        if (cmd.getParam((String)"password").value == null) {
            cmd.getParam("password").setValue("123456");
        }
    }

    public HttpResponse doPost(String urlPattern, HttpRequest postRequest) {
        if (bouquetPattern.equals(urlPattern)) {
            return HttpResponse.getErrorResponse(405, postRequest.getMethod());
        }
        if (piconPattern.equals(urlPattern)) {
            return HttpResponse.getErrorResponse(405, postRequest.getMethod());
        }
        if (xmlHandlerPattern.equals(urlPattern)) {
            ByteArrayInputStream is = new ByteArrayInputStream(postRequest.getContent());
            if (this.debugXml) {
                System.out.println("\n<--\n" + new String(postRequest.getContent()));
            }
            try {
                String sessionId;
                this.setHostName(postRequest.getHeader("host"));
                String reply = this.helper.onXMLInput(new XMLConfig(is, false, postRequest.getEncoding()), this.checkBasicAuth(postRequest), postRequest.getRemoteAddress());
                if (this.debugXml) {
                    System.out.println("\n-->\n" + reply);
                }
                HttpResponse resp = new HttpResponse(reply, "text/xml", true);
                XMLConfig replyXml = new XMLConfig(reply, false);
                String string = sessionId = (replyXml = replyXml.getSubConfig("status")) == null ? null : replyXml.getString("session-id");
                if (sessionId != null) {
                    resp.setCookie("JSESSIONID", sessionId);
                }
                return resp;
            }
            catch (XMLConfigException xe) {
                xe.printStackTrace();
                System.out.println(postRequest.getContentStr());
                return HttpResponse.getErrorResponse(xe);
            }
            catch (Exception e) {
                e.printStackTrace();
                return HttpResponse.getErrorResponse(e);
            }
        }
        if (cfgHandlerPattern.equals(urlPattern)) {
            try {
                String session = postRequest.getCookie("JSESSIONID");
                String authUser = session != null && this.sessions.containsKey(session) ? (String)this.sessions.get(session) : this.checkBasicAuth(postRequest);
                if (authUser == null || !this.isSuperUser(authUser)) {
                    return HttpResponse.getErrorResponse(403);
                }
                ProxyXmlConfig currentConfig = new ProxyXmlConfig(new XMLConfig(new ByteArrayInputStream(postRequest.getContent()), false, "UTF-8"));
                ProxyConfig config = ProxyConfig.getInstance();
                config.parseConfig(currentConfig);
                this.logger.info("Configuration updated by: " + authUser + " (" + CustomFormatter.formatAddress(postRequest.getRemoteAddress()) + ")");
                config.saveCfgFile(postRequest.getContent());
                return new HttpResponse(XmlHelper.getCfgResult("Updated configuration installed OK."), "text/xml", true);
            }
            catch (XMLConfigException e) {
                return new HttpResponse(XmlHelper.getCfgResult("Malformed XML: " + e.getMessage() + "\nUpdated configuration NOT installed."), "text/xml", true);
            }
            catch (ConfigException e) {
                StringBuffer sb = new StringBuffer();
                sb.append("Configuration error:\n");
                if (e.getLabel() != null) {
                    if (e.getLabel().indexOf(32) == -1) {
                        sb.append("- Element: <").append(e.getLabel()).append(">\n");
                    } else {
                        sb.append("- Element: <").append(e.getLabel()).append("\n");
                        if (e.getSubLabel() != null) {
                            sb.append("- Attribute: ").append(e.getSubLabel()).append("\n");
                        }
                    }
                }
                sb.append("- Message: ").append(e.getMessage());
                sb.append("\nUpdated configuration NOT installed.");
                return new HttpResponse(XmlHelper.getCfgResult(sb.toString()), "text/xml", true);
            }
            catch (IOException e) {
                return new HttpResponse(XmlHelper.getCfgResult("Updated configuration installed, but an error occured saving to file: " + e), "text/xml", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return HttpResponse.getErrorResponse(e);
            }
        }
        if (pluginPattern.equals(urlPattern)) {
            try {
                return this.doPluginAccess(postRequest, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return HttpResponse.getErrorResponse(e);
            }
        }
        return null;
    }

    private HttpResponse doPluginAccess(HttpRequest req, boolean post) throws RemoteException {
        String[] path;
        String session;
        String authUser = this.checkBasicAuth(req);
        if (authUser == null && (session = req.getCookie("JSESSIONID")) != null) {
            authUser = (String)this.sessions.get(session);
        }
        boolean admin = authUser != null && this.proxy.isAdmin(authUser);
        String qryStr = req.getQueryString();
        if (qryStr.startsWith("/")) {
            qryStr = qryStr.substring(1);
        }
        if ((path = qryStr.split("/")).length < 2) {
            return HttpResponse.getErrorResponse(404);
        }
        Map plugins = ProxyConfig.getInstance().getProxyPlugins();
        if (PLUGIN_SCRIPT.equals(path[1])) {
            if (post) {
                return HttpResponse.getErrorResponse(405, req.getMethod());
            }
            StringBuffer script = new StringBuffer();
            Iterator iter = plugins.values().iterator();
            while (iter.hasNext()) {
                byte[] buf = ((ProxyPlugin)iter.next()).getResource(PLUGIN_SCRIPT, admin);
                if (buf == null) continue;
                try {
                    script.append(new String(buf, "ISO-8859-1"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return new HttpResponse(script.toString(), "application/x-javascript");
        }
        ProxyPlugin plugin = (ProxyPlugin)plugins.get(path[1].toLowerCase());
        if (plugin == null) {
            return HttpResponse.getErrorResponse(404, "No such plugin: " + path[1]);
        }
        boolean open = path.length > 2 && path[2].equals("open");
        String pluginPath = qryStr.substring(path[0].length() + 1 + path[1].length());
        if (!open && authUser == null) {
            return HttpResponse.getAuthReqResponse(plugin.getName());
        }
        byte[] buf = post ? plugin.getResource(pluginPath, req.getContent(), admin) : plugin.getResource(pluginPath, admin);
        return HttpResponse.getFileResponse(buf, pluginPath, this.httpd);
    }

    public HttpResponse doConnect(String urlPattern, HttpRequest connectRequest) {
        if (!connectPattern.equals(urlPattern)) {
            return HttpResponse.getErrorResponse(405, connectRequest.getMethod());
        }
        if (!this.allowCspConnect) {
            return HttpResponse.getErrorResponse(503);
        }
        ProxyConfig config = ProxyConfig.getInstance();
        String authUser = this.checkBasicAuth(connectRequest);
        if (authUser == null) {
            return HttpResponse.getAuthReqResponse("Cardservproxy");
        }
        String ip = connectRequest.getRemoteAddress();
        ListenPort listenPort = (ListenPort)CaProfile.MULTIPLE.getListenPorts().get(0);
        if (listenPort.isDenied(ip)) {
            this.logger.fine("Rejected connection for [" + listenPort.getProfile().getName() + ":" + listenPort + "]: " + CustomFormatter.formatAddress(ip) + " not allowed.");
            SessionManager.getInstance().fireUserLoginFailed("?@" + ip, listenPort + "/" + CaProfile.MULTIPLE.getName(), ip, "rejected by [" + listenPort + "] ip deny list.");
            return HttpResponse.getErrorResponse(403, "Ip denied");
        }
        String ipMask = config.getUserManager().getIpMask(authUser);
        if (!Globber.match(ipMask, ip, false)) {
            if (config.isLogFailures()) {
                this.logger.warning("User '" + authUser + "' (" + CustomFormatter.formatAddress(ip) + ") login denied, ip check failed: " + ipMask);
            }
            SessionManager.getInstance().fireUserLoginFailed(authUser, listenPort + "/" + CaProfile.MULTIPLE.getName(), ip, "ip check failed: " + ipMask);
            return HttpResponse.getErrorResponse(403, "Ip check failed");
        }
        this.acceptCspConnect(authUser, connectRequest);
        return HttpResponse.CONNECT_RESPONSE;
    }

    public void acceptCspConnect(String user, HttpRequest connectRequest) {
        ProxyConfig config = ProxyConfig.getInstance();
        ListenPort lp = (ListenPort)CaProfile.MULTIPLE.getListenPorts().get(0);
        CspSession ps = null;
        try {
            ps = new CspSession(connectRequest, user, lp, config.getDefaultMsgListener(), !this.ignoreCacheRequests);
        }
        catch (Exception e) {
            this.logger.severe("Exception creating CspSession: " + e, e);
        }
        if (ps == null) {
            try {
                connectRequest.getConnection().close();
            }
            catch (Exception e) {}
        } else if (config.getRemoteHandler() != null) {
            ps.addTransactionListener(ProxyConfig.getInstance().getRemoteHandler());
        }
    }

    boolean authUser(String userName, String passwd) {
        try {
            return this.proxy.authenticateUser(userName, passwd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    String createSession(String user) {
        this.logger.info("User '" + user + "' logged in.");
        String sessionId = Long.toString(System.currentTimeMillis(), 36);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            sessionId = new String(Base64Encoder.encode(md.digest(sessionId.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        this.sessions.put(sessionId, user);
        return sessionId;
    }

    public void eventRaised(RemoteEvent event) throws RemoteException {
        if (event == null) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                this.connecting.remove(event.getLabel());
                this.invalid.remove(event.getLabel());
                this.eventLog.add(0, event);
                break;
            }
            case 4: {
                if (this.connecting.contains(event.getLabel())) break;
                this.connecting.add(event.getLabel());
                this.eventLog.add(0, event);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                this.eventLog.add(0, event);
                break;
            }
            case -2: 
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            case 7: {
                this.logUserTransaction(event);
                if (event.getProperty("cws-name") != null) {
                    this.logCwsTransaction(event);
                }
                if (!"true".equalsIgnoreCase(event.getProperty("warning"))) break;
                this.addWarning(event);
                break;
            }
            case 8: {
                if (this.invalid.contains(event.getLabel())) break;
                this.invalid.add(event.getLabel());
                this.eventLog.add(0, event);
                break;
            }
            case 11: {
                this.fileLog.add(0, event);
                break;
            }
            default: {
                System.err.println("Unknown remote event received: " + event.getType() + " " + event.getLabel() + " " + event.getMessage());
            }
        }
        if (this.eventLog.size() > 40) {
            this.eventLog.remove(this.eventLog.size() - 1);
        }
        if (this.fileLog.size() > 40) {
            this.fileLog.remove(this.fileLog.size() - 1);
        }
    }

    private void logUserTransaction(RemoteEvent event) {
        ArrayList<RemoteEvent> ecmLog = (ArrayList<RemoteEvent>)this.userTransactions.get(event.getMessage());
        if (ecmLog == null) {
            ecmLog = new ArrayList<RemoteEvent>();
            this.userTransactions.put(event.getMessage(), ecmLog);
        }
        ecmLog.add(0, new RemoteEvent(event));
        if (ecmLog.size() > 100) {
            ecmLog.remove(ecmLog.size() - 1);
        }
    }

    private void logCwsTransaction(RemoteEvent event) {
        String flags = event.getProperty("flags");
        if (flags == null) {
            return;
        }
        if (flags.indexOf(70) == -1 && flags.indexOf(84) == -1) {
            return;
        }
        ArrayList<RemoteEvent> ecmLog = (ArrayList<RemoteEvent>)this.cwsTransactions.get(event.getProperty("cws-name"));
        if (ecmLog == null) {
            ecmLog = new ArrayList<RemoteEvent>();
            this.cwsTransactions.put(event.getProperty("cws-name"), ecmLog);
        }
        ecmLog.add(0, new RemoteEvent(event));
        if (ecmLog.size() > 100) {
            ecmLog.remove(ecmLog.size() - 1);
        }
    }

    private void addWarning(RemoteEvent ev) {
        int idx = this.warningLog.indexOf(ev);
        if (idx > -1) {
            RemoteEvent prev = (RemoteEvent)this.warningLog.remove(idx);
            int count = 1;
            try {
                count += Integer.parseInt(prev.getProperty("count"));
            }
            catch (Exception e) {
                ++count;
            }
            ev.setProperty("count", String.valueOf(count));
        }
        this.warningLog.add(0, ev);
        if (this.warningLog.size() > 40) {
            this.warningLog.remove(this.warningLog.size() - 1);
        }
    }

    public boolean isSuperUser(String user) {
        if (user == null) {
            return false;
        }
        try {
            return this.superUsers.contains(user.toLowerCase()) && this.proxy.isAdmin(user);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void clearTransactions(String profile) {
        if (profile == null) {
            this.userTransactions.clear();
            this.cwsTransactions.clear();
        } else {
            this.clearTransactions(profile, this.userTransactions);
            this.clearTransactions(profile, this.cwsTransactions);
        }
    }

    private void clearTransactions(String profile, Map map) {
        Iterator iter = new ArrayList(map.keySet()).iterator();
        while (iter.hasNext()) {
            String user = (String)iter.next();
            List list = (List)map.get(user);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                RemoteEvent ev = (RemoteEvent)i.next();
                if (!profile.equals(ev.getProfile())) continue;
                i.remove();
            }
        }
    }
}

