/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CacheCoverageMap;
import com.bowman.cardserv.CacheForwarder;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.ServiceCacheEntry;
import com.bowman.cardserv.SourceCacheEntry;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CacheListener;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.Command;
import com.bowman.cardserv.web.XmlHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CacheCoveragePlugin
implements ProxyPlugin,
CacheListener {
    protected static final int DEFAULT_CW_VALIDITY = 10000;
    protected ProxyLogger logger;
    protected CacheHandler cache;
    protected CardServProxy proxy;
    private Map cacheMaps = new TreeMap();
    private Map dcwIntervals = new HashMap();
    private ProxyConfig config = ProxyConfig.getInstance();
    private Set commands = new HashSet();
    private Map forwarders = new TreeMap();
    private Map sources = new TreeMap();

    public CacheCoveragePlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        Iterator iter = xml.getMultipleSubConfigs("cache-context");
        while (iter.hasNext()) {
            ProxyXmlConfig contextXml = (ProxyXmlConfig)iter.next();
            String key = CaProfile.getKeyStr((int)Integer.parseInt(contextXml.getStringValue("network-id"), 16), (int)Integer.parseInt(contextXml.getStringValue("ca-id"), 16));
            int iv = contextXml.getTimeValue("interval", 10, "s");
            this.dcwIntervals.put(key, new Integer(iv));
        }
        Iterator iter2 = xml.getMultipleSubConfigs("cache-forwarder");
        while (iter2.hasNext()) {
            ProxyXmlConfig forwarderXml = (ProxyXmlConfig)iter2.next();
            String name = forwarderXml.getStringValue("name");
            CacheForwarder forwarder = (CacheForwarder)this.forwarders.get(name);
            if (forwarder == null) {
                forwarder = new CacheForwarder(this, name);
                this.forwarders.put(name, forwarder);
            }
            forwarder.configUpdated(forwarderXml);
        }
    }

    public boolean lockRequest(int successFactor, CamdNetMessage request) {
        return false;
    }

    public void onRequest(int successFactor, CamdNetMessage request) {
    }

    public int getCwValidityTime(String key) {
        if (this.dcwIntervals.containsKey(key)) {
            return (Integer)this.dcwIntervals.get(key);
        }
        return 10000;
    }

    public void onReply(CamdNetMessage request, CamdNetMessage reply) {
        if (this.replyStat(request, reply) && !this.forwarders.isEmpty()) {
            this.forwardReply(request, reply);
        }
    }

    public boolean replyStat(CamdNetMessage request, CamdNetMessage reply) {
        ServiceCacheEntry entry = this.getServiceEntry(request);
        SourceCacheEntry source = this.getSourceEntry(request);
        return entry.update(request, reply, source);
    }

    private ServiceCacheEntry getServiceEntry(CamdNetMessage request) {
        CacheCoverageMap map;
        String profileKey = CaProfile.getKeyStr((int)request.getNetworkId(), (int)request.getCaId());
        TvService ts = this.config.getService(request);
        if (ts.getProfileName() == null || "*".equals(ts.getProfileName())) {
            ts = new TvService(ts, 0L, profileKey);
        }
        int validity = this.getCwValidityTime(profileKey);
        if (this.cacheMaps.containsKey(profileKey)) {
            map = (CacheCoverageMap)this.cacheMaps.get(profileKey);
        } else {
            map = new CacheCoverageMap(profileKey, validity * 2);
            this.cacheMaps.put(profileKey, map);
        }
        ServiceCacheEntry entry = (ServiceCacheEntry)map.get(ts);
        if (entry == null) {
            entry = new ServiceCacheEntry(ts, request, validity, map);
            map.put(ts, entry);
        }
        return entry;
    }

    private SourceCacheEntry getSourceEntry(CamdNetMessage request) {
        String sourceStr = SourceCacheEntry.getSourceStr(request);
        SourceCacheEntry entry = (SourceCacheEntry)this.sources.get(sourceStr);
        if (entry == null) {
            entry = new SourceCacheEntry(sourceStr);
            this.sources.put(sourceStr, entry);
            if (entry.isLocal()) {
                List list = SessionManager.getInstance().getSessionsIP(entry.ipStr);
                if (list != null) {
                    if (!list.isEmpty()) {
                        entry.label = list.iterator().next().toString();
                    }
                    if (list.size() > 1) {
                        entry.label = entry.label + " (" + list.size() + ")";
                    }
                }
            } else {
                entry.label = "Remote ClusteredCache";
            }
        }
        return entry;
    }

    public void forwardReply(CamdNetMessage request, CamdNetMessage reply) {
        CaProfile profile;
        if (request.getProfileName() == null && (profile = this.config.getProfileById(request.getNetworkId(), request.getCaId())) != null) {
            request.setProfileName(profile.getName());
        }
        Iterator iter = this.forwarders.values().iterator();
        while (iter.hasNext()) {
            CacheForwarder forwarder = (CacheForwarder)iter.next();
            if (!forwarder.isConnected()) continue;
            forwarder.forwardReply(request, reply);
        }
    }

    public void start(CardServProxy proxy) {
        this.cache = this.config.getCacheHandler();
        if (this.cache != null) {
            this.cache.setMonitor((CacheListener)this);
        }
        if (this.commands.isEmpty()) {
            this.registerCommands();
        }
        this.proxy = proxy;
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.setMonitor(null);
        }
        this.unregisterCommands();
        Iterator iter = this.forwarders.values().iterator();
        while (iter.hasNext()) {
            ((CacheForwarder)iter.next()).close();
        }
    }

    private void registerCommands() {
        try {
            this.commands.addAll(XmlHelper.registerStatusCommands((InputStream)CacheCoveragePlugin.class.getResourceAsStream("status-commands.xml"), (Object)this, null));
        }
        catch (Exception e) {
            this.logger.severe("Failed to load/parse internal status commands (status-commands.xml).", (Throwable)e);
        }
    }

    private void unregisterCommands() {
        Iterator iter = this.commands.iterator();
        while (iter.hasNext()) {
            Command cmd = (Command)iter.next();
            cmd.unregister();
            iter.remove();
        }
    }

    public String getName() {
        return "CacheCoveragePlugin";
    }

    public String getDescription() {
        return "Assists with cache monitoring and propagation.";
    }

    public Properties getProperties() {
        Properties p = new Properties();
        Iterator iter = this.cacheMaps.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            TreeSet set = new TreeSet(((Map)this.cacheMaps.get(key)).values());
            p.setProperty(key, set.size() + " services");
        }
        return p;
    }

    public void runStatusCmdCacheForwarders(XmlStringBuffer xb) {
        this.xmlFormatCacheForwarders(xb);
    }

    public void runStatusCmdCacheContents(XmlStringBuffer xb, Map params) {
        Set<Object> excludedKeys;
        boolean hideExpired = "true".equals(params.get("hide-expired"));
        boolean showMissing = "true".equals(params.get("show-missing"));
        String sourceStr = (String)params.get("source-filter");
        String excludeStr = (String)params.get("exclude-keys");
        Set<Object> set = excludedKeys = excludeStr == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(excludeStr.split(",")));
        if ("".equals(sourceStr)) {
            sourceStr = null;
        }
        SourceCacheEntry source = null;
        if (sourceStr != null) {
            source = (SourceCacheEntry)this.sources.get(sourceStr.toUpperCase());
        }
        this.xmlFormatCacheContents(xb, hideExpired, showMissing, source, excludedKeys);
    }

    public void runStatusCmdServiceBacklog(XmlStringBuffer xb, Map params) {
        int sid = -1;
        String sidStr = (String)params.get("sid");
        sid = sidStr.startsWith("0x") ? Integer.parseInt(sidStr.substring(2), 16) : Integer.parseInt(sidStr);
        int onid = Integer.parseInt((String)params.get("onid"), 16);
        int caid = Integer.parseInt((String)params.get("caid"), 16);
        String profileKey = CaProfile.getKeyStr((int)onid, (int)caid);
        Map map = (Map)this.cacheMaps.get(profileKey);
        CaProfile profile = this.config.getProfileById(onid, caid);
        String profileName = profile == null ? null : profile.getName();
        TvService ts = this.config.getService(profileName, sid);
        if (ts.getProfileName() == null || "*".equals(ts.getProfileName())) {
            ts = new TvService(ts, 0L, profileKey);
        }
        this.xmlFormatServiceBacklog(xb, (ServiceCacheEntry)map.get(ts));
    }

    public void runStatusCmdCacheSources(XmlStringBuffer xb, Map params) {
        boolean hideLocal = "true".equals(params.get("hide-local"));
        String name = (String)params.get("name");
        this.xmlFormatCacheSources(xb, hideLocal, name);
    }

    public void runStatusCmdListTransponders(XmlStringBuffer xb, Map params) {
        String profile = (String)params.get("profile");
        String tidStr = (String)params.get("tid");
        int tid = -1;
        if (tidStr != null) {
            tid = tidStr.startsWith("0x") ? Integer.parseInt(tidStr.substring(2), 16) : Integer.parseInt(tidStr);
        }
        if (profile != null) {
            this.xmlFormatTransponderList(xb, profile, tid);
        }
    }

    public void xmlFormatTransponderList(XmlStringBuffer xb, String profileName, int tidFilter) {
        xb.appendElement("transponder-list", "profile", profileName);
        CaProfile profile = this.config.getProfile(profileName);
        if (profile != null) {
            TransponderEntry entry;
            Map allServices = profile.getServices();
            TreeMap<String, TransponderEntry> tpMap = new TreeMap<String, TransponderEntry>();
            Iterator iter = allServices.values().iterator();
            while (iter.hasNext()) {
                TvService ts = (TvService)iter.next();
                String key = profileName + "-" + Long.toHexString(ts.getTransponder());
                entry = (TransponderEntry)tpMap.get(key);
                if (entry == null) {
                    entry = new TransponderEntry(ts.getTransponder(), profileName);
                    tpMap.put(key, entry);
                }
                entry.addService(ts);
            }
            xb.appendAttr("count", tpMap.size());
            xb.endElement(false);
            iter = tpMap.values().iterator();
            while (iter.hasNext()) {
                entry = (TransponderEntry)iter.next();
                if (tidFilter == -1) {
                    this.xmlFormatTransponder(xb, entry);
                    continue;
                }
                if ((long)tidFilter != entry.tid) continue;
                this.xmlFormatTransponder(xb, entry);
            }
        }
        xb.closeElement("transponder-list");
    }

    public void xmlFormatTransponder(XmlStringBuffer xb, TransponderEntry entry) {
        xb.appendElement("transponder", "id", (int)entry.tid);
        xb.appendAttr("service-count", entry.services.size());
        xb.appendAttr("sd-count", entry.sd);
        xb.appendAttr("hd-count", entry.hd);
        xb.appendAttr("radio-count", entry.radio);
        xb.endElement(false);
        XmlHelper.xmlFormatServices((TvService[])entry.services.toArray(new TvService[entry.services.size()]), (XmlStringBuffer)xb, (boolean)false, (boolean)false, null);
        xb.closeElement("transponder");
    }

    public void xmlFormatCacheContents(XmlStringBuffer xb, boolean hideExpired, boolean showMissing, SourceCacheEntry filter, Set excludedKeys) {
        xb.appendElement("cache-contents", "contexts", this.cacheMaps.size());
        xb.appendAttr("sources", this.sources.size());
        xb.endElement(false);
        Iterator iter = this.cacheMaps.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String[] s = key.split("-");
            CacheCoverageMap map = (CacheCoverageMap)this.cacheMaps.get(key);
            xb.appendElement("cache-context", "key", key);
            CaProfile profile = this.getProfileByKey(key);
            if (profile != null) {
                xb.appendAttr("local-name", profile.getName());
            }
            xb.appendAttr("onid", s[0]);
            xb.appendAttr("caid", s[1]);
            xb.appendAttr("expected-interval", this.getCwValidityTime(key));
            xb.appendAttr("total-seen", map.size());
            xb.endElement(false);
            if (!excludedKeys.contains(key)) {
                TreeSet set = new TreeSet(map.values());
                if (profile != null && showMissing) {
                    Iterator i = profile.getServices().values().iterator();
                    while (i.hasNext()) {
                        TvService ts = (TvService)i.next();
                        if (!ts.isTv() || ts.getType() == 2 || map.containsKey(ts)) continue;
                        set.add(new ServiceCacheEntry(ts, null, this.getCwValidityTime(key), map));
                    }
                }
                CacheCoveragePlugin.xmlFormatCacheContext(xb, set, hideExpired, filter);
            }
            xb.closeElement("cache-context");
        }
        xb.closeElement("cache-contents");
    }

    public void xmlFormatCacheForwarders(XmlStringBuffer xb) {
        xb.appendElement("cache-forwarders", "count", this.forwarders.size());
        Iterator iter = this.forwarders.values().iterator();
        while (iter.hasNext()) {
            CacheForwarder forwarder = (CacheForwarder)iter.next();
            xb.appendElement("forwarder", "name", forwarder.getName());
            xb.appendAttr("connected", forwarder.isConnected());
            xb.appendAttr("max-delay", forwarder.getMaxDelay());
            xb.appendAttr("avg-latency", forwarder.getAvgLatency());
            xb.appendAttr("peak-latency", forwarder.getPeakLatency());
            xb.appendAttr("avg-msize", forwarder.getAvgMsgSize());
            xb.appendAttr("peak-msize", forwarder.getPeakMsgSize());
            xb.appendAttr("cur-qsize", forwarder.getSendQSize());
            xb.appendAttr("msg-count", forwarder.getCount());
            xb.appendAttr("filtered", forwarder.getFiltered());
            xb.appendAttr("avg-sent-rate", forwarder.getSentAvg());
            xb.appendAttr("avg-recv-rate", forwarder.getRecvAvg());
            xb.appendAttr("ecms", forwarder.getEcmForwards());
            xb.appendAttr("delay-alerts", forwarder.getDelayAlerts());
            xb.appendAttr("reconnects", forwarder.getReconnects());
            xb.appendAttr("errors", forwarder.getErrors());
            Map ri = forwarder.getRemoteInstances();
            if (!ri.isEmpty()) {
                xb.endElement(false);
                this.xmlFormatRemoteInstances(xb, ri);
                xb.closeElement("forwarder");
                continue;
            }
            xb.endElement(true);
        }
        xb.closeElement("cache-forwarders");
    }

    public void xmlFormatRemoteInstances(XmlStringBuffer xb, Map ri) {
        Iterator iter = ri.keySet().iterator();
        while (iter.hasNext()) {
            String instance = (String)iter.next();
            Properties p = (Properties)ri.get(instance);
            xb.appendElement("remote-instance", "id", instance);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if ("tstamp".equals(name)) {
                    long timeStamp = Long.parseLong(p.getProperty(name));
                    xb.appendAttr("last-update", XmlHelper.formatDurationFrom((long)timeStamp));
                    continue;
                }
                xb.appendAttr(name, p.getProperty(name));
            }
            xb.endElement(true);
        }
    }

    public void xmlFormatCacheSources(XmlStringBuffer xb, boolean hideLocal, String name) {
        xb.appendElement("cache-sources", "count", this.sources.size());
        Iterator iter = this.sources.values().iterator();
        while (iter.hasNext()) {
            SourceCacheEntry source = (SourceCacheEntry)iter.next();
            if (hideLocal && source.isLocal() || name != null && !source.sourceStr.equalsIgnoreCase(name)) continue;
            xb.appendElement("source", "name", source.sourceStr);
            xb.appendAttr("label", source.label);
            xb.appendAttr("update-count", source.updateCount);
            xb.appendAttr("aborts", source.abortCount);
            xb.appendAttr("overwrites", source.overwriteCount);
            xb.appendAttr("duplicates", source.duplicateCount);
            xb.endElement(true);
        }
        xb.closeElement("cache-sources");
    }

    public void xmlFormatServiceBacklog(XmlStringBuffer xb, ServiceCacheEntry entry) {
        if (entry == null) {
            return;
        }
        Map backLog = entry.getBackLog();
        xb.appendElement("service-backlog", "size", backLog.size());
        xb.appendAttr("label", entry.ts.toString());
        xb.endElement(false);
        xb.appendElement("current-sources", "window-size", 60);
        Iterator iter = entry.getSources(true).iterator();
        while (iter.hasNext()) {
            SourceCacheEntry source = (SourceCacheEntry)iter.next();
            xb.appendElement("source", "name", source.sourceStr);
            xb.appendAttr("label", source.label);
            xb.endElement(true);
        }
        xb.closeElement("current-sources");
        ArrayList list = new ArrayList(backLog.keySet());
        Collections.reverse(list);
        long prev = -1L;
        long first = -1L;
        Iterator iter2 = list.iterator();
        while (iter2.hasNext()) {
            CamdNetMessage request = (CamdNetMessage)iter2.next();
            CamdNetMessage reply = (CamdNetMessage)backLog.get(request);
            if (first == -1L) {
                first = request.getTimeStamp();
            }
            xb.appendElement("request", "hash", request.hashCodeStr());
            xb.appendAttr("tag", Integer.toHexString(request.getCommandTag()));
            xb.appendAttr("offset", prev == -1L ? 0L : prev - request.getTimeStamp());
            xb.appendAttr("age", first - request.getTimeStamp());
            xb.appendAttr("source", SourceCacheEntry.getSourceStr(request));
            xb.endElement(false);
            xb.appendElement("reply", "data", DESUtil.bytesToString((byte[])reply.getCustomData()));
            xb.appendAttr("source", SourceCacheEntry.getSourceStr(reply));
            xb.endElement(true);
            xb.closeElement("request");
            prev = request.getTimeStamp();
        }
        xb.closeElement("service-backlog");
    }

    public CaProfile getProfileByKey(String key) {
        String[] pair = key.split("-");
        return this.config.getProfileById(Integer.parseInt(pair[0], 16), Integer.parseInt(pair[1], 16));
    }

    public static void xmlFormatCacheContext(XmlStringBuffer xb, Set entries, boolean hideExpired, SourceCacheEntry filter) {
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            ServiceCacheEntry sce = (ServiceCacheEntry)iter.next();
            if (hideExpired && sce.isExpired() || sce.request != null && filter != null && !sce.getSources(false).contains(filter)) continue;
            int avgInterval = sce.getAvgInterval();
            int avgVariance = sce.getAvgVariance();
            xb.appendElement("service");
            xb.appendAttr("name", sce.ts.getName());
            xb.appendAttr("id", sce.ts.getId());
            if (sce.ts.getTransponder() != -1L) {
                xb.appendAttr("tid", sce.ts.getTransponder());
            }
            xb.appendAttr("expired", sce.isExpired());
            xb.appendAttr("update-count", sce.getUpdateCount());
            xb.appendAttr("continuity-errors", sce.getContinuityErrors());
            xb.appendAttr("total-continuity-errors", sce.getContinuityErrorsTotal());
            xb.appendAttr("avg-interval", avgInterval == -1 ? "?" : String.valueOf(avgInterval));
            xb.appendAttr("avg-variance", avgVariance == -1 ? "?" : String.valueOf(avgVariance));
            if (sce.request != null) {
                xb.appendAttr("age", sce.getAge());
            } else {
                xb.appendAttr("missing", "true");
            }
            if (sce.getMultiple() > 0) {
                xb.appendAttr("multiple", sce.getMultiple());
            }
            if (sce.getOverwriteCount() > 0) {
                xb.appendAttr("overwrites", sce.getOverwriteCount());
            }
            if (sce.getDuplicateCount() > 0) {
                xb.appendAttr("duplicates", sce.getDuplicateCount());
            }
            if (sce.getAbortCount() > 0) {
                xb.appendAttr("aborts", sce.getAbortCount());
            }
            xb.appendAttr("offset", sce.getTimeOffset() == -1L ? "?" : String.valueOf(sce.getTimeOffset()));
            xb.appendAttr("sources", sce.getSources(false).size());
            xb.closeElement();
        }
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            InputStream is = CacheCoveragePlugin.class.getResourceAsStream("/web/" + path);
            if (is == null) {
                return null;
            }
            DataInputStream dis = new DataInputStream(is);
            byte[] buf = new byte[dis.available()];
            dis.readFully(buf);
            return buf;
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }

    static class TransponderEntry {
        long tid;
        String profile;
        int radio;
        int sd;
        int hd;
        Set services = new TreeSet();

        TransponderEntry(long tid, String profile) {
            this.tid = tid;
            this.profile = profile;
        }

        void addService(TvService ts) {
            switch (ts.getType()) {
                case 1: {
                    ++this.sd;
                    break;
                }
                case 17: 
                case 25: {
                    ++this.hd;
                    break;
                }
                case 2: {
                    ++this.radio;
                }
            }
            this.services.add(ts);
        }
    }
}

