/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.ServiceCacheEntry;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.util.TimedAverageList;

public class SourceCacheEntry
implements Comparable {
    int updateCount;
    int abortCount;
    int duplicateCount;
    int overwriteCount;
    String sourceStr;
    String ipStr;
    String label;
    private TimedAverageList discards = new TimedAverageList(60);
    private MessageCacheMap overwrites = new MessageCacheMap(60000L);

    public SourceCacheEntry(String sourceStr) {
        this.sourceStr = sourceStr;
        this.ipStr = sourceStr.substring(2);
        this.label = "?";
    }

    public static String getSourceStr(CamdNetMessage request) {
        if (request.getRemoteAddress() == null) {
            return "R:" + request.getOriginAddress();
        }
        return "L:" + request.getRemoteAddress();
    }

    public String toString() {
        return this.sourceStr;
    }

    public boolean isLocal() {
        return this.sourceStr.startsWith("L");
    }

    public void reportOverWrite(ServiceCacheEntry entry, CamdNetMessage newRequest, CamdNetMessage oldReply, CamdNetMessage newReply) {
        ++this.overwriteCount;
        this.overwrites.put((Object)newRequest, (Object)new ReplyTuple(newReply, oldReply));
        System.out.println(entry + " " + this.overwrites);
    }

    public void reportDuplicate(ServiceCacheEntry entry, CamdNetMessage newRequest, CamdNetMessage oldReply) {
        if (this.sourceStr.equals(SourceCacheEntry.getSourceStr(oldReply))) {
            ++this.duplicateCount;
        } else {
            this.discards.addRecord((int)(newRequest.getTimeStamp() - oldReply.getTimeStamp()));
        }
    }

    public int compareTo(Object o) {
        return this.sourceStr.compareTo(((SourceCacheEntry)o).sourceStr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceCacheEntry that = (SourceCacheEntry)o;
        return this.sourceStr.equals(that.sourceStr);
    }

    public int hashCode() {
        return this.sourceStr.hashCode();
    }

    static class ReplyTuple {
        CamdNetMessage newReply;
        CamdNetMessage oldReply;

        ReplyTuple(CamdNetMessage newReply, CamdNetMessage oldReply) {
            this.newReply = newReply;
            this.oldReply = oldReply;
        }

        public String toString() {
            return "\n" + DESUtil.bytesToString((byte[])this.oldReply.getCustomData()) + "\n" + DESUtil.bytesToString((byte[])this.newReply.getCustomData());
        }
    }
}

