/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.appletgui;

import com.bowman.appletgui.CharsetHandler;
import com.bowman.util.BowSort;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class BowList
extends Canvas
implements AdjustmentListener {
    private CharsetHandler csh;
    private Dimension slSize;
    private Vector slItems;
    private Vector strImages;
    private List visibleItems;
    private Image slImage;
    private int xInset;
    private int yInset;
    private int effLen;
    private int vAdjust;
    private int selLine;
    private int maxLines;
    private String selStr;
    private boolean selectable;
    private boolean bottomUp;
    private Color fgCol;
    private Color bgCol;
    private Color hiCol;
    private Scrollbar scroller;
    private int scrollPos;
    private Graphics bBuf;
    private Image tmpImg;

    public BowList(Dimension d) {
        this.slSize = d;
        this.selStr = null;
        this.xInset = 5;
        this.yInset = 4;
        this.maxLines = 300;
        this.slItems = new Vector();
        this.strImages = new Vector();
        this.vAdjust = 4;
        this.selectable = true;
        this.bottomUp = false;
        this.effLen = this.slSize.width - this.xInset * 2;
        this.scrollPos = 0;
        this.enableEvents(16L);
        this.enableEvents(8L);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.hiCol = Color.gray;
        this.repaint();
    }

    private void bubbleSort() {
        int i;
        String[] strs = new String[this.slItems.size()];
        for (i = 0; i < this.slItems.size(); ++i) {
            strs[i] = (String)this.slItems.elementAt(i);
        }
        strs = BowSort.sort(strs);
        this.slItems.clear();
        this.strImages.clear();
        for (i = 0; i < strs.length; ++i) {
            this.slItems.addElement(strs[i]);
        }
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.fgCol = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.bgCol = c;
    }

    public void setHilight(Color c) {
        this.hiCol = c;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    public void toggleScrollDir() {
        this.bottomUp = !this.bottomUp;
    }

    private void setSelected(Point p) {
        if (!this.selectable) {
            return;
        }
        int mh = this.csh.getMaxHeight();
        this.requestFocus();
        this.selLine = (p.y - this.vAdjust) / mh + this.scrollPos * mh;
        try {
            this.selStr = (String)this.slItems.elementAt(this.selLine);
        }
        catch (Exception e) {
            this.selStr = null;
        }
        this.repaint();
    }

    public void remove(String s) {
        int pos = this.slItems.indexOf(s);
        if (pos >= 0) {
            this.slItems.removeElementAt(pos);
            this.strImages.removeElementAt(pos);
            if (this.scroller != null) {
                this.scroller.setMaximum(this.slItems.size() - 1);
                if (this.bottomUp) {
                    this.scroller.setValue(this.slItems.size());
                } else {
                    this.scroller.setValue(0);
                }
                this.scrollPos = 0;
            }
            this.bubbleSort();
            this.repaint();
        }
    }

    public void change(String oldStr, String newStr) {
        int pos = this.slItems.indexOf(oldStr);
        if (pos >= 0) {
            this.slItems.setElementAt(newStr, pos);
            this.strImages.setElementAt(null, pos);
            this.bubbleSort();
            this.repaint();
        }
    }

    public void add(String s) {
        if (s.length() == 0) {
            return;
        }
        String wrapPad = "  ";
        int breakCharIdx = this.csh.measureString(s, this.effLen);
        if (breakCharIdx > 0) {
            int spaceIdx = s.substring(0, breakCharIdx).lastIndexOf(32);
            if (spaceIdx < breakCharIdx / 2) {
                spaceIdx = breakCharIdx - 1;
            }
            this.addString(s.substring(0, spaceIdx));
            s = s.substring(spaceIdx, s.length());
            while (!s.startsWith("  ")) {
                s = " " + s;
            }
            this.add(s);
        } else {
            this.addString(s);
        }
    }

    private void addString(String s) {
        if (this.bottomUp) {
            this.slItems.insertElementAt(s, 0);
            this.strImages.insertElementAt(null, 0);
            if (this.getItemCount() > this.maxLines) {
                this.slItems.removeElementAt(this.slItems.size() - 1);
                this.strImages.removeElementAt(this.strImages.size() - 1);
            }
        } else {
            this.slItems.addElement(s);
            this.strImages.addElement(null);
            if (this.getItemCount() > this.maxLines) {
                this.slItems.removeElementAt(0);
                this.strImages.removeElementAt(0);
            }
        }
        if (this.scroller != null) {
            this.scroller.setMaximum(this.slItems.size() - 1);
            if (this.bottomUp) {
                this.scroller.setValue(this.slItems.size());
            } else {
                this.scroller.setValue(0);
            }
            this.scrollPos = 0;
        }
        if (this.selectable) {
            this.bubbleSort();
        }
        this.repaint();
    }

    public void removeAll() {
        if (this.scroller != null) {
            this.scroller.setMaximum(1);
        }
        this.slItems.removeAllElements();
        for (int i = 0; i < this.strImages.size(); ++i) {
            ((Image)this.strImages.elementAt(i)).flush();
        }
        this.strImages.removeAllElements();
        this.repaint();
    }

    public String getSelectedItem() {
        return this.selStr;
    }

    public String getElementAt(int idx) {
        if (idx > 0 && idx < this.slItems.size()) {
            return (String)this.slItems.elementAt(idx);
        }
        return null;
    }

    public int getItemCount() {
        return this.slItems.size();
    }

    public void setCharset(CharsetHandler ch) {
        this.csh = ch;
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }

    public void paint(Graphics g) {
        if (g == null || this.csh == null) {
            return;
        }
        if (this.bBuf == null) {
            this.slImage = this.createImage(this.slSize.width, this.slSize.height);
            this.bBuf = this.slImage.getGraphics();
        }
        this.bBuf.clearRect(0, 0, this.slSize.width, this.slSize.height);
        int mh = this.csh.getMaxHeight();
        int mw = this.csh.getMaxWidth();
        int maxVisible = this.slSize.height / mh;
        for (int i = 0; i < Math.min(this.slItems.size() - this.scrollPos, maxVisible); ++i) {
            int yOffset;
            this.bBuf.setColor(this.fgCol);
            String cuStr = (String)this.slItems.elementAt(i + this.scrollPos);
            if (this.strImages.size() < this.slItems.size()) {
                this.strImages.setSize(this.slItems.size());
            }
            if (this.strImages.elementAt(i + this.scrollPos) == null) {
                this.tmpImg = this.createImage(cuStr.length() * mw, mh);
                this.csh.drawString(cuStr, this.tmpImg.getGraphics(), 0, 0);
                this.strImages.setElementAt(this.tmpImg, i + this.scrollPos);
            }
            int n = yOffset = this.bottomUp ? this.slSize.height - (this.yInset + mh * (i + 1)) : this.yInset + mh * i;
            if (cuStr == this.selStr) {
                this.bBuf.setColor(this.hiCol);
                this.bBuf.fillRect(0, mh * i + this.vAdjust, this.slSize.width, mh);
                this.bBuf.setColor(this.fgCol);
                this.csh.drawString(cuStr, this.bBuf, this.xInset, yOffset);
                continue;
            }
            this.bBuf.drawImage((Image)this.strImages.elementAt(i + this.scrollPos), this.xInset, yOffset, this);
        }
        this.bBuf.setColor(this.fgCol);
        g.drawImage(this.slImage, 0, 0, this);
    }

    public void processKeyEvent(KeyEvent ke) {
        if (ke.getID() == 401) {
            switch (ke.getKeyCode()) {
                case 40: {
                    if (this.selLine < this.slItems.size() - 1) {
                        this.selStr = (String)this.slItems.elementAt(++this.selLine);
                    }
                    this.repaint();
                    break;
                }
                case 38: {
                    if (this.selLine > 0) {
                        this.selStr = (String)this.slItems.elementAt(--this.selLine);
                    }
                    this.repaint();
                }
            }
        }
    }

    public void processMouseEvent(MouseEvent me) {
        if (me.getID() == 501) {
            this.setSelected(me.getPoint());
        }
    }

    public void setScrollbar(Scrollbar sb) {
        this.scroller = sb;
        this.scroller.addAdjustmentListener(this);
        this.scroller.setValue(this.getItemCount());
        this.scroller.setMinimum(0);
        this.scroller.setMaximum(this.getItemCount());
        if (this.csh != null) {
            this.scroller.setVisibleAmount(this.slSize.height / this.csh.getMaxHeight());
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.scrollPos = this.bottomUp ? this.getItemCount() - (e.getValue() + 2) : e.getValue();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.slSize;
    }

    public Dimension getPreferredSize() {
        return this.slSize;
    }
}

