/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc;

import com.bowman.irc.IrcListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.Socket;
import java.util.Vector;

public class IrcReader
extends Thread {
    private Socket ircConn;
    private BufferedReader ircIn;
    private Vector listeners;
    private boolean stripChars;
    private Writer debugOut;
    private boolean debug;

    public IrcReader(Socket s, boolean strip) throws IOException {
        this(s, strip, null);
    }

    public IrcReader(Socket ircConn, boolean strip, Writer debugOut) throws IOException {
        super("IrcReader");
        this.setDaemon(true);
        this.ircConn = ircConn;
        this.stripChars = strip;
        this.debugOut = debugOut;
        this.debug = debugOut != null;
        this.ircIn = new BufferedReader(new InputStreamReader(ircConn.getInputStream()));
        this.listeners = new Vector();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void addIrcListener(IrcListener il) {
        this.listeners.addElement(il);
    }

    public void removeIrcListener(IrcListener il) {
        this.listeners.removeElement(il);
    }

    public void run() {
        String line = "";
        try {
            while ((line = this.ircIn.readLine()) != null) {
                if (this.debugOut != null && this.debug) {
                    this.debugOut.write(line + "\n");
                    this.debugOut.flush();
                }
                this.dispatchToListeners(line);
            }
            this.disconnectToListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dispatchToListeners(String line) {
        if (!"".equals(line)) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((IrcListener)this.listeners.elementAt(i)).receivedLine(line);
            }
        }
    }

    private void disconnectToListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((IrcListener)this.listeners.elementAt(i)).disconnected();
        }
    }

    private int filterChar(int c) {
        if (c == 10 || c == 13) {
            return c;
        }
        if (c == 1) {
            return c;
        }
        if (c < 32) {
            return 32;
        }
        return c;
    }

    public void close() {
        try {
            this.ircConn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

