/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc.dcc;

import com.bowman.irc.dcc.DCCFileEvent;
import com.bowman.irc.dcc.DCCFileListener;
import com.bowman.util.ServerSocketProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class DCCFileSender
implements Runnable {
    private String fileName;
    private long fileLen;
    private InputStream is;
    private int blockSize;
    private Thread senderThread;
    private int listeningPort;
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private Vector listeners;

    public DCCFileSender(File file) throws FileNotFoundException {
        this(file, 1024);
    }

    public DCCFileSender(File file, int blockSize) throws FileNotFoundException {
        this.is = new FileInputStream(file);
        this.fileName = file.getName();
        this.blockSize = blockSize;
        this.listeners = new Vector();
    }

    public DCCFileSender(InputStream is, String fileName, long fileLen) {
        this(is, fileName, fileLen, 1024);
    }

    public DCCFileSender(InputStream is, String fileName, long fileLen, int blockSize) {
        this.is = is;
        this.fileLen = fileLen;
        this.fileName = fileName;
        this.blockSize = blockSize;
        this.listeners = new Vector();
    }

    public String generateCtcpReply(InetAddress inetAddr) {
        byte[] address = null;
        if (inetAddr == null) {
            try {
                inetAddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        address = inetAddr.getAddress();
        long longAddress = 0L;
        longAddress |= ((long)address[0] & 0xFFL) << 24;
        longAddress |= ((long)address[1] & 0xFFL) << 16;
        longAddress |= ((long)address[2] & 0xFFL) << 8;
        int port = this.getLocalPort();
        return "DCC SEND " + this.fileName + " " + (longAddress |= ((long)address[3] & 0xFFL) << 0) + " " + port + " " + this.fileLen;
    }

    public String generateCtcpReply() {
        return this.generateCtcpReply(null);
    }

    public void addDCCFileListener(DCCFileListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeDCCFileListener(DCCFileListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireDCCFileEvent(DCCFileEvent ev) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((DCCFileListener)e.nextElement()).onDCCFileEvent(ev);
        }
    }

    public void start() {
        this.fireDCCFileEvent(new DCCFileEvent(0, null, 8));
        try {
            this.serverSocket = ServerSocketProvider.createServerSocket();
            this.listeningPort = this.serverSocket.getLocalPort();
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Unable to open socket.", 0));
        }
        this.senderThread = new Thread((Runnable)this, "DCCFileSenderThread");
        this.senderThread.start();
    }

    public int getLocalPort() {
        return this.listeningPort;
    }

    public void run() {
        InputStream isFile = this.is;
        InputStream isSocket = null;
        OutputStream osSocket = null;
        this.clientSocket = null;
        try {
            this.serverSocket.setSoTimeout(30000);
            this.clientSocket = this.serverSocket.accept();
            this.clientSocket.setSoTimeout(30000);
            this.serverSocket.close();
        }
        catch (InterruptedIOException e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Timed out waiting for connection.", 0));
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Error while waiting for connection.", 0));
        }
        this.fireDCCFileEvent(new DCCFileEvent(1, null, 0));
        try {
            isSocket = this.clientSocket.getInputStream();
            osSocket = this.clientSocket.getOutputStream();
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Unable to open streams.", 0));
        }
        int totalBytes = (int)this.fileLen;
        boolean totalBytesAcked = false;
        boolean totalBytesSent = false;
        byte[] outputBuffer = new byte[this.blockSize];
        byte[] inputBuffer = new byte[4];
        this.fireDCCFileEvent(new DCCFileEvent(7, null, totalBytes));
        try {
            int length;
            while ((length = isFile.read(outputBuffer)) != -1) {
                osSocket.write(outputBuffer, 0, length);
                this.fireDCCFileEvent(new DCCFileEvent(6, null, length));
                isSocket.read(inputBuffer);
            }
            Thread.sleep(500L);
            this.clientSocket.close();
        }
        catch (InterruptedIOException e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Timed out sending data.", 0));
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Error sending data.", 0));
        }
        this.fireDCCFileEvent(new DCCFileEvent(3, null, 0));
    }
}

