/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class He3Handler {
    private static final String noCompHdr = "HE0\r";
    private static final String compHdr = "HE3\r";

    private He3Handler() {
    }

    public static boolean encode(byte[] data, OutputStream out) throws IOException {
        int n;
        int i;
        BufferedOutputStream buffout = new BufferedOutputStream(out);
        int dataLen = data.length;
        if (data.length < 2) {
            buffout.write(noCompHdr.getBytes());
            buffout.write(data);
            buffout.flush();
            return true;
        }
        int[] frequencies = new int[256];
        int checksum = 0;
        for (int i2 = 0; i2 < dataLen; ++i2) {
            int n2 = data[i2] & 0xFF;
            frequencies[n2] = frequencies[n2] + 1;
            checksum ^= data[i2];
        }
        int count = 0;
        ArrayList<HuffNode> nodes = new ArrayList<HuffNode>();
        for (int i3 = 0; i3 < 256; ++i3) {
            if (frequencies[i3] <= 0) continue;
            nodes.add(new HuffNode(i3, frequencies[i3]));
            ++count;
        }
        Collections.sort(nodes, new NodeComparator());
        HuffNode root = He3Handler.buildTree(nodes);
        ArrayList[] lookup = new ArrayList[256];
        ArrayList<Boolean> left = new ArrayList<Boolean>();
        ArrayList<Boolean> right = new ArrayList<Boolean>();
        left.add(new Boolean(false));
        right.add(new Boolean(true));
        He3Handler.buildLookupRecursive(lookup, root.left, left);
        He3Handler.buildLookupRecursive(lookup, root.right, right);
        buffout.write(compHdr.getBytes());
        buffout.write(checksum);
        buffout.write(dataLen & 0xFF);
        buffout.write(dataLen >> 8 & 0xFF);
        buffout.write(dataLen >> 16 & 0xFF);
        buffout.write(dataLen >> 24 & 0xFF);
        buffout.write(count & 0xFF);
        buffout.write(count >> 8 & 0xFF);
        for (int i4 = 0; i4 < 256; ++i4) {
            if (frequencies[i4] <= 0) continue;
            buffout.write(i4);
            buffout.write(lookup[i4].size());
        }
        BitWriter bw = new BitWriter(buffout);
        for (i = 0; i < 256; ++i) {
            if (frequencies[i] <= 0) continue;
            for (n = 0; n < lookup[i].size(); ++n) {
                bw.setNext((Boolean)lookup[i].get(n));
            }
        }
        bw.skipToByte();
        for (i = 0; i < dataLen; ++i) {
            for (n = 0; n < lookup[data[i] & 0xFF].size(); ++n) {
                bw.setNext((Boolean)lookup[data[i] & 0xFF].get(n));
            }
        }
        bw.skipToByte();
        buffout.flush();
        return true;
    }

    public static boolean encode(InputStream in, OutputStream out) throws IOException {
        int read;
        BufferedInputStream buffin = new BufferedInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((read = buffin.read(data)) != -1) {
            bos.write(data, 0, read);
        }
        data = bos.toByteArray();
        return He3Handler.encode(data, out);
    }

    private static HuffNode buildTree(ArrayList nodes) {
        while (nodes.size() > 1) {
            HuffNode node = new HuffNode((HuffNode)nodes.remove(0), (HuffNode)nodes.remove(0));
            boolean done = false;
            for (int i = 0; i < nodes.size(); ++i) {
                if (node.weight > ((HuffNode)nodes.get((int)i)).weight) continue;
                nodes.add(i, node);
                done = true;
                break;
            }
            if (done) continue;
            nodes.add(node);
        }
        return (HuffNode)nodes.get(0);
    }

    private static void buildLookupRecursive(ArrayList[] lookup, HuffNode node, ArrayList bits) {
        if (node.chr != -1) {
            lookup[node.chr] = bits;
            return;
        }
        ArrayList<Boolean> left = new ArrayList<Boolean>();
        ArrayList<Boolean> right = new ArrayList<Boolean>();
        left.addAll(bits);
        right.addAll(bits);
        left.add(new Boolean(false));
        right.add(new Boolean(true));
        He3Handler.buildLookupRecursive(lookup, node.left, left);
        He3Handler.buildLookupRecursive(lookup, node.right, right);
    }

    public static boolean decode(InputStream in, OutputStream out) throws IOException {
        int i;
        BufferedInputStream buffin = new BufferedInputStream(in);
        BufferedOutputStream buffout = new BufferedOutputStream(out);
        int size = 0;
        int checksum = 0;
        try {
            if (buffin.read() != 72 || buffin.read() != 69 || buffin.read() != 51) {
                throw new IOException("Couldn't read Header");
            }
            buffin.read();
            checksum = buffin.read();
            size = buffin.read();
            size += buffin.read() << 8;
            size += buffin.read() << 16;
            size += buffin.read() << 24;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Invalid header");
            return false;
        }
        BitParser bp = null;
        ArrayList<HuffCouple> chars = new ArrayList<HuffCouple>();
        HuffNode root = new HuffNode();
        try {
            int treeInfoSize = buffin.read();
            treeInfoSize += buffin.read() << 8;
            for (i = 0; i < treeInfoSize; ++i) {
                int curChar = buffin.read();
                int bits = buffin.read();
                chars.add(new HuffCouple(curChar, bits));
            }
            bp = new BitParser(buffin);
            for (i = 0; i < chars.size(); ++i) {
                HuffCouple hc = (HuffCouple)chars.get(i);
                HuffNode node = root;
                for (int j = 0; j < hc.length; ++j) {
                    if (bp.getNext()) {
                        if (node.right == null) {
                            node.right = new HuffNode();
                        }
                        node = node.right;
                        continue;
                    }
                    if (node.left == null) {
                        node.left = new HuffNode();
                    }
                    node = node.left;
                }
                node.chr = hc.chr;
            }
        }
        catch (Exception e) {
            System.err.println("HE3 ERROR:" + e);
            throw new IOException(e.toString());
        }
        bp.seekNextByte();
        for (i = 0; i < size; ++i) {
            HuffNode curNode = root;
            while (curNode.chr == -1) {
                curNode = bp.getNext() ? curNode.right : curNode.left;
                if (curNode != null) continue;
                System.err.println("HE3 ERROR");
                throw new IOException();
            }
            buffout.write(curNode.chr);
        }
        buffout.flush();
        return true;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream fis = new FileInputStream("seppuku.DcLst");
        FileOutputStream fos = new FileOutputStream("gx3.txt");
        He3Handler.decode(fis, fos);
    }

    private static class BitWriter {
        int[] lookup = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128};
        OutputStream out;
        int bits = 8;
        int curBit = 1;
        int curByte = 0;

        BitWriter(OutputStream out) {
            this.out = out;
        }

        void setNext(boolean bit) throws IOException {
            if (bit) {
                this.curByte |= this.lookup[this.curBit];
            }
            ++this.curBit;
            if (this.curBit > this.bits) {
                this.curBit = 1;
                this.out.write(this.curByte);
                this.curByte = 0;
            }
        }

        void skipToByte() throws IOException {
            while (this.curBit != 1) {
                this.setNext(false);
            }
        }
    }

    private static class BitParser {
        InputStream in;
        int bits = 8;
        int curBit = 1;
        int curByte;

        BitParser(InputStream in) throws IOException {
            this.in = in;
            this.curByte = this.in.read();
        }

        boolean getNext() throws IOException {
            boolean retval = false;
            boolean bl = retval = (this.curByte & this.curBit) != 0;
            if (this.curBit < 1 << this.bits - 1) {
                this.curBit <<= 1;
            } else {
                this.curBit = 1;
                this.curByte = this.in.read();
            }
            return retval;
        }

        void seekNextByte() throws IOException {
            while (this.curBit != 1) {
                this.getNext();
            }
        }
    }

    private static class NodeComparator
    implements Comparator {
        private NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            HuffNode n1 = (HuffNode)o1;
            HuffNode n2 = (HuffNode)o2;
            if (n1.weight < n2.weight) {
                return -1;
            }
            if (n1.weight > n2.weight) {
                return 1;
            }
            return 0;
        }
    }

    private static class HuffNode {
        int chr = -1;
        int weight = -1;
        HuffNode left = null;
        HuffNode right = null;
        HuffNode parent = null;

        HuffNode() {
        }

        HuffNode(int chr, int weight) {
            this.chr = chr;
            this.weight = weight;
        }

        HuffNode(HuffNode left, HuffNode right) {
            this.left = left;
            this.right = right;
            this.weight = left.weight + right.weight;
            left.parent = this;
            right.parent = this;
        }
    }

    private static class HuffCouple {
        int length = 0;
        int chr = 0;

        HuffCouple(int chr, int length) {
            this.length = length;
            this.chr = chr;
        }
    }
}

