/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import com.bowman.util.BasicHttpAuth;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class HttpQueryConnection {
    private URL baseUrl;
    private HttpURLConnection conn = null;
    private String requestString;
    private String htUser;
    private String htPassword;
    private String contentType;

    public HttpQueryConnection(URL url) {
        this.baseUrl = url;
    }

    public HttpQueryConnection(URL url, Properties props) {
        this(url);
        this.setProperties(props);
    }

    public void setProperties(Properties props) {
        if (props != null) {
            Enumeration<Object> enumeration = props.keys();
            this.requestString = "?";
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                this.requestString = this.requestString.concat(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            }
            this.requestString = this.requestString.substring(0, this.requestString.length() - 1);
        }
    }

    public void setProperties(String key, String value) {
        this.requestString = "?" + URLEncoder.encode(key) + "=" + URLEncoder.encode(value);
    }

    public void setBasicAuth(String user, String pass) {
        this.htUser = user;
        this.htPassword = pass;
    }

    private void setupConnection() throws MalformedURLException, IOException {
        URL finalUrl = this.baseUrl;
        if (this.requestString != null) {
            finalUrl = new URL(this.baseUrl.toString() + this.requestString);
        }
        this.conn = (HttpURLConnection)finalUrl.openConnection();
        if (this.htUser != null && this.htPassword != null) {
            this.conn.setRequestProperty("Authorization", BasicHttpAuth.encode(this.htUser, this.htPassword));
        }
    }

    public int performGet() throws MalformedURLException, IOException {
        this.setupConnection();
        this.conn.setDoInput(true);
        this.conn.setRequestMethod("GET");
        this.conn.connect();
        this.contentType = this.conn.getContentType();
        return this.conn.getContentLength();
    }

    public Date getRemoteFileDate() {
        if (this.conn == null) {
            return null;
        }
        return new Date(this.conn.getLastModified());
    }

    public String getHeader(String name) {
        if (this.conn == null) {
            return null;
        }
        return this.conn.getHeaderField(name);
    }

    public int performPost(String contentType, int contentLength, InputStream is) throws MalformedURLException, IOException {
        this.setupConnection();
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
        this.conn.setRequestMethod("POST");
        if (contentType != null) {
            this.conn.setRequestProperty("Content-type", contentType);
        }
        if (contentLength != -1) {
            this.conn.setRequestProperty("Content-length", String.valueOf(contentLength));
        }
        this.conn.connect();
        if (this.conn == null) {
            throw new IOException("Connection aborted");
        }
        OutputStream os = this.conn.getOutputStream();
        int read = 0;
        byte[] buf = new byte[4096];
        while ((read = is.read(buf)) != -1) {
            os.write(buf, 0, read);
        }
        if (os == null) {
            throw new IOException("Internal HttpQueryConnection error, timeout reading response?");
        }
        os.flush();
        if (this.conn == null) {
            throw new IOException("Connection aborted");
        }
        contentType = this.conn.getContentType();
        if (this.conn != null) {
            return this.conn.getContentLength();
        }
        throw new IOException("Connection aborted");
    }

    public int performPost(String contentType, InputStream is) throws MalformedURLException, IOException {
        return this.performPost(contentType, -1, is);
    }

    public int performPost(InputStream is) throws MalformedURLException, IOException {
        return this.performPost(null, -1, is);
    }

    public int getResponseCode() throws IOException {
        if (this.conn != null) {
            return this.conn.getResponseCode();
        }
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        if (this.conn != null) {
            return this.conn.getInputStream();
        }
        return null;
    }

    public Vector getParsedLines() throws IOException {
        return this.getParsedLines(false);
    }

    public Vector getParsedLines(boolean force) throws IOException {
        if (this.isParsedAvailable() || force) {
            String line;
            Vector<String> replyLines = new Vector<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStream()));
            while ((line = br.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                replyLines.addElement(line);
            }
            br.close();
            this.close();
            return replyLines;
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getText() throws IOException {
        Enumeration enumeration = this.getParsedLines().elements();
        String result = "";
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                result = result + (String)enumeration.nextElement() + "\n";
            }
        }
        return result;
    }

    public boolean isParsedAvailable() {
        if (this.contentType == null) {
            return false;
        }
        return this.contentType.toLowerCase().startsWith("text/");
    }

    public void close() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.conn = null;
    }
}

