/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;

public class IniFile {
    private HashMap sections;

    public IniFile(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public IniFile(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.readIni(reader);
    }

    private void readIni(BufferedReader reader) throws IOException {
        String line;
        this.sections = new HashMap();
        String currentSection = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(";")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                currentSection = line.substring(1, line.length() - 1);
                continue;
            }
            if (currentSection == null) continue;
            this.addProperty(line, currentSection);
        }
    }

    private void addProperty(String line, String sectionName) {
        Properties section;
        int splitIdx = line.indexOf("=");
        if (splitIdx < 0) {
            return;
        }
        String key = line.substring(0, splitIdx).trim();
        String value = line.substring(splitIdx + 1).trim();
        if (value.startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        if ((section = (Properties)this.sections.get(sectionName)) == null) {
            section = new Properties();
        }
        section.setProperty(key, value);
        this.sections.put(sectionName, section);
    }

    public String getProperty(String sectionName, String name) {
        Properties section = (Properties)this.sections.get(sectionName);
        if (section == null) {
            return null;
        }
        return section.getProperty(name);
    }

    public Properties getSection(String name) {
        return (Properties)this.sections.get(name);
    }

    public String[] getPropertyNames(String sectionName) {
        Properties section = (Properties)this.sections.get(sectionName);
        if (section == null) {
            return null;
        }
        ArrayList<Object> names = new ArrayList<Object>(section.keySet());
        return names.toArray(new String[names.size()]);
    }

    public String[] getSectionNames() {
        ArrayList names = new ArrayList(this.sections.keySet());
        return names.toArray(new String[names.size()]);
    }

    public Collection getSections() {
        return new ArrayList(this.sections.keySet());
    }

    public static void main(String[] args) throws Exception {
        String[] props;
        URL url = new URL("http://rates-cs.cloanto.com/rates-cs/eur-en.ini");
        IniFile ini = new IniFile(url.openStream());
        String[] sections = ini.getSectionNames();
        for (int i = 0; i < sections.length; ++i) {
            System.out.println("[" + sections[i] + "]");
            props = ini.getPropertyNames(sections[i]);
            for (int n = 0; n < props.length; ++n) {
                System.out.println(props[n] + "=" + ini.getProperty(sections[i], props[n]));
            }
        }
        URL nextUrl = new URL(ini.getProperty("General", "Next"));
        ini = new IniFile(nextUrl.openStream());
        sections = ini.getSectionNames();
        for (int i = 0; i < sections.length; ++i) {
            System.out.println("[" + sections[i] + "]");
            props = ini.getPropertyNames(sections[i]);
            for (int n = 0; n < props.length; ++n) {
                System.out.println(props[n] + "=" + ini.getProperty(sections[i], props[n]));
            }
        }
    }
}

