/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMISocketFactory;

public class RMIProxySocketFactory
extends RMISocketFactory {
    public static final int PROXYMODE_LISTENER = 0;
    public static final int PROXYMODE_CONNECTOR = 1;
    private String remoteHost;
    private int remotePort;
    private int listenPort;
    private int proxyMode;
    private ServerSocket serverSock;
    private Socket lastAccepted;
    private boolean debug;

    public RMIProxySocketFactory(String remoteHost, int remotePort) {
        this.proxyMode = 1;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public RMIProxySocketFactory(int listenPort) throws IOException {
        this.proxyMode = 0;
        this.listenPort = listenPort;
        this.serverSock = new ServerSocket(listenPort);
    }

    public synchronized Socket createSocket(String host, int port) throws IOException {
        this.debug("createSocket(" + host + ", " + port + ")");
        if (this.proxyMode == 1) {
            return new Socket(host, port);
        }
        boolean acceptSuccess = false;
        while (!acceptSuccess) {
            try {
                this.debug("waiting for connection on: " + this.serverSock.getInetAddress().getHostAddress() + ":" + this.serverSock.getLocalPort());
                this.lastAccepted = this.serverSock.accept();
                acceptSuccess = true;
            }
            catch (SocketException e) {
                this.serverSock.close();
                this.serverSock = new ServerSocket(this.listenPort);
                throw new ConnectException("Connection refused: connect");
            }
        }
        this.debug("accepted connection: " + this.lastAccepted.getInetAddress().getHostAddress() + ":" + this.lastAccepted.getPort());
        return this.lastAccepted;
    }

    public synchronized ServerSocket createServerSocket(int port) throws IOException {
        this.debug("createServerSocket(" + port + ")");
        ServerSocket srv = new ServerSocket(port);
        if (this.proxyMode == 1) {
            new RMIProxyPipe(srv.getLocalPort());
        }
        return srv;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void recycle() {
        if (this.lastAccepted != null) {
            try {
                this.lastAccepted.close();
                this.lastAccepted = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void abort() {
    }

    public void reset() {
    }

    private void debug(String s) {
        if (this.debug) {
            System.out.println((this.proxyMode == 0 ? "listener: " : "connector: ") + s + " [" + Thread.currentThread().getName() + "]");
        }
    }

    private class RMIProxyPipe
    implements Runnable {
        int localPort;
        Thread localReader;
        Thread remoteReader;
        Socket localConn;
        Socket remoteConn;

        RMIProxyPipe(int port) throws IOException {
            this.localPort = port;
            this.localReader = new Thread((Runnable)this, "RMIProxyLocalReaderThread");
            this.remoteReader = new Thread((Runnable)this, "RMIProxyRemoteReaderThread");
            this.localConn = new Socket(InetAddress.getLocalHost(), this.localPort);
            this.remoteConn = new Socket(RMIProxySocketFactory.this.remoteHost, RMIProxySocketFactory.this.remotePort);
            RMIProxySocketFactory.this.debug("pipe connected to: " + RMIProxySocketFactory.this.remoteHost + ":" + RMIProxySocketFactory.this.remotePort + " (local port: " + this.localPort + ")");
            this.localReader.start();
            this.remoteReader.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RMIProxySocketFactory.this.debug("Pipe starting");
            InputStream is = null;
            OutputStream os = null;
            byte[] buffer = new byte[4096];
            while (true) {
                block25: {
                    try {
                        int read;
                        if (Thread.currentThread() == this.localReader) {
                            is = this.localConn.getInputStream();
                            os = this.remoteConn.getOutputStream();
                        } else if (Thread.currentThread() == this.remoteReader) {
                            is = this.remoteConn.getInputStream();
                            os = this.localConn.getOutputStream();
                        }
                        while ((read = is.read(buffer)) > -1) {
                            os.write(buffer, 0, read);
                        }
                        RMIProxySocketFactory.this.debug("pipe socket closed?");
                    }
                    catch (IOException e) {
                        RMIProxySocketFactory.this.debug("pipe read failed");
                        if (!RMIProxySocketFactory.this.debug) break block25;
                        e.printStackTrace();
                    }
                }
                try {
                    RMIProxyPipe e;
                    if (Thread.currentThread() == this.remoteReader) {
                        e = this;
                        synchronized (e) {
                            if (this.localConn != null) {
                                this.localConn.close();
                            }
                            this.localConn = null;
                        }
                        this.remoteConn.close();
                        this.remoteConn = new Socket(RMIProxySocketFactory.this.remoteHost, RMIProxySocketFactory.this.remotePort);
                        e = this;
                        synchronized (e) {
                            this.localConn = new Socket(InetAddress.getLocalHost(), this.localPort);
                            this.notify();
                        }
                        RMIProxySocketFactory.this.debug("pipe connected to: " + RMIProxySocketFactory.this.remoteHost + ":" + RMIProxySocketFactory.this.remotePort + " (local port: " + this.localPort + ")");
                    } else if (Thread.currentThread() == this.localReader) {
                        e = this;
                        synchronized (e) {
                            while (this.localConn == null) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e2) {}
                            }
                        }
                    }
                    RMIProxySocketFactory.this.debug("pipe conn re-established?");
                    continue;
                }
                catch (IOException e) {
                    RMIProxySocketFactory.this.debug("pipe connect failed?");
                    if (!RMIProxySocketFactory.this.debug) continue;
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

