/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class ServerSocketProvider {
    private static final int DEFAULT_BACKLOG = 10;
    private static int rangeStart = 0;
    private static int rangeEnd = 0;
    private static InetAddress bindAddr;

    public static ServerSocket createServerSocket() throws IOException {
        if (rangeStart == 0 && rangeEnd == 0) {
            return new ServerSocket(0, 10, bindAddr);
        }
        ServerSocket tmp = null;
        for (int cuPort = rangeStart; cuPort < rangeEnd; ++cuPort) {
            try {
                tmp = new ServerSocket(cuPort, 10, bindAddr);
                return tmp;
            }
            catch (IOException e) {
                continue;
            }
        }
        throw new IOException("Unable to find available port in range: " + rangeStart + "-" + rangeEnd);
    }

    public static ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port, 10, bindAddr);
    }

    public static void setRangeStart(int newRangeStart) {
        rangeStart = newRangeStart;
    }

    public static void setRangeEnd(int newRangeEnd) {
        rangeEnd = newRangeEnd;
    }

    public static void setBindAddr(InetAddress newBindAddr) {
        bindAddr = newBindAddr;
    }

    public static InetAddress getBindAddr() {
        if (bindAddr == null) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return bindAddr;
    }
}

