/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.AbstractCwsConnector;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.ReplyFilter;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class DcwFilterPlugin
implements ProxyPlugin,
ReplyFilter {
    private static final byte[] badDcw1 = DESUtil.stringToBytes((String)"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
    private ProxyLogger logger;
    private Set badDcws = new HashSet();
    private Map replyMap = Collections.synchronizedMap(new MessageCacheMap(20000L));
    private Map connMap = Collections.synchronizedMap(new MessageCacheMap(20000L));
    private Map sidLinksMap = Collections.synchronizedMap(new HashMap());
    private Set removedLinks = new HashSet();
    private Set profiles;
    private Map monitoredSidsMap = Collections.synchronizedMap(new MessageCacheMap(20000L));
    private Map invalidLinksMap = Collections.synchronizedMap(new HashMap());
    private Map zeroedReplyMap = Collections.synchronizedMap(new MessageCacheMap(20000L));
    private boolean detectLinks = false;
    private boolean verifyReplies = false;
    private boolean forceContinuity = false;
    private boolean zeroCounting = true;
    private int verifiedCount = 0;
    private int badLengthCount = 0;
    private int filteredCount = 0;
    private int checksumFailCount = 0;
    private int mergeCount = 0;
    private String badDcwStr;
    private File mapFile;

    public DcwFilterPlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
        this.mapFile = new File("etc", "links.dat");
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        Iterator iter = xml.getMultipleStrings("bad-dcw");
        if (iter != null) {
            while (iter.hasNext()) {
                byte[] bd = DESUtil.stringToBytes((String)((String)iter.next()));
                if (bd.length != 16) {
                    throw new ConfigException(xml.getFullName(), "bad-dcw not 16 bytes: " + DESUtil.bytesToString((byte[])bd));
                }
                this.badDcws.add(bd);
            }
        }
        this.badDcws.add(badDcw1);
        this.detectLinks = "true".equalsIgnoreCase(xml.getStringValue("detect-links", "false"));
        this.zeroCounting = "true".equalsIgnoreCase(xml.getStringValue("zero-counting", "true"));
        this.verifyReplies = "true".equalsIgnoreCase(xml.getStringValue("verify-replies", "false"));
        this.forceContinuity = "true".equalsIgnoreCase(xml.getStringValue("force-continuity", "false"));
        String profilesStr = xml.getStringValue("profiles", "");
        this.profiles = profilesStr != null && profilesStr.length() > 0 ? new HashSet<String>(Arrays.asList(profilesStr.toLowerCase().split(" "))) : Collections.EMPTY_SET;
    }

    public void start(CardServProxy proxy) {
        HashSet<String> set = new HashSet<String>();
        Iterator iter = this.badDcws.iterator();
        while (iter.hasNext()) {
            set.add(DESUtil.bytesToString((byte[])((byte[])iter.next())));
        }
        this.badDcwStr = ((Object)set).toString();
        this.logger.info("Filtering bad CWs: " + this.badDcwStr);
        this.loadLinksMap();
    }

    public void stop() {
        this.saveLinksMap();
    }

    public String getName() {
        return "DcwFilterPlugin";
    }

    public String getDescription() {
        return "Change bad dcws into empty newcamd replies (cannot decode) and do some basic analysis.";
    }

    public Properties getProperties() {
        Properties p = new Properties();
        if (this.detectLinks) {
            TreeSet<String> links = new TreeSet<String>();
            ProxyConfig config = ProxyConfig.getInstance();
            long now = System.currentTimeMillis();
            Iterator iter = this.sidLinksMap.values().iterator();
            while (iter.hasNext()) {
                Set grp = (Set)iter.next();
                TreeSet<String> strGrp = new TreeSet<String>();
                Iterator i = grp.iterator();
                while (i.hasNext()) {
                    TvService srv;
                    String m;
                    String s = (String)i.next();
                    String[] sa = s.split(":");
                    String string = m = this.monitoredSidsMap.containsKey(s) && now - ((CamdNetMessage)this.monitoredSidsMap.get(s)).getTimeStamp() < 20000L ? "*" : "";
                    if (!this.profiles.isEmpty() && !this.profiles.contains(sa[1].toLowerCase()) || !(srv = config.getService(sa[1], Integer.parseInt(sa[0], 16))).isTv()) continue;
                    strGrp.add(srv + m);
                }
                if (strGrp.size() < 2) continue;
                links.add(((Object)strGrp).toString());
            }
            p.setProperty("detected-service-links", ((Object)links).toString());
            p.setProperty("removed-service-links", this.removedLinks.toString());
        }
        if (this.verifyReplies) {
            p.setProperty("verified-count", String.valueOf(this.verifiedCount));
            if (!this.connMap.isEmpty()) {
                p.setProperty("connector-map", String.valueOf(this.connMap.size()));
            }
        }
        if (!this.replyMap.isEmpty()) {
            p.setProperty("reply-map", String.valueOf(this.replyMap.size()));
        }
        if (this.badDcwStr != null) {
            p.setProperty("filtering-dcws", this.badDcwStr);
        }
        if (this.filteredCount > 0) {
            p.setProperty("filtered-count", String.valueOf(this.filteredCount));
        }
        if (this.badLengthCount > 0) {
            p.setProperty("bad-length-count", String.valueOf(this.badLengthCount));
        }
        if (this.checksumFailCount > 0) {
            p.setProperty("checksum-fail-count", String.valueOf(this.checksumFailCount));
        }
        if (this.mergeCount > 0) {
            p.setProperty("merged-reply-count", String.valueOf(this.mergeCount));
        }
        if (p.isEmpty()) {
            return null;
        }
        return p;
    }

    protected void loadLinksMap() {
        if (this.mapFile.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.mapFile)));
                this.sidLinksMap = (Map)ois.readObject();
                this.logger.fine("Loaded links map, " + this.sidLinksMap.size() + " entries.");
                ois.close();
            }
            catch (Exception e) {
                this.logger.throwing((Throwable)e);
                this.logger.warning("Failed to load links map ('" + this.mapFile.getPath() + "'): " + e);
            }
        }
    }

    protected void saveLinksMap() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.mapFile)));
            oos.writeObject(this.sidLinksMap);
            this.logger.fine("Saved links map, " + this.sidLinksMap.size() + " entries.");
            oos.close();
        }
        catch (IOException e) {
            this.logger.throwing((Throwable)e);
            this.logger.warning("Failed to save links map ('" + this.mapFile.getPath() + "'): " + e);
        }
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        return msg;
    }

    public CamdNetMessage doReplyFilter(CwsConnector connector, CamdNetMessage msg) {
        try {
            if (msg.isDcw() && msg.getDataLength() != 0 && (this.profiles.isEmpty() || this.profiles.contains(msg.getProfileName()))) {
                if (msg.getDataLength() != 16) {
                    this.logger.warning("Bad DCW length (" + msg.getDataLength() + ") from '" + connector.getName() + "': " + DESUtil.bytesToString((byte[])msg.getCustomData()));
                    msg.setCustomData(new byte[0]);
                    ++this.badLengthCount;
                } else if (!msg.checksumDcw()) {
                    this.logger.warning("Bad DCW checksum in reply from '" + connector.getName() + "': " + DESUtil.bytesToString((byte[])msg.getCustomData()));
                    msg.setCustomData(new byte[0]);
                    ++this.checksumFailCount;
                } else if (DcwFilterPlugin.isBadDcw(msg, this.badDcws, this.zeroCounting)) {
                    this.logger.warning("Bad DCW reply from '" + connector.getName() + "': " + DESUtil.bytesToString((byte[])msg.getCustomData()));
                    msg.setCustomData(new byte[0]);
                    ++this.filteredCount;
                } else {
                    if (this.detectLinks) {
                        this.detectLink(msg);
                    }
                    if (this.forceContinuity) {
                        this.forceContinuity(msg);
                    }
                    boolean blockReply = false;
                    if (this.verifyReplies) {
                        boolean bl = blockReply = !this.verifyReply(msg, connector);
                    }
                    if (this.detectLinks || this.verifyReplies) {
                        this.replyMap.put(msg, msg);
                    }
                    if (blockReply) {
                        return null;
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return msg;
    }

    private static boolean hasZeroDcw(byte[] data) {
        return data[0] + data[1] + data[3] == 0 || data[9] + data[10] + data[11] == 0;
    }

    private static void mergeZeroedReplies(CamdNetMessage currMsg, CamdNetMessage prevMsg) {
        byte[] curr = currMsg.getCustomData();
        byte[] prev = prevMsg.getCustomData();
        for (int i = 0; i < curr.length; ++i) {
            int n = i;
            curr[n] = (byte)(curr[n] | prev[i]);
        }
    }

    private static boolean isBadDcw(CamdNetMessage msg, Set badDcws, boolean zeroCounting) {
        byte[] data = msg.getCustomData();
        Iterator iter = badDcws.iterator();
        while (iter.hasNext()) {
            byte[] badDcw = (byte[])iter.next();
            if (!Arrays.equals(data, badDcw)) continue;
            return true;
        }
        if (zeroCounting) {
            return msg.hasFiveZeroes();
        }
        return false;
    }

    private boolean forceContinuity(CamdNetMessage msg) {
        if (msg.getServiceId() != 0 && DcwFilterPlugin.hasZeroDcw(msg.getCustomData())) {
            long age;
            String context = msg.getServiceId() + ":" + msg.getProfileName();
            String key = (msg.getCommandTag() == 129 ? "81" : "80") + ":" + context;
            this.zeroedReplyMap.put(key, new CamdNetMessage(msg));
            String prevKey = (msg.getCommandTag() == 129 ? "80" : "81") + ":" + context;
            CamdNetMessage prev = (CamdNetMessage)this.zeroedReplyMap.get(prevKey);
            if (prev != null && (age = System.currentTimeMillis() - prev.getTimeStamp()) < 12000L) {
                DcwFilterPlugin.mergeZeroedReplies(msg, prev);
                ++this.mergeCount;
                return true;
            }
        }
        return false;
    }

    private boolean detectLink(CamdNetMessage msg) {
        if (msg.getServiceId() != 0) {
            CamdNetMessage prev;
            String msgId = Integer.toHexString(msg.getServiceId()) + ":" + msg.getProfileName();
            if (this.sidLinksMap.containsKey(msgId)) {
                this.monitoredSidsMap.put(msgId, msg);
                Iterator iter = new ArrayList((Set)this.sidLinksMap.get(msgId)).iterator();
                while (iter.hasNext()) {
                    String testId = (String)iter.next();
                    if (testId.equals(msgId) || !this.monitoredSidsMap.containsKey(testId)) continue;
                    CamdNetMessage prev2 = (CamdNetMessage)this.monitoredSidsMap.get(testId);
                    long now = System.currentTimeMillis();
                    if (now - prev2.getTimeStamp() >= 2000L || prev2.equals((Object)msg)) continue;
                    ProxyConfig config = ProxyConfig.getInstance();
                    String[] sa = testId.split(":");
                    TvService m = config.getService(msg.getProfileName(), msg.getServiceId());
                    TvService t = config.getService(sa[1], Integer.parseInt(sa[0], 16));
                    TreeSet<String> l = new TreeSet<String>();
                    l.add(m.toString());
                    l.add(t.toString());
                    String link = ((Object)l).toString();
                    Long timeStamp = (Long)this.invalidLinksMap.get(link);
                    if (timeStamp != null && now - timeStamp < 20000L) {
                        this.logger.info("Link no longer seems valid, removing: " + m + " > " + t);
                        this.removedLinks.add(link);
                        Set s = (Set)this.sidLinksMap.get(msgId);
                        s.remove(testId);
                        if (s.size() > 1) continue;
                        this.sidLinksMap.remove(msgId);
                        this.sidLinksMap.remove(testId);
                        continue;
                    }
                    this.invalidLinksMap.put(link, new Long(now));
                }
            }
            if (this.replyMap.containsKey(msg) && (prev = (CamdNetMessage)this.replyMap.get(msg)).getServiceId() != msg.getServiceId()) {
                String prevId = Integer.toHexString(prev.getServiceId()) + ":" + prev.getProfileName();
                TreeSet<String> links = (TreeSet<String>)this.sidLinksMap.get(prevId);
                if (links == null) {
                    links = (Set)this.sidLinksMap.get(msgId);
                }
                if (links == null) {
                    links = new TreeSet<String>();
                }
                links.add(prevId);
                links.add(msgId);
                if (this.sidLinksMap.put(prevId, links) == null || this.sidLinksMap.put(msgId, links) == null) {
                    this.logger.fine("Link found: " + links + "\n\t" + prev + "\n\t" + msg);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean verifyReply(CamdNetMessage msg, CwsConnector connector) {
        CwsConnector prevConn = this.connMap.put(msg, connector);
        if (prevConn != null && prevConn != connector) {
            ++this.verifiedCount;
            ((AbstractCwsConnector)prevConn).reportReply((CamdNetMessage)this.replyMap.get(msg));
            return true;
        }
        return false;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }
}

