﻿DROP TABLE IF EXISTS arquivo_backup;

CREATE TABLE `arquivo_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(250) DEFAULT NULL,
  `local` mediumtext,
  `data` varchar(250) DEFAULT NULL,
  `size` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS backup;

CREATE TABLE `backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(11) NOT NULL DEFAULT 'N',
  `tempo` varchar(11) DEFAULT NULL,
  `horario` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO backup VALUES("1","S","1","1549554601","bbcstvdigital@gmail.com");


DROP TABLE IF EXISTS backup_automatizado;

CREATE TABLE `backup_automatizado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(11) NOT NULL DEFAULT 'N',
  `tempo` varchar(250) NOT NULL,
  `horario` varchar(250) NOT NULL,
  `server` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS bancoemail;

CREATE TABLE `bancoemail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS bit;

CREATE TABLE `bit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `usuario` varchar(250) DEFAULT NULL,
  `api` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO bit VALUES("1","caiquecs","sat55c","632555");


DROP TABLE IF EXISTS captcha;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(11) NOT NULL DEFAULT 'S',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO captcha VALUES("1","N");


DROP TABLE IF EXISTS comprar;

CREATE TABLE `comprar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `comprador` varchar(250) DEFAULT NULL,
  `referencia` varchar(250) DEFAULT NULL,
  `dias` varchar(250) DEFAULT NULL,
  `valor` varchar(250) DEFAULT NULL,
  `perfil` text,
  `conexao` varchar(250) DEFAULT NULL,
  `PrePago` varchar(11) NOT NULL DEFAULT 'N',
  `Quantidade` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS config_suporte;

CREATE TABLE `config_suporte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `SuportePaginacao` int(11) DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO config_suporte VALUES("1","Admin","25");


DROP TABLE IF EXISTS contabancaria;

CREATE TABLE `contabancaria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `banco` varchar(250) DEFAULT NULL,
  `tipo` varchar(11) DEFAULT 'C',
  `agencia` varchar(250) DEFAULT NULL,
  `operacao` varchar(250) DEFAULT NULL,
  `conta` varchar(250) DEFAULT NULL,
  `favorecido` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS contamercadopago;

CREATE TABLE `contamercadopago` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `clientid` varchar(250) DEFAULT NULL,
  `clientsecret` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS contapagseguro;

CREATE TABLE `contapagseguro` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `token` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS contapaypal;

CREATE TABLE `contapaypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `senha` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS cupom;

CREATE TABLE `cupom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `CriadoEm` varchar(250) DEFAULT NULL,
  `Cupom` varchar(250) DEFAULT NULL,
  `UserDescontar` varchar(250) DEFAULT NULL,
  `UserDescontarEm` varchar(250) DEFAULT NULL,
  `dias` varchar(250) DEFAULT NULL,
  `perfil` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS email_adicionar;

CREATE TABLE `email_adicionar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `servidor` varchar(250) DEFAULT NULL,
  `exibicao` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `usuario` varchar(250) DEFAULT NULL,
  `senha` varchar(250) DEFAULT NULL,
  `SMTPSecure` varchar(250) DEFAULT NULL,
  `Host` varchar(250) DEFAULT NULL,
  `Port` int(11) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS email_modelo;

CREATE TABLE `email_modelo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `tipo` varchar(250) DEFAULT 'Painel',
  `assunto` varchar(250) DEFAULT NULL,
  `mensagem` longtext,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS email_preferencias;

CREATE TABLE `email_preferencias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `DadosDeAcesso` int(11) DEFAULT NULL,
  `DadosDeAcessoTeste` int(11) DEFAULT NULL,
  `Vencimento` int(11) DEFAULT NULL,
  `Renovacao` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS email_teste;

CREATE TABLE `email_teste` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(250) DEFAULT NULL,
  `CadUser` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO email_teste VALUES("1","bbcstvdigital@gmail.com","Admin");


DROP TABLE IF EXISTS emailtemporario;

CREATE TABLE `emailtemporario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS grupodeacesso;

CREATE TABLE `grupodeacesso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `nome` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO grupodeacesso VALUES("1","Admin","revendas","N");
INSERT INTO grupodeacesso VALUES("2","Admin","admin","N");
INSERT INTO grupodeacesso VALUES("3","vando","revendas","N");
INSERT INTO grupodeacesso VALUES("4","alexandre","revendas","N");
INSERT INTO grupodeacesso VALUES("5","edinhocs","revendas","N");
INSERT INTO grupodeacesso VALUES("6","luiz01","REVENDAS","N");


DROP TABLE IF EXISTS leiaute;

CREATE TABLE `leiaute` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `leiaute` int(11) DEFAULT NULL,
  `wall` varchar(250) DEFAULT NULL,
  `cabecalho` int(11) DEFAULT NULL,
  `barralateral` int(11) DEFAULT NULL,
  `scroll` int(11) DEFAULT NULL,
  `barradireita` int(11) DEFAULT NULL,
  `navpersonalizado` int(11) DEFAULT NULL,
  `alternarnav` int(11) DEFAULT NULL,
  `minimizar` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;

INSERT INTO leiaute VALUES("1","Admin","","","1","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("3","vando","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("4","alexandre","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("5","biju","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("6","anderson81","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("7","messias","","","0","1","1","0","0","1","S");
INSERT INTO leiaute VALUES("8","marcos","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("9","alessandromp","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("11","lucy","","","1","1","1","0","1","0","N");
INSERT INTO leiaute VALUES("12","jose44","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("15","marco17","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("16","primo1020","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("17","salsicha","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("18","ronaldo","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("19","exclusiverio","0","wall_1","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("20","caiquecs","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("21","edinhocs","","","0","1","1","0","0","0","N");
INSERT INTO leiaute VALUES("22","luiz01","","","0","1","1","0","0","0","N");


DROP TABLE IF EXISTS liberarcomputador;

CREATE TABLE `liberarcomputador` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `gethostbyaddr` varchar(250) DEFAULT NULL,
  `computador` varchar(250) DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  `codigo` varchar(250) DEFAULT NULL,
  `ativo` varchar(11) NOT NULL DEFAULT 'N',
  `data` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS mascaraurl;

CREATE TABLE `mascaraurl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `perfil` int(11) DEFAULT NULL,
  `nome` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `porta` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO mascaraurl VALUES("1","Admin","3","CLAROTV","csservidortv.ddns.net","32005","N");
INSERT INTO mascaraurl VALUES("2","Admin","4","SKY","csservidortv.ddns.net","31005","N");
INSERT INTO mascaraurl VALUES("3","vando","3","CLAROTV","braz.ddns.net","32005","N");
INSERT INTO mascaraurl VALUES("4","vando","4","SKY","braz.ddns.net","31005","N");


DROP TABLE IF EXISTS mercadopago;

CREATE TABLE `mercadopago` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comprador` varchar(250) DEFAULT NULL,
  `CadUser` varchar(250) DEFAULT NULL,
  `payment_status` varchar(250) DEFAULT NULL,
  `item_number` varchar(250) DEFAULT NULL,
  `data` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS pagseguro;

CREATE TABLE `pagseguro` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comprador` varchar(250) DEFAULT NULL,
  `CadUser` varchar(250) DEFAULT NULL,
  `TipoPagamento` varchar(250) DEFAULT NULL,
  `StatusTransacao` varchar(250) DEFAULT NULL,
  `Referencia` varchar(250) DEFAULT NULL,
  `data` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS painel;

CREATE TABLE `painel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `porta` int(11) DEFAULT NULL,
  `usuario` varchar(250) DEFAULT NULL,
  `senha` varchar(250) DEFAULT NULL,
  `protocolo` varchar(250) DEFAULT NULL,
  `block` varchar(11) NOT NULL DEFAULT 'N',
  `atualizar` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO painel VALUES("1","SERVIDOR","127.0.0.1","1020","painel","painel","http","N","");


DROP TABLE IF EXISTS painel_config;

CREATE TABLE `painel_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `senha` varchar(250) DEFAULT NULL,
  `deskeys` varchar(250) DEFAULT NULL,
  `ip` text,
  `iplock` varchar(11) NOT NULL DEFAULT 'S',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO painel_config VALUES("1","18281996","0102030405060708091011121314","","N");


DROP TABLE IF EXISTS paypal;

CREATE TABLE `paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comprador` varchar(250) DEFAULT NULL,
  `CadUser` varchar(250) DEFAULT NULL,
  `payment_status` varchar(250) DEFAULT NULL,
  `item_number` varchar(250) DEFAULT NULL,
  `data` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS perfil;

CREATE TABLE `perfil` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `painel` int(11) DEFAULT NULL,
  `imagem` int(11) DEFAULT NULL,
  `nome` varchar(250) DEFAULT NULL,
  `valorcsp` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `porta` int(11) DEFAULT NULL,
  `tipo` varchar(250) NOT NULL DEFAULT 'SAT',
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO perfil VALUES("3","1","4","CLARO TV","[clarotv]","exemple.com","12500","SAT","N");


DROP TABLE IF EXISTS perfil_icone;

CREATE TABLE `perfil_icone` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(250) DEFAULT NULL,
  `img` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO perfil_icone VALUES("3","SKY","1541694048_beaa7e0a763fbc0051c7e6d5cd95367e2f09ba8d.jpg");
INSERT INTO perfil_icone VALUES("4","CLARO","1541694071_979958fc4086fbb90944716b429c01fbdf16d927.jpg");


DROP TABLE IF EXISTS planos;

CREATE TABLE `planos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `nomeplano` varchar(250) DEFAULT NULL,
  `tipoperfil` varchar(250) NOT NULL DEFAULT 'SAT',
  `tipoplano` varchar(250) DEFAULT 'N',
  `dias` varchar(250) DEFAULT NULL,
  `valor` varchar(250) DEFAULT NULL,
  `perfil` text,
  `quantidade` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS rede_social;

CREATE TABLE `rede_social` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `facebook` mediumtext,
  `whatsapp` mediumtext,
  `telegram` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO rede_social VALUES("2","Admin","","17991626615","");


DROP TABLE IF EXISTS registro_acesso;

CREATE TABLE `registro_acesso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `ip` varchar(250) DEFAULT NULL,
  `navegador` varchar(250) DEFAULT NULL,
  `versao` varchar(250) DEFAULT NULL,
  `plataforma` varchar(250) DEFAULT NULL,
  `data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1538 DEFAULT CHARSET=latin1;

INSERT INTO registro_acesso VALUES("1","Admin","2","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 00:03:53");
INSERT INTO registro_acesso VALUES("2","Admin","1","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 00:04:01");
INSERT INTO registro_acesso VALUES("3","Admin","1","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 00:07:40");
INSERT INTO registro_acesso VALUES("4","Admin","2","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 01:16:39");
INSERT INTO registro_acesso VALUES("5","Admin","1","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 01:16:47");
INSERT INTO registro_acesso VALUES("6","Admin","1","45.63.114.117","Google Chrome","69.0.3497.100","windows","2018-10-15 08:11:03");
INSERT INTO registro_acesso VALUES("7","Admin","1","187.26.205.86","Google Chrome","69.0.3497.100","linux","2018-10-15 09:27:58");
INSERT INTO registro_acesso VALUES("8","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 10:13:50");
INSERT INTO registro_acesso VALUES("9","Admin","1","45.63.114.117","Google Chrome","69.0.3497.100","windows","2018-10-15 11:09:09");
INSERT INTO registro_acesso VALUES("10","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 12:10:19");
INSERT INTO registro_acesso VALUES("11","Admin","1","217.69.9.75","Google Chrome","69.0.3497.100","windows","2018-10-15 13:28:54");
INSERT INTO registro_acesso VALUES("12","Admin","1","217.69.9.75","Google Chrome","69.0.3497.100","windows","2018-10-15 14:11:05");
INSERT INTO registro_acesso VALUES("13","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 15:37:02");
INSERT INTO registro_acesso VALUES("14","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 15:49:26");
INSERT INTO registro_acesso VALUES("17","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 15:51:12");
INSERT INTO registro_acesso VALUES("18","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 15:52:21");
INSERT INTO registro_acesso VALUES("21","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 16:11:05");
INSERT INTO registro_acesso VALUES("22","Admin","1","217.69.9.75","Google Chrome","69.0.3497.100","windows","2018-10-15 16:11:15");
INSERT INTO registro_acesso VALUES("24","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 16:32:47");
INSERT INTO registro_acesso VALUES("25","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 16:33:05");
INSERT INTO registro_acesso VALUES("26","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 16:36:49");
INSERT INTO registro_acesso VALUES("27","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","windows","2018-10-15 17:06:48");
INSERT INTO registro_acesso VALUES("29","Admin","2","187.73.148.59","Google Chrome","69.0.3497.100","windows","2018-10-15 17:11:40");
INSERT INTO registro_acesso VALUES("32","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","windows","2018-10-15 17:14:02");
INSERT INTO registro_acesso VALUES("33","Admin","2","187.73.148.59","Google Chrome","69.0.3497.100","windows","2018-10-15 17:21:22");
INSERT INTO registro_acesso VALUES("35","Admin","1","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 19:00:54");
INSERT INTO registro_acesso VALUES("36","Admin","2","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 19:31:51");
INSERT INTO registro_acesso VALUES("37","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 19:51:09");
INSERT INTO registro_acesso VALUES("38","Admin","1","91.207.172.202","Google Chrome","69.0.3497.100","linux","2018-10-15 19:51:19");
INSERT INTO registro_acesso VALUES("39","Admin","1","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 19:56:47");
INSERT INTO registro_acesso VALUES("40","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 20:16:00");
INSERT INTO registro_acesso VALUES("47","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 20:48:17");
INSERT INTO registro_acesso VALUES("48","Admin","1","140.82.55.55","Google Chrome","69.0.3497.100","windows","2018-10-15 20:53:15");
INSERT INTO registro_acesso VALUES("50","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 20:53:44");
INSERT INTO registro_acesso VALUES("68","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 21:07:35");
INSERT INTO registro_acesso VALUES("69","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-15 21:11:02");
INSERT INTO registro_acesso VALUES("75","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-16 09:28:17");
INSERT INTO registro_acesso VALUES("76","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-16 15:37:06");
INSERT INTO registro_acesso VALUES("77","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-16 15:44:37");
INSERT INTO registro_acesso VALUES("86","Admin","1","187.26.201.255","Google Chrome","69.0.3497.100","linux","2018-10-17 16:21:21");
INSERT INTO registro_acesso VALUES("87","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-17 21:58:58");
INSERT INTO registro_acesso VALUES("111","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-18 20:53:41");
INSERT INTO registro_acesso VALUES("120","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-20 14:06:41");
INSERT INTO registro_acesso VALUES("121","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","windows","2018-10-20 15:39:32");
INSERT INTO registro_acesso VALUES("122","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-26 15:11:02");
INSERT INTO registro_acesso VALUES("123","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-26 21:46:37");
INSERT INTO registro_acesso VALUES("124","Admin","1","187.73.148.59","Google Chrome","69.0.3497.100","linux","2018-10-26 22:15:28");
INSERT INTO registro_acesso VALUES("125","Admin","1","187.73.148.59","Google Chrome","70.0.3538.67","windows","2018-10-27 13:03:13");
INSERT INTO registro_acesso VALUES("143","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-27 17:22:30");
INSERT INTO registro_acesso VALUES("144","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-27 18:09:41");
INSERT INTO registro_acesso VALUES("147","Admin","1","187.26.205.215","Mozilla Firefox","62.0","windows","2018-10-28 12:20:55");
INSERT INTO registro_acesso VALUES("152","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-28 14:02:30");
INSERT INTO registro_acesso VALUES("153","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 15:33:36");
INSERT INTO registro_acesso VALUES("154","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-28 15:34:05");
INSERT INTO registro_acesso VALUES("155","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-28 15:34:09");
INSERT INTO registro_acesso VALUES("156","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 15:46:41");
INSERT INTO registro_acesso VALUES("157","vando","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 15:46:52");
INSERT INTO registro_acesso VALUES("158","vando","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 15:48:19");
INSERT INTO registro_acesso VALUES("159","vando","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 15:48:26");
INSERT INTO registro_acesso VALUES("160","vando","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:03:22");
INSERT INTO registro_acesso VALUES("161","alexandre","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:03:33");
INSERT INTO registro_acesso VALUES("162","alexandre","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:07:09");
INSERT INTO registro_acesso VALUES("163","vando","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:07:17");
INSERT INTO registro_acesso VALUES("164","vando","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:09:34");
INSERT INTO registro_acesso VALUES("165","vando","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:09:42");
INSERT INTO registro_acesso VALUES("166","Admin","2","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-28 16:10:05");
INSERT INTO registro_acesso VALUES("167","Admin","1","187.73.148.59","Mozilla Firefox","62.0","windows","2018-10-28 16:10:10");
INSERT INTO registro_acesso VALUES("168","vando","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:20:38");
INSERT INTO registro_acesso VALUES("169","vando","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 16:20:46");
INSERT INTO registro_acesso VALUES("170","vando","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 17:11:55");
INSERT INTO registro_acesso VALUES("171","vando","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 17:12:33");
INSERT INTO registro_acesso VALUES("172","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 17:17:14");
INSERT INTO registro_acesso VALUES("173","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:12:03");
INSERT INTO registro_acesso VALUES("174","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:12:19");
INSERT INTO registro_acesso VALUES("175","vando","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:12:27");
INSERT INTO registro_acesso VALUES("176","vando","1","177.18.97.140","Google Chrome","70.0.3538.64","linux","2018-10-28 21:12:35");
INSERT INTO registro_acesso VALUES("177","vando","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:29:08");
INSERT INTO registro_acesso VALUES("178","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:29:14");
INSERT INTO registro_acesso VALUES("179","vando","1","177.18.97.140","Google Chrome","69.0.3497.100","windows","2018-10-28 21:40:49");
INSERT INTO registro_acesso VALUES("180","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:41:25");
INSERT INTO registro_acesso VALUES("181","vando","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:41:32");
INSERT INTO registro_acesso VALUES("182","biju","1","189.92.98.70","Google Chrome","69.0.3497.100","linux","2018-10-28 21:53:37");
INSERT INTO registro_acesso VALUES("183","vando","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:54:35");
INSERT INTO registro_acesso VALUES("184","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 21:54:40");
INSERT INTO registro_acesso VALUES("185","anderson81","1","177.87.2.133","Google Chrome","69.0.3497.100","linux","2018-10-28 22:09:06");
INSERT INTO registro_acesso VALUES("186","messias","1","170.78.60.162","Google Chrome","69.0.3497.100","linux","2018-10-28 22:13:17");
INSERT INTO registro_acesso VALUES("187","anderson81","1","177.87.2.133","Google Chrome","69.0.3497.100","linux","2018-10-28 22:15:39");
INSERT INTO registro_acesso VALUES("188","marcos","1","177.75.57.180","Google Chrome","69.0.3497.100","linux","2018-10-28 22:30:24");
INSERT INTO registro_acesso VALUES("189","alessandromp","1","192.12.113.86","Google Chrome","70.0.3538.64","linux","2018-10-28 22:42:56");
INSERT INTO registro_acesso VALUES("190","marcos","1","177.75.57.180","Google Chrome","69.0.3497.100","linux","2018-10-28 22:43:17");
INSERT INTO registro_acesso VALUES("191","marcos","1","177.75.57.180","Google Chrome","69.0.3497.100","linux","2018-10-28 22:44:16");
INSERT INTO registro_acesso VALUES("193","lucy","1","177.125.36.76","Google Chrome","70.0.3538.64","linux","2018-10-28 22:50:18");
INSERT INTO registro_acesso VALUES("194","jose44","1","179.127.235.153","Google Chrome","70.0.3538.64","linux","2018-10-28 22:50:36");
INSERT INTO registro_acesso VALUES("195","alessandromp","1","192.12.113.86","Google Chrome","70.0.3538.64","linux","2018-10-28 22:53:31");
INSERT INTO registro_acesso VALUES("196","lucy","2","66.249.85.9","Google Chrome","70.0.3538.64","linux","2018-10-28 22:56:38");
INSERT INTO registro_acesso VALUES("197","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-28 23:19:02");
INSERT INTO registro_acesso VALUES("198","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 23:39:37");
INSERT INTO registro_acesso VALUES("199","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-28 23:43:50");
INSERT INTO registro_acesso VALUES("200","Admin","1","187.26.205.251","Google Chrome","70.0.3538.64","linux","2018-10-29 07:09:19");
INSERT INTO registro_acesso VALUES("201","vando","1","189.58.237.196","Google Chrome","69.0.3497.100","windows","2018-10-29 07:28:46");
INSERT INTO registro_acesso VALUES("202","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-10-29 08:09:39");
INSERT INTO registro_acesso VALUES("204","vando","1","189.58.237.196","Google Chrome","69.0.3497.100","windows","2018-10-29 08:59:30");
INSERT INTO registro_acesso VALUES("205","vando","2","189.58.237.196","Google Chrome","69.0.3497.100","windows","2018-10-29 09:04:29");
INSERT INTO registro_acesso VALUES("206","alexandre","1","189.58.237.196","Google Chrome","69.0.3497.100","windows","2018-10-29 09:06:09");
INSERT INTO registro_acesso VALUES("207","alexandre","2","189.58.237.196","Google Chrome","69.0.3497.100","windows","2018-10-29 09:07:04");
INSERT INTO registro_acesso VALUES("210","vando","1","189.58.237.196","Google Chrome","69.0.3497.100","windows","2018-10-29 09:09:41");
INSERT INTO registro_acesso VALUES("211","messias","1","170.78.60.162","Google Chrome","69.0.3497.100","linux","2018-10-29 12:02:42");
INSERT INTO registro_acesso VALUES("212","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-10-29 13:30:02");
INSERT INTO registro_acesso VALUES("213","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-10-29 13:44:08");
INSERT INTO registro_acesso VALUES("216","jose44","1","179.127.238.160","Google Chrome","70.0.3538.64","linux","2018-10-29 15:11:24");
INSERT INTO registro_acesso VALUES("217","marcos","1","201.11.162.253","Google Chrome","69.0.3497.100","linux","2018-10-29 15:16:50");
INSERT INTO registro_acesso VALUES("218","marcos","1","177.75.57.180","Google Chrome","69.0.3497.100","linux","2018-10-29 15:45:12");
INSERT INTO registro_acesso VALUES("219","marco17","1","187.26.219.44","Google Chrome","69.0.3497.100","linux","2018-10-29 18:06:42");
INSERT INTO registro_acesso VALUES("220","marco17","1","187.26.219.44","Google Chrome","69.0.3497.100","linux","2018-10-29 18:38:46");
INSERT INTO registro_acesso VALUES("223","messias","1","170.78.60.162","Google Chrome","69.0.3497.100","windows","2018-10-29 19:58:09");
INSERT INTO registro_acesso VALUES("224","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-10-29 20:25:11");
INSERT INTO registro_acesso VALUES("227","messias","1","170.78.60.162","Google Chrome","69.0.3497.100","windows","2018-10-29 21:43:39");
INSERT INTO registro_acesso VALUES("229","alexandre","1","187.26.66.68","Google Chrome","46.0.2490.76","linux","2018-10-29 22:32:27");
INSERT INTO registro_acesso VALUES("231","alessandromp","1","192.12.113.86","Google Chrome","70.0.3538.80","linux","2018-10-29 23:04:15");
INSERT INTO registro_acesso VALUES("233","marcos","1","201.87.244.10","Google Chrome","69.0.3497.100","linux","2018-10-30 07:32:31");
INSERT INTO registro_acesso VALUES("234","marcos","1","201.87.244.10","Google Chrome","69.0.3497.100","linux","2018-10-30 07:47:10");
INSERT INTO registro_acesso VALUES("235","marco17","1","187.26.133.152","Google Chrome","69.0.3497.100","linux","2018-10-30 09:20:43");
INSERT INTO registro_acesso VALUES("236","marcos","1","189.94.175.104","Google Chrome","69.0.3497.100","linux","2018-10-30 09:34:25");
INSERT INTO registro_acesso VALUES("237","vando","1","189.40.68.248","Google Chrome","70.0.3538.80","linux","2018-10-30 10:51:53");
INSERT INTO registro_acesso VALUES("238","anderson81","1","177.87.2.153","Google Chrome","69.0.3497.100","linux","2018-10-30 12:45:46");
INSERT INTO registro_acesso VALUES("239","marcos","1","189.94.175.104","Google Chrome","69.0.3497.100","linux","2018-10-30 13:36:24");
INSERT INTO registro_acesso VALUES("240","jose44","1","177.220.166.188","Google Chrome","70.0.3538.64","linux","2018-10-30 15:15:10");
INSERT INTO registro_acesso VALUES("241","Admin","1","189.92.104.68","Google Chrome","70.0.3538.64","linux","2018-10-30 16:22:10");
INSERT INTO registro_acesso VALUES("243","Admin","1","189.92.104.68","Google Chrome","70.0.3538.64","linux","2018-10-30 18:07:03");
INSERT INTO registro_acesso VALUES("244","marcos","1","201.87.244.10","Google Chrome","69.0.3497.100","linux","2018-10-30 18:15:58");
INSERT INTO registro_acesso VALUES("245","vando","1","189.40.69.53","Google Chrome","70.0.3538.80","linux","2018-10-30 18:22:10");
INSERT INTO registro_acesso VALUES("246","vando","1","186.213.154.234","Google Chrome","69.0.3497.100","windows","2018-10-30 19:01:50");
INSERT INTO registro_acesso VALUES("248","lucy","1","170.245.217.221","Google Chrome","70.0.3538.77","windows","2018-10-30 19:08:59");
INSERT INTO registro_acesso VALUES("249","lucy","1","170.245.217.221","Google Chrome","70.0.3538.80","linux","2018-10-30 19:20:16");
INSERT INTO registro_acesso VALUES("250","lucy","1","170.245.217.221","Google Chrome","70.0.3538.80","linux","2018-10-30 19:21:01");
INSERT INTO registro_acesso VALUES("251","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:21:11");
INSERT INTO registro_acesso VALUES("252","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:21:30");
INSERT INTO registro_acesso VALUES("253","vando","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:21:38");
INSERT INTO registro_acesso VALUES("254","vando","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:24:21");
INSERT INTO registro_acesso VALUES("255","vando","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:24:30");
INSERT INTO registro_acesso VALUES("256","vando","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:26:19");
INSERT INTO registro_acesso VALUES("257","vando","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:30:19");
INSERT INTO registro_acesso VALUES("258","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 19:30:23");
INSERT INTO registro_acesso VALUES("259","marcos","1","177.75.57.180","Google Chrome","69.0.3497.100","linux","2018-10-30 19:47:21");
INSERT INTO registro_acesso VALUES("261","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-10-30 20:59:26");
INSERT INTO registro_acesso VALUES("262","lucy","1","170.245.217.221","Google Chrome","70.0.3538.77","windows","2018-10-30 21:02:00");
INSERT INTO registro_acesso VALUES("265","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-10-30 21:30:55");
INSERT INTO registro_acesso VALUES("267","lucy","2","170.245.217.221","Google Chrome","70.0.3538.77","windows","2018-10-30 21:50:40");
INSERT INTO registro_acesso VALUES("268","marco17","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 22:36:12");
INSERT INTO registro_acesso VALUES("269","marco17","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 22:40:27");
INSERT INTO registro_acesso VALUES("270","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 22:40:33");
INSERT INTO registro_acesso VALUES("271","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-30 22:44:04");
INSERT INTO registro_acesso VALUES("272","vando","1","186.213.154.234","Google Chrome","70.0.3538.80","linux","2018-10-31 00:07:09");
INSERT INTO registro_acesso VALUES("273","vando","2","66.249.85.9","Google Chrome","70.0.3538.80","linux","2018-10-31 00:10:15");
INSERT INTO registro_acesso VALUES("274","alexandre","1","186.213.154.234","Google Chrome","70.0.3538.80","linux","2018-10-31 00:11:13");
INSERT INTO registro_acesso VALUES("275","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-10-31 04:09:25");
INSERT INTO registro_acesso VALUES("276","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-10-31 04:09:26");
INSERT INTO registro_acesso VALUES("277","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-10-31 04:09:27");
INSERT INTO registro_acesso VALUES("278","alessandromp","1","192.12.113.86","Google Chrome","70.0.3538.80","linux","2018-10-31 06:54:58");
INSERT INTO registro_acesso VALUES("279","vando","1","186.213.154.234","Google Chrome","69.0.3497.100","windows","2018-10-31 06:58:12");
INSERT INTO registro_acesso VALUES("280","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-10-31 07:04:03");
INSERT INTO registro_acesso VALUES("282","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-31 07:53:45");
INSERT INTO registro_acesso VALUES("283","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-31 07:55:50");
INSERT INTO registro_acesso VALUES("284","vando","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-31 07:55:59");
INSERT INTO registro_acesso VALUES("285","vando","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-31 08:01:10");
INSERT INTO registro_acesso VALUES("286","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-31 08:01:20");
INSERT INTO registro_acesso VALUES("287","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-10-31 08:12:42");
INSERT INTO registro_acesso VALUES("288","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-10-31 08:22:51");
INSERT INTO registro_acesso VALUES("289","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-10-31 08:53:44");
INSERT INTO registro_acesso VALUES("290","anderson81","1","186.208.74.198","Google Chrome","69.0.3497.100","linux","2018-10-31 11:24:26");
INSERT INTO registro_acesso VALUES("291","marcos","1","201.87.244.10","Google Chrome","69.0.3497.100","linux","2018-10-31 11:49:27");
INSERT INTO registro_acesso VALUES("293","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-10-31 13:29:32");
INSERT INTO registro_acesso VALUES("294","marcos","1","179.241.247.85","Google Chrome","69.0.3497.100","linux","2018-10-31 15:05:00");
INSERT INTO registro_acesso VALUES("297","Admin","1","189.92.104.68","Google Chrome","70.0.3538.64","linux","2018-10-31 17:20:52");
INSERT INTO registro_acesso VALUES("298","messias","1","170.78.60.206","Google Chrome","69.0.3497.100","linux","2018-10-31 17:31:17");
INSERT INTO registro_acesso VALUES("300","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-10-31 18:31:50");
INSERT INTO registro_acesso VALUES("303","vando","1","186.213.154.234","Google Chrome","70.0.3538.77","windows","2018-10-31 19:35:13");
INSERT INTO registro_acesso VALUES("304","lucy","1","177.125.36.215","Google Chrome","70.0.3538.77","windows","2018-10-31 19:53:17");
INSERT INTO registro_acesso VALUES("305","lucy","2","177.125.36.215","Google Chrome","70.0.3538.77","windows","2018-10-31 19:59:46");
INSERT INTO registro_acesso VALUES("307","lucy","1","177.125.36.215","Google Chrome","70.0.3538.77","windows","2018-10-31 20:59:01");
INSERT INTO registro_acesso VALUES("308","messias","1","189.92.202.85","Google Chrome","69.0.3497.100","linux","2018-10-31 21:00:42");
INSERT INTO registro_acesso VALUES("309","vando","1","186.213.154.234","Google Chrome","70.0.3538.77","windows","2018-10-31 21:01:22");
INSERT INTO registro_acesso VALUES("312","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-10-31 21:15:01");
INSERT INTO registro_acesso VALUES("313","messias","1","189.92.202.85","Google Chrome","69.0.3497.100","linux","2018-10-31 21:41:17");
INSERT INTO registro_acesso VALUES("314","vando","1","186.213.154.234","Google Chrome","70.0.3538.77","windows","2018-10-31 21:44:16");
INSERT INTO registro_acesso VALUES("315","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-01 09:49:48");
INSERT INTO registro_acesso VALUES("316","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-01 09:51:51");
INSERT INTO registro_acesso VALUES("317","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-01 10:31:20");
INSERT INTO registro_acesso VALUES("318","vando","1","186.213.154.234","Google Chrome","70.0.3538.77","windows","2018-11-01 12:48:20");
INSERT INTO registro_acesso VALUES("319","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-01 13:18:19");
INSERT INTO registro_acesso VALUES("320","jose44","1","179.127.237.16","Google Chrome","70.0.3538.64","linux","2018-11-01 13:33:11");
INSERT INTO registro_acesso VALUES("321","jose44","1","201.55.178.155","Google Chrome","70.0.3538.64","linux","2018-11-01 14:15:48");
INSERT INTO registro_acesso VALUES("322","Admin","1","189.92.104.68","Google Chrome","70.0.3538.64","linux","2018-11-01 14:32:32");
INSERT INTO registro_acesso VALUES("323","marcos","1","189.92.250.98","Google Chrome","70.0.3538.80","linux","2018-11-01 14:39:16");
INSERT INTO registro_acesso VALUES("324","jose44","1","179.127.237.16","Google Chrome","70.0.3538.64","linux","2018-11-01 17:14:44");
INSERT INTO registro_acesso VALUES("325","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-01 17:43:42");
INSERT INTO registro_acesso VALUES("326","alexandre","1","189.40.69.154","Google Chrome","70.0.3538.80","linux","2018-11-01 17:49:58");
INSERT INTO registro_acesso VALUES("327","alexandre","2","66.249.85.7","Google Chrome","70.0.3538.80","linux","2018-11-01 17:50:29");
INSERT INTO registro_acesso VALUES("328","vando","1","189.40.69.154","Google Chrome","70.0.3538.80","linux","2018-11-01 17:50:37");
INSERT INTO registro_acesso VALUES("329","Admin","1","179.108.180.148","Google Chrome","70.0.3538.64","linux","2018-11-01 18:38:43");
INSERT INTO registro_acesso VALUES("330","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-01 19:21:45");
INSERT INTO registro_acesso VALUES("333","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-01 21:39:43");
INSERT INTO registro_acesso VALUES("334","lucy","1","177.125.33.90","Google Chrome","70.0.3538.77","windows","2018-11-01 22:27:04");
INSERT INTO registro_acesso VALUES("335","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-01 22:28:25");
INSERT INTO registro_acesso VALUES("336","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-11-01 22:34:29");
INSERT INTO registro_acesso VALUES("337","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-11-01 22:38:17");
INSERT INTO registro_acesso VALUES("338","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-11-01 22:42:03");
INSERT INTO registro_acesso VALUES("339","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-11-01 22:43:38");
INSERT INTO registro_acesso VALUES("340","vando","1","187.113.248.240","Google Chrome","70.0.3538.77","windows","2018-11-01 23:28:49");
INSERT INTO registro_acesso VALUES("341","vando","1","187.113.248.240","Google Chrome","70.0.3538.80","linux","2018-11-01 23:52:19");
INSERT INTO registro_acesso VALUES("342","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 00:05:53");
INSERT INTO registro_acesso VALUES("343","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 00:06:44");
INSERT INTO registro_acesso VALUES("344","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-02 05:22:06");
INSERT INTO registro_acesso VALUES("345","vando","1","187.113.248.240","Google Chrome","70.0.3538.80","linux","2018-11-02 07:05:11");
INSERT INTO registro_acesso VALUES("346","vando","1","187.113.248.240","Google Chrome","70.0.3538.77","windows","2018-11-02 07:08:48");
INSERT INTO registro_acesso VALUES("348","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 09:47:59");
INSERT INTO registro_acesso VALUES("349","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 09:49:09");
INSERT INTO registro_acesso VALUES("350","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 09:49:36");
INSERT INTO registro_acesso VALUES("351","messias","1","170.78.60.162","Google Chrome","70.0.3538.80","linux","2018-11-02 09:49:57");
INSERT INTO registro_acesso VALUES("352","messias","1","187.113.248.240","Google Chrome","70.0.3538.80","linux","2018-11-02 10:01:39");
INSERT INTO registro_acesso VALUES("353","messias","1","187.113.248.240","Google Chrome","70.0.3538.77","windows","2018-11-02 10:07:18");
INSERT INTO registro_acesso VALUES("354","messias","2","187.113.248.240","Google Chrome","70.0.3538.77","windows","2018-11-02 10:14:01");
INSERT INTO registro_acesso VALUES("355","vando","1","187.113.248.240","Google Chrome","70.0.3538.77","windows","2018-11-02 10:14:05");
INSERT INTO registro_acesso VALUES("356","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-11-02 10:41:47");
INSERT INTO registro_acesso VALUES("357","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 11:00:43");
INSERT INTO registro_acesso VALUES("358","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 11:08:44");
INSERT INTO registro_acesso VALUES("359","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 11:11:44");
INSERT INTO registro_acesso VALUES("360","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 11:12:44");
INSERT INTO registro_acesso VALUES("361","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-11-02 11:23:36");
INSERT INTO registro_acesso VALUES("362","marcos","1","189.92.215.15","Google Chrome","70.0.3538.80","linux","2018-11-02 11:23:58");
INSERT INTO registro_acesso VALUES("363","marco17","1","177.58.233.0","Google Chrome","69.0.3497.100","linux","2018-11-02 11:35:10");
INSERT INTO registro_acesso VALUES("364","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-02 11:38:32");
INSERT INTO registro_acesso VALUES("365","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 12:13:11");
INSERT INTO registro_acesso VALUES("366","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 12:43:21");
INSERT INTO registro_acesso VALUES("367","primo1020","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 12:43:31");
INSERT INTO registro_acesso VALUES("368","primo1020","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 12:45:43");
INSERT INTO registro_acesso VALUES("369","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 12:45:48");
INSERT INTO registro_acesso VALUES("370","Admin","1","187.107.125.217","Google Chrome","70.0.3538.77","windows","2018-11-02 13:35:09");
INSERT INTO registro_acesso VALUES("372","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-02 14:05:54");
INSERT INTO registro_acesso VALUES("374","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-11-02 14:25:37");
INSERT INTO registro_acesso VALUES("375","alexandre","1","187.26.215.3","Google Chrome","46.0.2490.76","linux","2018-11-02 14:59:56");
INSERT INTO registro_acesso VALUES("376","alexandre","2","187.26.215.3","Google Chrome","46.0.2490.76","linux","2018-11-02 15:01:40");
INSERT INTO registro_acesso VALUES("378","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-02 15:05:09");
INSERT INTO registro_acesso VALUES("379","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-02 15:19:24");
INSERT INTO registro_acesso VALUES("382","marcos","1","179.242.0.93","Google Chrome","70.0.3538.80","linux","2018-11-02 17:31:27");
INSERT INTO registro_acesso VALUES("383","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-02 18:00:00");
INSERT INTO registro_acesso VALUES("384","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-02 18:01:02");
INSERT INTO registro_acesso VALUES("385","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-02 18:23:47");
INSERT INTO registro_acesso VALUES("386","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-02 18:23:50");
INSERT INTO registro_acesso VALUES("387","biju","1","177.58.249.32","Google Chrome","69.0.3497.100","linux","2018-11-02 18:25:44");
INSERT INTO registro_acesso VALUES("388","marcos","1","177.75.57.188","Google Chrome","70.0.3538.80","linux","2018-11-02 18:33:35");
INSERT INTO registro_acesso VALUES("389","messias","1","170.78.60.162","Google Chrome","4.0","linux","2018-11-02 19:21:19");
INSERT INTO registro_acesso VALUES("390","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-02 20:10:11");
INSERT INTO registro_acesso VALUES("391","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-02 21:32:21");
INSERT INTO registro_acesso VALUES("392","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-11-02 22:49:32");
INSERT INTO registro_acesso VALUES("393","lucy","1","177.125.32.81","Google Chrome","70.0.3538.80","linux","2018-11-02 23:10:13");
INSERT INTO registro_acesso VALUES("394","lucy","2","177.125.32.81","Google Chrome","70.0.3538.80","linux","2018-11-02 23:18:44");
INSERT INTO registro_acesso VALUES("395","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-02 23:25:22");
INSERT INTO registro_acesso VALUES("396","Admin","1","187.107.125.217","Google Chrome","70.0.3538.77","windows","2018-11-02 23:57:00");
INSERT INTO registro_acesso VALUES("397","Admin","2","187.107.125.217","Google Chrome","70.0.3538.77","windows","2018-11-02 23:57:37");
INSERT INTO registro_acesso VALUES("398","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-03 00:15:07");
INSERT INTO registro_acesso VALUES("399","vando","1","189.58.236.221","Google Chrome","70.0.3538.80","linux","2018-11-03 04:22:50");
INSERT INTO registro_acesso VALUES("400","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-03 06:30:17");
INSERT INTO registro_acesso VALUES("401","messias","1","170.78.60.162","Google Chrome","4.0","linux","2018-11-03 08:29:51");
INSERT INTO registro_acesso VALUES("402","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-03 08:50:17");
INSERT INTO registro_acesso VALUES("403","alexandre","1","187.111.159.231","Google Chrome","69.0.3497.100","windows","2018-11-03 10:12:52");
INSERT INTO registro_acesso VALUES("404","alexandre","2","187.111.159.231","Google Chrome","69.0.3497.100","windows","2018-11-03 10:20:24");
INSERT INTO registro_acesso VALUES("405","anderson81","1","177.87.2.159","Google Chrome","70.0.3538.80","linux","2018-11-03 11:32:17");
INSERT INTO registro_acesso VALUES("406","marcos","1","189.94.110.81","Google Chrome","70.0.3538.80","linux","2018-11-03 11:37:50");
INSERT INTO registro_acesso VALUES("407","anderson81","1","177.87.2.159","Google Chrome","70.0.3538.80","linux","2018-11-03 11:38:51");
INSERT INTO registro_acesso VALUES("408","vando","1","177.18.102.116","Google Chrome","70.0.3538.80","linux","2018-11-03 12:21:32");
INSERT INTO registro_acesso VALUES("410","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-03 13:59:38");
INSERT INTO registro_acesso VALUES("411","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-03 15:01:43");
INSERT INTO registro_acesso VALUES("412","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-03 15:02:23");
INSERT INTO registro_acesso VALUES("413","vando","1","177.156.60.69","Google Chrome","70.0.3538.77","windows","2018-11-03 15:35:08");
INSERT INTO registro_acesso VALUES("414","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-03 17:51:26");
INSERT INTO registro_acesso VALUES("415","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-03 18:10:10");
INSERT INTO registro_acesso VALUES("416","Admin","1","187.73.148.59","Google Chrome","70.0.3538.64","linux","2018-11-03 18:22:58");
INSERT INTO registro_acesso VALUES("417","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-03 18:58:25");
INSERT INTO registro_acesso VALUES("418","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-03 19:05:57");
INSERT INTO registro_acesso VALUES("419","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-03 19:07:13");
INSERT INTO registro_acesso VALUES("421","alexandre","1","187.111.159.231","Google Chrome","70.0.3538.77","windows","2018-11-03 20:21:04");
INSERT INTO registro_acesso VALUES("422","alexandre","2","187.111.159.231","Google Chrome","70.0.3538.77","windows","2018-11-03 20:23:02");
INSERT INTO registro_acesso VALUES("423","marco17","1","187.26.138.1","Google Chrome","69.0.3497.100","linux","2018-11-03 21:58:48");
INSERT INTO registro_acesso VALUES("424","lucy","1","177.125.32.75","Google Chrome","70.0.3538.77","windows","2018-11-04 04:37:13");
INSERT INTO registro_acesso VALUES("425","alessandromp","1","192.12.113.79","Google Chrome","70.0.3538.80","linux","2018-11-04 09:31:18");
INSERT INTO registro_acesso VALUES("428","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-04 11:20:49");
INSERT INTO registro_acesso VALUES("432","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-04 13:23:42");
INSERT INTO registro_acesso VALUES("433","jose44","1","179.127.235.37","Google Chrome","70.0.3538.80","linux","2018-11-04 19:18:20");
INSERT INTO registro_acesso VALUES("434","alessandromp","1","192.12.113.79","Google Chrome","70.0.3538.80","linux","2018-11-04 19:23:16");
INSERT INTO registro_acesso VALUES("439","messias","1","170.78.60.162","Google Chrome","70.0.3538.80","linux","2018-11-04 22:43:42");
INSERT INTO registro_acesso VALUES("440","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-04 22:49:26");
INSERT INTO registro_acesso VALUES("441","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-04 22:51:10");
INSERT INTO registro_acesso VALUES("442","primo1020","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-04 22:51:26");
INSERT INTO registro_acesso VALUES("443","primo1020","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-04 22:51:42");
INSERT INTO registro_acesso VALUES("444","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-04 22:51:52");
INSERT INTO registro_acesso VALUES("445","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-04 23:11:23");
INSERT INTO registro_acesso VALUES("446","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-05 08:06:53");
INSERT INTO registro_acesso VALUES("447","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-05 08:12:08");
INSERT INTO registro_acesso VALUES("449","lucy","1","177.234.132.239","Google Chrome","70.0.3538.77","windows","2018-11-05 08:59:22");
INSERT INTO registro_acesso VALUES("450","lucy","1","177.234.132.239","Google Chrome","70.0.3538.77","windows","2018-11-05 09:02:32");
INSERT INTO registro_acesso VALUES("451","vando","1","187.111.157.231","Google Chrome","70.0.3538.80","linux","2018-11-05 09:03:43");
INSERT INTO registro_acesso VALUES("452","lucy","1","177.234.132.239","Google Chrome","70.0.3538.80","linux","2018-11-05 09:11:06");
INSERT INTO registro_acesso VALUES("453","lucy","2","177.234.132.239","Google Chrome","70.0.3538.80","linux","2018-11-05 09:15:26");
INSERT INTO registro_acesso VALUES("454","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-05 11:47:03");
INSERT INTO registro_acesso VALUES("455","vando","1","177.132.217.229","Google Chrome","70.0.3538.77","windows","2018-11-05 12:00:41");
INSERT INTO registro_acesso VALUES("456","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-05 13:11:11");
INSERT INTO registro_acesso VALUES("457","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-05 13:42:28");
INSERT INTO registro_acesso VALUES("458","alexandre","1","187.111.159.231","Google Chrome","70.0.3538.77","windows","2018-11-05 13:46:41");
INSERT INTO registro_acesso VALUES("459","alexandre","2","187.111.159.231","Google Chrome","70.0.3538.77","windows","2018-11-05 13:49:19");
INSERT INTO registro_acesso VALUES("460","marcos","1","189.94.119.34","Google Chrome","70.0.3538.80","linux","2018-11-05 15:54:11");
INSERT INTO registro_acesso VALUES("461","marcos","1","189.94.119.34","Google Chrome","70.0.3538.80","linux","2018-11-05 17:37:22");
INSERT INTO registro_acesso VALUES("462","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-05 18:06:24");
INSERT INTO registro_acesso VALUES("465","alessandromp","1","45.239.103.161","Google Chrome","70.0.3538.80","linux","2018-11-05 18:33:45");
INSERT INTO registro_acesso VALUES("466","marcos","1","189.94.119.34","Google Chrome","70.0.3538.80","linux","2018-11-05 19:56:11");
INSERT INTO registro_acesso VALUES("467","vando","1","177.22.178.10","Google Chrome","70.0.3538.77","windows","2018-11-05 20:05:29");
INSERT INTO registro_acesso VALUES("468","alexandre","1","187.111.159.231","Google Chrome","70.0.3538.77","windows","2018-11-05 20:35:04");
INSERT INTO registro_acesso VALUES("469","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-05 21:04:21");
INSERT INTO registro_acesso VALUES("470","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-05 21:54:24");
INSERT INTO registro_acesso VALUES("471","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-05 22:00:30");
INSERT INTO registro_acesso VALUES("472","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-05 22:02:08");
INSERT INTO registro_acesso VALUES("473","jose44","1","187.87.213.72","Google Chrome","70.0.3538.80","linux","2018-11-05 22:08:49");
INSERT INTO registro_acesso VALUES("474","vando","1","177.22.178.10","Google Chrome","70.0.3538.77","windows","2018-11-05 22:11:52");
INSERT INTO registro_acesso VALUES("475","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-05 23:02:59");
INSERT INTO registro_acesso VALUES("476","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-05 23:07:09");
INSERT INTO registro_acesso VALUES("477","biju","1","177.22.178.180","Google Chrome","69.0.3497.100","linux","2018-11-06 00:28:41");
INSERT INTO registro_acesso VALUES("478","vando","1","177.22.178.10","Google Chrome","70.0.3538.77","windows","2018-11-06 07:11:59");
INSERT INTO registro_acesso VALUES("481","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-06 12:38:32");
INSERT INTO registro_acesso VALUES("482","marcos","1","179.242.51.43","Google Chrome","70.0.3538.80","linux","2018-11-06 13:05:08");
INSERT INTO registro_acesso VALUES("483","vando","1","177.22.178.0","Google Chrome","70.0.3538.77","windows","2018-11-06 13:05:26");
INSERT INTO registro_acesso VALUES("485","alexandre","1","187.26.136.109","Google Chrome","46.0.2490.76","linux","2018-11-06 16:14:41");
INSERT INTO registro_acesso VALUES("486","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-06 16:15:10");
INSERT INTO registro_acesso VALUES("487","vando","1","187.111.159.45","Google Chrome","70.0.3538.80","linux","2018-11-06 17:33:28");
INSERT INTO registro_acesso VALUES("488","vando","1","177.22.178.0","Google Chrome","70.0.3538.77","windows","2018-11-06 19:24:04");
INSERT INTO registro_acesso VALUES("489","Admin","1","179.241.192.92","Google Chrome","70.0.3538.80","linux","2018-11-06 19:38:33");
INSERT INTO registro_acesso VALUES("490","vando","2","177.22.178.0","Google Chrome","70.0.3538.77","windows","2018-11-06 20:19:06");
INSERT INTO registro_acesso VALUES("491","primo1020","1","177.22.178.0","Google Chrome","70.0.3538.77","windows","2018-11-06 20:19:25");
INSERT INTO registro_acesso VALUES("492","primo1020","2","177.22.178.0","Google Chrome","70.0.3538.77","windows","2018-11-06 20:26:23");
INSERT INTO registro_acesso VALUES("493","vando","1","177.22.178.0","Google Chrome","70.0.3538.77","windows","2018-11-06 20:56:57");
INSERT INTO registro_acesso VALUES("494","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-06 21:38:47");
INSERT INTO registro_acesso VALUES("495","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-06 22:42:30");
INSERT INTO registro_acesso VALUES("498","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-06 23:12:59");
INSERT INTO registro_acesso VALUES("499","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-06 23:35:01");
INSERT INTO registro_acesso VALUES("500","biju","1","177.22.178.30","Google Chrome","69.0.3497.100","linux","2018-11-07 00:28:58");
INSERT INTO registro_acesso VALUES("501","marco17","1","131.255.69.1","Google Chrome","69.0.3497.100","linux","2018-11-07 08:23:10");
INSERT INTO registro_acesso VALUES("502","marcos","1","179.242.50.45","Google Chrome","70.0.3538.80","linux","2018-11-07 10:09:18");
INSERT INTO registro_acesso VALUES("503","alexandre","1","187.26.136.109","Google Chrome","46.0.2490.76","linux","2018-11-07 10:42:11");
INSERT INTO registro_acesso VALUES("504","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-07 11:19:13");
INSERT INTO registro_acesso VALUES("505","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-07 13:08:18");
INSERT INTO registro_acesso VALUES("507","marcos","1","177.75.58.8","Google Chrome","70.0.3538.80","linux","2018-11-07 13:50:27");
INSERT INTO registro_acesso VALUES("508","marcos","1","189.94.165.47","Google Chrome","70.0.3538.80","linux","2018-11-07 15:51:04");
INSERT INTO registro_acesso VALUES("511","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 19:54:12");
INSERT INTO registro_acesso VALUES("512","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-07 20:37:00");
INSERT INTO registro_acesso VALUES("513","biju","1","177.22.178.30","Google Chrome","69.0.3497.100","linux","2018-11-07 21:19:26");
INSERT INTO registro_acesso VALUES("514","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 21:19:54");
INSERT INTO registro_acesso VALUES("515","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-07 22:36:01");
INSERT INTO registro_acesso VALUES("516","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-07 22:41:10");
INSERT INTO registro_acesso VALUES("518","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-07 23:11:15");
INSERT INTO registro_acesso VALUES("519","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 23:30:47");
INSERT INTO registro_acesso VALUES("520","salsicha","2","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 23:47:19");
INSERT INTO registro_acesso VALUES("521","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 23:47:46");
INSERT INTO registro_acesso VALUES("522","salsicha","2","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 23:47:54");
INSERT INTO registro_acesso VALUES("523","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-07 23:48:22");
INSERT INTO registro_acesso VALUES("524","vando","1","189.40.69.214","Google Chrome","70.0.3538.80","linux","2018-11-08 08:27:12");
INSERT INTO registro_acesso VALUES("529","vando","1","179.187.30.212","Google Chrome","70.0.3538.80","linux","2018-11-08 09:45:18");
INSERT INTO registro_acesso VALUES("530","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 10:22:18");
INSERT INTO registro_acesso VALUES("531","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 11:50:55");
INSERT INTO registro_acesso VALUES("532","Admin","1","185.89.248.4","Google Chrome","70.0.3538.77","windows","2018-11-08 13:53:52");
INSERT INTO registro_acesso VALUES("533","Admin","2","185.89.248.4","Google Chrome","70.0.3538.77","windows","2018-11-08 14:04:36");
INSERT INTO registro_acesso VALUES("534","Admin","2","185.89.248.4","Google Chrome","70.0.3538.77","windows","2018-11-08 14:16:24");
INSERT INTO registro_acesso VALUES("535","Admin","1","185.89.248.4","Google Chrome","70.0.3538.77","windows","2018-11-08 14:16:37");
INSERT INTO registro_acesso VALUES("536","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 14:50:15");
INSERT INTO registro_acesso VALUES("537","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 15:12:02");
INSERT INTO registro_acesso VALUES("538","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-08 15:27:13");
INSERT INTO registro_acesso VALUES("539","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 15:30:08");
INSERT INTO registro_acesso VALUES("540","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-08 16:12:08");
INSERT INTO registro_acesso VALUES("541","alexandre","1","177.58.233.68","Google Chrome","46.0.2490.76","linux","2018-11-08 17:31:31");
INSERT INTO registro_acesso VALUES("542","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 17:46:15");
INSERT INTO registro_acesso VALUES("543","biju","1","177.18.50.228","Google Chrome","69.0.3497.100","linux","2018-11-08 17:51:30");
INSERT INTO registro_acesso VALUES("544","vando","2","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 18:05:42");
INSERT INTO registro_acesso VALUES("545","messias","1","138.204.141.234","Google Chrome","70.0.3538.77","windows","2018-11-08 19:17:33");
INSERT INTO registro_acesso VALUES("546","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-08 19:24:55");
INSERT INTO registro_acesso VALUES("547","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 19:54:48");
INSERT INTO registro_acesso VALUES("548","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 19:57:43");
INSERT INTO registro_acesso VALUES("549","Admin","2","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 19:58:19");
INSERT INTO registro_acesso VALUES("550","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-08 20:01:26");
INSERT INTO registro_acesso VALUES("551","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 20:16:11");
INSERT INTO registro_acesso VALUES("552","vando","2","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 20:43:00");
INSERT INTO registro_acesso VALUES("553","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 20:43:16");
INSERT INTO registro_acesso VALUES("556","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-08 21:24:17");
INSERT INTO registro_acesso VALUES("557","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-08 21:56:52");
INSERT INTO registro_acesso VALUES("558","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-08 22:59:33");
INSERT INTO registro_acesso VALUES("559","biju","1","177.22.178.30","Google Chrome","70.0.3538.77","windows","2018-11-08 23:17:10");
INSERT INTO registro_acesso VALUES("560","biju","1","177.22.178.30","Google Chrome","69.0.3497.100","linux","2018-11-08 23:46:27");
INSERT INTO registro_acesso VALUES("561","biju","1","177.22.178.30","Google Chrome","69.0.3497.100","linux","2018-11-08 23:57:55");
INSERT INTO registro_acesso VALUES("564","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-09 09:25:19");
INSERT INTO registro_acesso VALUES("565","Admin","1","187.26.199.144","Google Chrome","70.0.3538.80","linux","2018-11-09 12:17:38");
INSERT INTO registro_acesso VALUES("566","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-09 12:32:08");
INSERT INTO registro_acesso VALUES("567","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-09 13:45:03");
INSERT INTO registro_acesso VALUES("568","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-09 13:45:03");
INSERT INTO registro_acesso VALUES("569","Admin","1","179.241.217.47","Google Chrome","70.0.3538.80","linux","2018-11-09 15:01:23");
INSERT INTO registro_acesso VALUES("570","Admin","1","179.241.217.47","Google Chrome","70.0.3538.80","linux","2018-11-09 16:37:11");
INSERT INTO registro_acesso VALUES("576","biju","1","177.22.178.30","Google Chrome","69.0.3497.100","linux","2018-11-09 19:18:22");
INSERT INTO registro_acesso VALUES("577","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-09 19:19:31");
INSERT INTO registro_acesso VALUES("578","biju","1","177.22.178.30","Google Chrome","69.0.3497.100","linux","2018-11-09 19:19:45");
INSERT INTO registro_acesso VALUES("579","lucy","1","177.234.132.51","Google Chrome","70.0.3538.77","windows","2018-11-09 20:09:12");
INSERT INTO registro_acesso VALUES("580","lucy","2","177.234.132.51","Google Chrome","70.0.3538.77","windows","2018-11-09 20:12:17");
INSERT INTO registro_acesso VALUES("581","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-09 20:34:03");
INSERT INTO registro_acesso VALUES("582","jose44","1","179.127.237.28","Google Chrome","70.0.3538.80","linux","2018-11-09 20:44:22");
INSERT INTO registro_acesso VALUES("583","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-09 21:14:30");
INSERT INTO registro_acesso VALUES("584","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-09 21:45:05");
INSERT INTO registro_acesso VALUES("585","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-09 21:49:29");
INSERT INTO registro_acesso VALUES("586","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-09 22:52:48");
INSERT INTO registro_acesso VALUES("587","marco17","1","131.255.69.1","Google Chrome","70.0.3538.80","linux","2018-11-10 08:53:43");
INSERT INTO registro_acesso VALUES("588","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-10 10:20:29");
INSERT INTO registro_acesso VALUES("589","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-10 12:53:19");
INSERT INTO registro_acesso VALUES("591","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 15:12:35");
INSERT INTO registro_acesso VALUES("592","jose44","1","179.127.236.76","Google Chrome","70.0.3538.80","linux","2018-11-10 16:21:59");
INSERT INTO registro_acesso VALUES("593","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 17:25:40");
INSERT INTO registro_acesso VALUES("594","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 17:55:32");
INSERT INTO registro_acesso VALUES("595","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-10 18:24:36");
INSERT INTO registro_acesso VALUES("596","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 18:36:16");
INSERT INTO registro_acesso VALUES("599","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 18:46:32");
INSERT INTO registro_acesso VALUES("600","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 19:36:58");
INSERT INTO registro_acesso VALUES("601","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-10 19:44:51");
INSERT INTO registro_acesso VALUES("602","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-10 21:25:37");
INSERT INTO registro_acesso VALUES("603","jose44","1","179.127.236.76","Google Chrome","70.0.3538.80","linux","2018-11-10 21:37:53");
INSERT INTO registro_acesso VALUES("604","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-10 21:47:38");
INSERT INTO registro_acesso VALUES("605","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-10 22:07:00");
INSERT INTO registro_acesso VALUES("606","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-10 22:20:31");
INSERT INTO registro_acesso VALUES("607","marcos","1","189.94.112.51","Google Chrome","70.0.3538.80","linux","2018-11-10 22:20:53");
INSERT INTO registro_acesso VALUES("608","salsicha","1","187.73.151.113","Apple Safari","12.0","mac","2018-11-10 22:55:15");
INSERT INTO registro_acesso VALUES("609","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-10 23:22:06");
INSERT INTO registro_acesso VALUES("612","salsicha","1","187.73.151.113","Apple Safari","12.0","mac","2018-11-10 23:28:27");
INSERT INTO registro_acesso VALUES("613","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-10 23:29:16");
INSERT INTO registro_acesso VALUES("614","vando","1","186.215.16.135","Google Chrome","70.0.3538.80","linux","2018-11-11 08:31:08");
INSERT INTO registro_acesso VALUES("615","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 09:00:12");
INSERT INTO registro_acesso VALUES("616","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 09:21:33");
INSERT INTO registro_acesso VALUES("617","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 09:21:42");
INSERT INTO registro_acesso VALUES("618","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 09:27:42");
INSERT INTO registro_acesso VALUES("619","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 09:40:38");
INSERT INTO registro_acesso VALUES("620","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 09:41:33");
INSERT INTO registro_acesso VALUES("621","messias","1","170.78.60.162","Google Chrome","70.0.3538.80","linux","2018-11-11 10:37:01");
INSERT INTO registro_acesso VALUES("622","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-11 11:52:13");
INSERT INTO registro_acesso VALUES("623","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 12:04:53");
INSERT INTO registro_acesso VALUES("624","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-11 12:05:18");
INSERT INTO registro_acesso VALUES("625","alexandre","1","187.111.157.252","Google Chrome","46.0.2490.76","linux","2018-11-11 12:10:55");
INSERT INTO registro_acesso VALUES("626","jose44","1","179.127.239.68","Google Chrome","70.0.3538.80","linux","2018-11-11 12:18:38");
INSERT INTO registro_acesso VALUES("627","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 12:29:15");
INSERT INTO registro_acesso VALUES("628","marcos","1","177.75.57.188","Google Chrome","70.0.3538.80","linux","2018-11-11 12:59:42");
INSERT INTO registro_acesso VALUES("629","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-11 13:28:32");
INSERT INTO registro_acesso VALUES("630","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-11 17:28:39");
INSERT INTO registro_acesso VALUES("631","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 17:35:27");
INSERT INTO registro_acesso VALUES("632","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-11 18:05:31");
INSERT INTO registro_acesso VALUES("633","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 18:11:58");
INSERT INTO registro_acesso VALUES("634","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 19:09:37");
INSERT INTO registro_acesso VALUES("635","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 19:47:09");
INSERT INTO registro_acesso VALUES("637","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-11 19:54:42");
INSERT INTO registro_acesso VALUES("638","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 20:24:45");
INSERT INTO registro_acesso VALUES("639","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-11 21:14:17");
INSERT INTO registro_acesso VALUES("640","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 21:57:50");
INSERT INTO registro_acesso VALUES("641","Admin","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 21:58:27");
INSERT INTO registro_acesso VALUES("642","primo1020","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 21:58:52");
INSERT INTO registro_acesso VALUES("645","primo1020","2","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 22:05:19");
INSERT INTO registro_acesso VALUES("646","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 22:05:25");
INSERT INTO registro_acesso VALUES("647","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-11 22:16:45");
INSERT INTO registro_acesso VALUES("648","vando","1","177.22.178.24","Google Chrome","70.0.3538.77","windows","2018-11-11 22:18:32");
INSERT INTO registro_acesso VALUES("649","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-11 22:20:05");
INSERT INTO registro_acesso VALUES("652","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-11 22:33:51");
INSERT INTO registro_acesso VALUES("653","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-11 22:35:57");
INSERT INTO registro_acesso VALUES("658","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-11 22:51:53");
INSERT INTO registro_acesso VALUES("664","ronaldo","1","186.219.138.13","Google Chrome","70.0.3538.80","linux","2018-11-11 23:30:04");
INSERT INTO registro_acesso VALUES("667","Admin","1","187.73.148.59","Mozilla Firefox","63.0","windows","2018-11-12 00:06:36");
INSERT INTO registro_acesso VALUES("668","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-12 05:55:00");
INSERT INTO registro_acesso VALUES("669","vando","1","177.204.159.110","Google Chrome","70.0.3538.80","linux","2018-11-12 07:16:50");
INSERT INTO registro_acesso VALUES("670","vando","1","177.22.178.2","Google Chrome","70.0.3538.77","windows","2018-11-12 07:20:34");
INSERT INTO registro_acesso VALUES("671","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-12 07:28:15");
INSERT INTO registro_acesso VALUES("672","Admin","1","179.241.213.50","Google Chrome","71.0.3578.45","linux","2018-11-12 08:21:44");
INSERT INTO registro_acesso VALUES("675","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-12 11:30:28");
INSERT INTO registro_acesso VALUES("676","vando","1","177.22.178.2","Google Chrome","70.0.3538.77","windows","2018-11-12 12:41:24");
INSERT INTO registro_acesso VALUES("677","marcos","1","179.241.236.54","Google Chrome","70.0.3538.80","linux","2018-11-12 12:52:58");
INSERT INTO registro_acesso VALUES("678","marcos","1","179.241.236.54","Google Chrome","70.0.3538.80","linux","2018-11-12 12:53:48");
INSERT INTO registro_acesso VALUES("679","marcos","1","179.241.236.54","Google Chrome","70.0.3538.80","linux","2018-11-12 13:03:11");
INSERT INTO registro_acesso VALUES("680","marcos","1","179.241.236.54","Google Chrome","70.0.3538.80","linux","2018-11-12 13:13:32");
INSERT INTO registro_acesso VALUES("681","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-12 13:51:45");
INSERT INTO registro_acesso VALUES("682","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-12 14:04:46");
INSERT INTO registro_acesso VALUES("683","marcos","1","179.241.236.54","Google Chrome","70.0.3538.80","linux","2018-11-12 14:07:00");
INSERT INTO registro_acesso VALUES("684","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-12 14:44:59");
INSERT INTO registro_acesso VALUES("685","vando","1","177.22.178.2","Google Chrome","70.0.3538.77","windows","2018-11-12 15:08:16");
INSERT INTO registro_acesso VALUES("686","biju","1","179.241.210.103","Google Chrome","70.0.3538.80","linux","2018-11-12 16:59:30");
INSERT INTO registro_acesso VALUES("687","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-12 17:13:21");
INSERT INTO registro_acesso VALUES("688","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-12 17:15:14");
INSERT INTO registro_acesso VALUES("689","marcos","1","179.241.253.54","Google Chrome","70.0.3538.80","linux","2018-11-12 18:19:09");
INSERT INTO registro_acesso VALUES("690","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-12 19:08:47");
INSERT INTO registro_acesso VALUES("691","ronaldo","1","186.219.138.43","Google Chrome","57.0.2987.132","linux","2018-11-12 19:58:15");
INSERT INTO registro_acesso VALUES("692","Admin","1","191.246.4.39","Google Chrome","70.0.3538.80","linux","2018-11-12 19:58:32");
INSERT INTO registro_acesso VALUES("693","vando","1","177.22.178.2","Google Chrome","70.0.3538.77","windows","2018-11-12 20:21:07");
INSERT INTO registro_acesso VALUES("694","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-12 20:46:58");
INSERT INTO registro_acesso VALUES("695","marcos","1","179.241.253.54","Google Chrome","70.0.3538.80","linux","2018-11-12 20:47:23");
INSERT INTO registro_acesso VALUES("696","Admin","1","191.246.4.39","Google Chrome","70.0.3538.80","linux","2018-11-12 21:12:10");
INSERT INTO registro_acesso VALUES("697","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-12 21:20:07");
INSERT INTO registro_acesso VALUES("698","vando","1","177.22.178.2","Google Chrome","70.0.3538.77","windows","2018-11-12 21:47:07");
INSERT INTO registro_acesso VALUES("699","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-12 22:33:58");
INSERT INTO registro_acesso VALUES("700","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-12 22:47:31");
INSERT INTO registro_acesso VALUES("701","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-12 22:51:56");
INSERT INTO registro_acesso VALUES("702","vando","1","177.204.159.110","Google Chrome","70.0.3538.80","linux","2018-11-12 23:09:56");
INSERT INTO registro_acesso VALUES("703","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-13 03:27:54");
INSERT INTO registro_acesso VALUES("704","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-13 07:27:33");
INSERT INTO registro_acesso VALUES("705","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-13 07:49:25");
INSERT INTO registro_acesso VALUES("706","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-13 07:59:12");
INSERT INTO registro_acesso VALUES("707","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-13 08:01:39");
INSERT INTO registro_acesso VALUES("708","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-13 08:16:16");
INSERT INTO registro_acesso VALUES("710","alexandre","1","187.26.168.121","Google Chrome","46.0.2490.76","linux","2018-11-13 08:51:55");
INSERT INTO registro_acesso VALUES("711","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-13 09:38:17");
INSERT INTO registro_acesso VALUES("712","messias","1","170.247.114.165","Google Chrome","70.0.3538.77","windows","2018-11-13 10:45:53");
INSERT INTO registro_acesso VALUES("713","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-13 12:39:52");
INSERT INTO registro_acesso VALUES("714","vando","1","177.22.178.2","Google Chrome","70.0.3538.102","windows","2018-11-13 12:40:37");
INSERT INTO registro_acesso VALUES("715","alexandre","1","187.111.159.248","Google Chrome","46.0.2490.76","linux","2018-11-13 12:56:20");
INSERT INTO registro_acesso VALUES("716","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-13 12:56:40");
INSERT INTO registro_acesso VALUES("717","alexandre","1","187.111.159.248","Google Chrome","46.0.2490.76","linux","2018-11-13 12:59:58");
INSERT INTO registro_acesso VALUES("718","alexandre","1","187.111.159.248","Google Chrome","46.0.2490.76","linux","2018-11-13 13:15:24");
INSERT INTO registro_acesso VALUES("719","messias","1","170.78.60.162","Google Chrome","70.0.3538.77","windows","2018-11-13 13:44:00");
INSERT INTO registro_acesso VALUES("720","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-13 15:10:06");
INSERT INTO registro_acesso VALUES("721","vando","1","189.40.71.179","Google Chrome","70.0.3538.80","linux","2018-11-13 15:13:52");
INSERT INTO registro_acesso VALUES("722","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-13 15:16:19");
INSERT INTO registro_acesso VALUES("723","lucy","1","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-13 15:16:27");
INSERT INTO registro_acesso VALUES("724","lucy","2","170.245.219.219","Google Chrome","70.0.3538.77","windows","2018-11-13 15:24:36");
INSERT INTO registro_acesso VALUES("725","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-13 16:10:30");
INSERT INTO registro_acesso VALUES("726","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-13 17:16:02");
INSERT INTO registro_acesso VALUES("727","lucy","1","170.245.219.219","Google Chrome","70.0.3538.102","windows","2018-11-13 17:41:36");
INSERT INTO registro_acesso VALUES("728","lucy","2","170.245.219.219","Google Chrome","70.0.3538.102","windows","2018-11-13 17:52:36");
INSERT INTO registro_acesso VALUES("729","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-13 20:05:03");
INSERT INTO registro_acesso VALUES("730","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-13 20:13:46");
INSERT INTO registro_acesso VALUES("731","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-13 20:18:38");
INSERT INTO registro_acesso VALUES("733","vando","1","177.22.178.2","Google Chrome","70.0.3538.102","windows","2018-11-13 21:15:50");
INSERT INTO registro_acesso VALUES("734","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-13 21:41:09");
INSERT INTO registro_acesso VALUES("735","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-13 21:57:33");
INSERT INTO registro_acesso VALUES("736","vando","1","177.22.178.2","Google Chrome","70.0.3538.102","windows","2018-11-13 23:11:43");
INSERT INTO registro_acesso VALUES("737","messias","1","170.78.60.162","Google Chrome","70.0.3538.80","linux","2018-11-14 00:52:27");
INSERT INTO registro_acesso VALUES("738","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-14 07:41:17");
INSERT INTO registro_acesso VALUES("739","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-14 07:46:22");
INSERT INTO registro_acesso VALUES("740","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-14 08:53:08");
INSERT INTO registro_acesso VALUES("741","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-14 08:53:24");
INSERT INTO registro_acesso VALUES("742","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-14 11:04:39");
INSERT INTO registro_acesso VALUES("743","vando","1","179.187.24.25","Google Chrome","70.0.3538.80","linux","2018-11-14 11:23:08");
INSERT INTO registro_acesso VALUES("744","marcos","1","177.75.57.188","Google Chrome","70.0.3538.80","linux","2018-11-14 13:18:39");
INSERT INTO registro_acesso VALUES("745","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-14 15:27:29");
INSERT INTO registro_acesso VALUES("746","messias","1","170.78.60.207","Google Chrome","70.0.3538.80","linux","2018-11-14 16:49:39");
INSERT INTO registro_acesso VALUES("747","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-14 19:18:33");
INSERT INTO registro_acesso VALUES("748","alessandromp","1","192.12.113.64","Google Chrome","70.0.3538.80","linux","2018-11-14 19:55:29");
INSERT INTO registro_acesso VALUES("749","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-14 21:20:58");
INSERT INTO registro_acesso VALUES("751","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-14 22:02:31");
INSERT INTO registro_acesso VALUES("752","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-14 22:16:03");
INSERT INTO registro_acesso VALUES("753","marcos","1","189.92.205.76","Google Chrome","70.0.3538.80","linux","2018-11-14 22:18:40");
INSERT INTO registro_acesso VALUES("754","vando","1","177.22.178.2","Google Chrome","70.0.3538.102","windows","2018-11-14 22:42:21");
INSERT INTO registro_acesso VALUES("755","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-14 23:05:08");
INSERT INTO registro_acesso VALUES("756","jose44","1","177.220.166.186","Google Chrome","70.0.3538.80","linux","2018-11-14 23:15:45");
INSERT INTO registro_acesso VALUES("757","messias","1","170.78.60.162","Google Chrome","70.0.3538.102","windows","2018-11-14 23:47:48");
INSERT INTO registro_acesso VALUES("758","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-15 08:41:47");
INSERT INTO registro_acesso VALUES("759","messias","1","170.78.60.162","Google Chrome","70.0.3538.102","windows","2018-11-15 08:53:27");
INSERT INTO registro_acesso VALUES("760","vando","1","177.22.178.2","Google Chrome","70.0.3538.102","windows","2018-11-15 12:41:12");
INSERT INTO registro_acesso VALUES("761","Admin","1","187.73.148.59","Google Chrome","70.0.3538.77","windows","2018-11-15 13:39:31");
INSERT INTO registro_acesso VALUES("762","messias","1","170.78.60.162","Google Chrome","70.0.3538.102","windows","2018-11-15 13:44:03");
INSERT INTO registro_acesso VALUES("763","jose44","1","179.127.237.67","Google Chrome","70.0.3538.80","linux","2018-11-15 15:23:33");
INSERT INTO registro_acesso VALUES("764","jose44","1","179.127.237.67","Google Chrome","70.0.3538.80","linux","2018-11-15 15:28:22");
INSERT INTO registro_acesso VALUES("766","marcos","1","187.26.196.89","Google Chrome","70.0.3538.80","linux","2018-11-15 18:15:26");
INSERT INTO registro_acesso VALUES("767","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-15 21:29:14");
INSERT INTO registro_acesso VALUES("768","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-15 22:02:41");
INSERT INTO registro_acesso VALUES("769","anderson81","1","186.208.74.198","Google Chrome","70.0.3538.80","linux","2018-11-15 22:05:16");
INSERT INTO registro_acesso VALUES("770","messias","1","170.78.62.98","Google Chrome","70.0.3538.80","linux","2018-11-16 06:40:03");
INSERT INTO registro_acesso VALUES("771","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-16 07:37:10");
INSERT INTO registro_acesso VALUES("772","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-16 09:49:39");
INSERT INTO registro_acesso VALUES("773","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-16 12:14:40");
INSERT INTO registro_acesso VALUES("774","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-16 13:25:38");
INSERT INTO registro_acesso VALUES("775","messias","1","170.78.62.98","Google Chrome","70.0.3538.80","linux","2018-11-16 17:37:00");
INSERT INTO registro_acesso VALUES("776","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-16 18:31:48");
INSERT INTO registro_acesso VALUES("777","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-16 19:38:08");
INSERT INTO registro_acesso VALUES("778","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-16 20:22:12");
INSERT INTO registro_acesso VALUES("779","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-16 21:30:06");
INSERT INTO registro_acesso VALUES("780","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-16 21:43:22");
INSERT INTO registro_acesso VALUES("781","alexandre","1","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-16 22:11:21");
INSERT INTO registro_acesso VALUES("782","alexandre","2","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-16 22:13:14");
INSERT INTO registro_acesso VALUES("783","marco17","1","131.255.69.1","Google Chrome","70.0.3538.80","linux","2018-11-16 22:54:30");
INSERT INTO registro_acesso VALUES("784","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-16 23:20:58");
INSERT INTO registro_acesso VALUES("785","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-17 01:51:22");
INSERT INTO registro_acesso VALUES("786","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-17 08:11:02");
INSERT INTO registro_acesso VALUES("787","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-17 08:38:36");
INSERT INTO registro_acesso VALUES("788","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-11-17 09:09:27");
INSERT INTO registro_acesso VALUES("789","Admin","1","187.73.148.59","Google Chrome","70.0.3538.102","windows","2018-11-17 10:24:37");
INSERT INTO registro_acesso VALUES("790","anderson81","1","177.87.2.140","Google Chrome","70.0.3538.80","linux","2018-11-17 11:26:18");
INSERT INTO registro_acesso VALUES("791","messias","1","170.78.62.98","Google Chrome","70.0.3538.80","linux","2018-11-17 14:22:37");
INSERT INTO registro_acesso VALUES("792","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-17 14:49:23");
INSERT INTO registro_acesso VALUES("793","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-17 15:08:22");
INSERT INTO registro_acesso VALUES("794","Admin","1","179.241.197.53","Google Chrome","70.0.3538.80","linux","2018-11-17 15:44:43");
INSERT INTO registro_acesso VALUES("795","Admin","1","177.58.177.86","Google Chrome","70.0.3538.80","linux","2018-11-17 18:05:59");
INSERT INTO registro_acesso VALUES("796","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-17 19:29:17");
INSERT INTO registro_acesso VALUES("797","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-17 19:29:32");
INSERT INTO registro_acesso VALUES("798","messias","1","170.78.62.102","Google Chrome","70.0.3538.102","windows","2018-11-17 20:42:33");
INSERT INTO registro_acesso VALUES("799","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-17 20:47:28");
INSERT INTO registro_acesso VALUES("800","lucy","1","177.125.36.136","Google Chrome","70.0.3538.102","windows","2018-11-17 21:48:23");
INSERT INTO registro_acesso VALUES("801","lucy","2","177.125.36.136","Google Chrome","70.0.3538.102","windows","2018-11-17 21:49:16");
INSERT INTO registro_acesso VALUES("802","messias","1","170.78.62.102","Google Chrome","70.0.3538.102","windows","2018-11-17 22:14:13");
INSERT INTO registro_acesso VALUES("803","ronaldo","1","186.219.138.12","Google Chrome","70.0.3538.80","linux","2018-11-18 00:04:53");
INSERT INTO registro_acesso VALUES("804","ronaldo","1","186.219.138.12","Google Chrome","70.0.3538.80","linux","2018-11-18 00:13:24");
INSERT INTO registro_acesso VALUES("805","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-18 07:59:55");
INSERT INTO registro_acesso VALUES("806","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-18 08:36:31");
INSERT INTO registro_acesso VALUES("807","messias","1","170.78.62.102","Google Chrome","70.0.3538.80","linux","2018-11-18 08:39:55");
INSERT INTO registro_acesso VALUES("808","messias","1","170.78.62.102","Google Chrome","70.0.3538.80","linux","2018-11-18 08:59:35");
INSERT INTO registro_acesso VALUES("809","vando","1","177.204.77.118","Google Chrome","70.0.3538.80","linux","2018-11-18 09:24:28");
INSERT INTO registro_acesso VALUES("810","vando","1","177.204.77.118","Google Chrome","70.0.3538.80","linux","2018-11-18 09:24:30");
INSERT INTO registro_acesso VALUES("811","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-18 09:31:22");
INSERT INTO registro_acesso VALUES("812","messias","1","170.78.62.102","Google Chrome","4.0","linux","2018-11-18 09:33:46");
INSERT INTO registro_acesso VALUES("813","messias","1","170.78.62.102","Google Chrome","70.0.3538.80","linux","2018-11-18 11:04:03");
INSERT INTO registro_acesso VALUES("814","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-18 11:57:50");
INSERT INTO registro_acesso VALUES("815","messias","1","170.78.62.102","Google Chrome","70.0.3538.80","linux","2018-11-18 12:11:07");
INSERT INTO registro_acesso VALUES("817","marcos","1","177.75.57.188","Google Chrome","70.0.3538.80","linux","2018-11-18 12:21:59");
INSERT INTO registro_acesso VALUES("818","marcos","1","177.75.57.188","Google Chrome","70.0.3538.80","linux","2018-11-18 12:22:35");
INSERT INTO registro_acesso VALUES("821","alexandre","1","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-18 13:39:42");
INSERT INTO registro_acesso VALUES("822","messias","1","170.78.62.102","Google Chrome","70.0.3538.80","linux","2018-11-18 14:18:51");
INSERT INTO registro_acesso VALUES("823","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-18 14:19:12");
INSERT INTO registro_acesso VALUES("824","jose44","1","179.127.239.36","Google Chrome","70.0.3538.80","linux","2018-11-18 15:33:45");
INSERT INTO registro_acesso VALUES("825","biju","1","177.58.231.69","Google Chrome","70.0.3538.80","linux","2018-11-18 16:00:28");
INSERT INTO registro_acesso VALUES("826","biju","1","177.58.231.69","Google Chrome","70.0.3538.80","linux","2018-11-18 18:57:55");
INSERT INTO registro_acesso VALUES("827","anderson81","1","189.40.101.61","Google Chrome","70.0.3538.80","linux","2018-11-18 19:49:18");
INSERT INTO registro_acesso VALUES("828","jose44","1","179.127.239.36","Google Chrome","70.0.3538.80","linux","2018-11-18 20:31:56");
INSERT INTO registro_acesso VALUES("829","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-18 20:38:13");
INSERT INTO registro_acesso VALUES("830","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-18 21:17:18");
INSERT INTO registro_acesso VALUES("831","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-18 21:43:19");
INSERT INTO registro_acesso VALUES("832","messias","1","170.78.62.102","Google Chrome","70.0.3538.80","linux","2018-11-18 22:52:26");
INSERT INTO registro_acesso VALUES("833","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-19 07:56:44");
INSERT INTO registro_acesso VALUES("834","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-19 08:42:36");
INSERT INTO registro_acesso VALUES("835","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-19 09:21:12");
INSERT INTO registro_acesso VALUES("836","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-19 09:23:35");
INSERT INTO registro_acesso VALUES("837","biju","1","187.26.136.77","Google Chrome","70.0.3538.80","linux","2018-11-19 09:59:36");
INSERT INTO registro_acesso VALUES("838","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-19 12:33:12");
INSERT INTO registro_acesso VALUES("839","marcos","1","189.94.181.42","Google Chrome","70.0.3538.80","linux","2018-11-19 13:01:12");
INSERT INTO registro_acesso VALUES("840","messias","1","189.40.95.150","Google Chrome","70.0.3538.80","linux","2018-11-19 15:35:40");
INSERT INTO registro_acesso VALUES("841","messias","1","189.40.95.46","Google Chrome","70.0.3538.80","linux","2018-11-19 16:28:30");
INSERT INTO registro_acesso VALUES("842","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-19 18:41:20");
INSERT INTO registro_acesso VALUES("843","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-19 18:42:05");
INSERT INTO registro_acesso VALUES("844","jose44","1","179.127.239.243","Google Chrome","70.0.3538.80","linux","2018-11-19 19:12:29");
INSERT INTO registro_acesso VALUES("845","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-19 20:46:11");
INSERT INTO registro_acesso VALUES("846","vando","1","177.22.178.0","Google Chrome","70.0.3538.102","windows","2018-11-19 21:50:15");
INSERT INTO registro_acesso VALUES("847","messias","1","170.78.62.102","Google Chrome","70.0.3538.102","windows","2018-11-19 22:23:33");
INSERT INTO registro_acesso VALUES("849","messias","1","189.40.94.234","Google Chrome","70.0.3538.80","linux","2018-11-20 10:00:09");
INSERT INTO registro_acesso VALUES("850","marcos","1","179.242.58.58","Google Chrome","70.0.3538.80","linux","2018-11-20 10:16:12");
INSERT INTO registro_acesso VALUES("851","vando","1","189.40.65.210","Google Chrome","70.0.3538.80","linux","2018-11-20 11:27:46");
INSERT INTO registro_acesso VALUES("852","marcos","1","179.242.58.58","Google Chrome","70.0.3538.80","linux","2018-11-20 12:26:10");
INSERT INTO registro_acesso VALUES("853","Admin","1","187.26.70.100","Google Chrome","70.0.3538.80","linux","2018-11-20 14:09:52");
INSERT INTO registro_acesso VALUES("854","marcos","1","179.242.58.58","Google Chrome","70.0.3538.80","linux","2018-11-20 15:18:44");
INSERT INTO registro_acesso VALUES("855","marcos","1","179.242.58.58","Google Chrome","70.0.3538.80","linux","2018-11-20 15:19:02");
INSERT INTO registro_acesso VALUES("856","marcos","1","179.242.58.58","Google Chrome","70.0.3538.80","linux","2018-11-20 15:19:17");
INSERT INTO registro_acesso VALUES("857","messias","1","170.78.60.206","Google Chrome","70.0.3538.80","linux","2018-11-20 17:32:49");
INSERT INTO registro_acesso VALUES("858","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-20 18:16:16");
INSERT INTO registro_acesso VALUES("859","Admin","1","187.26.71.93","Google Chrome","70.0.3538.80","linux","2018-11-20 18:26:40");
INSERT INTO registro_acesso VALUES("860","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-20 19:19:05");
INSERT INTO registro_acesso VALUES("861","Admin","1","187.26.71.93","Google Chrome","70.0.3538.80","linux","2018-11-20 19:43:16");
INSERT INTO registro_acesso VALUES("862","messias","1","189.40.93.162","Google Chrome","70.0.3538.80","linux","2018-11-20 21:19:57");
INSERT INTO registro_acesso VALUES("863","Admin","1","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-20 21:32:40");
INSERT INTO registro_acesso VALUES("864","Admin","2","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-20 21:53:55");
INSERT INTO registro_acesso VALUES("865","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-20 22:25:50");
INSERT INTO registro_acesso VALUES("866","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-20 22:44:09");
INSERT INTO registro_acesso VALUES("867","lucy","1","191.39.2.134","Google Chrome","70.0.3538.80","linux","2018-11-20 23:25:18");
INSERT INTO registro_acesso VALUES("868","lucy","2","66.249.85.52","Google Chrome","70.0.3538.80","linux","2018-11-20 23:38:27");
INSERT INTO registro_acesso VALUES("869","messias","1","170.78.62.98","Google Chrome","70.0.3538.80","linux","2018-11-21 07:59:29");
INSERT INTO registro_acesso VALUES("870","marco17","1","131.255.69.1","Google Chrome","70.0.3538.80","linux","2018-11-21 08:24:09");
INSERT INTO registro_acesso VALUES("871","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-21 09:02:34");
INSERT INTO registro_acesso VALUES("872","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-21 09:32:35");
INSERT INTO registro_acesso VALUES("873","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-21 09:40:02");
INSERT INTO registro_acesso VALUES("874","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-21 10:17:13");
INSERT INTO registro_acesso VALUES("875","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-21 12:57:07");
INSERT INTO registro_acesso VALUES("876","alexandre","1","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 13:50:32");
INSERT INTO registro_acesso VALUES("877","alexandre","2","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 13:51:42");
INSERT INTO registro_acesso VALUES("880","alexandre","1","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 13:52:34");
INSERT INTO registro_acesso VALUES("881","alexandre","2","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 13:57:05");
INSERT INTO registro_acesso VALUES("882","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-21 14:58:17");
INSERT INTO registro_acesso VALUES("883","marcos","1","189.94.173.101","Google Chrome","70.0.3538.80","linux","2018-11-21 15:36:40");
INSERT INTO registro_acesso VALUES("885","lucy","1","191.39.13.48","Google Chrome","70.0.3538.80","linux","2018-11-21 15:58:22");
INSERT INTO registro_acesso VALUES("886","lucy","2","66.249.85.52","Google Chrome","70.0.3538.80","linux","2018-11-21 16:04:43");
INSERT INTO registro_acesso VALUES("887","Admin","1","187.26.150.241","Google Chrome","70.0.3538.80","linux","2018-11-21 16:23:08");
INSERT INTO registro_acesso VALUES("888","marcos","1","189.94.173.101","Google Chrome","70.0.3538.80","linux","2018-11-21 16:47:38");
INSERT INTO registro_acesso VALUES("889","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-21 16:49:30");
INSERT INTO registro_acesso VALUES("890","marcos","1","189.94.173.101","Google Chrome","70.0.3538.80","linux","2018-11-21 16:50:28");
INSERT INTO registro_acesso VALUES("891","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 16:55:26");
INSERT INTO registro_acesso VALUES("892","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 16:57:08");
INSERT INTO registro_acesso VALUES("893","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 16:58:13");
INSERT INTO registro_acesso VALUES("894","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 16:58:20");
INSERT INTO registro_acesso VALUES("895","Admin","1","187.73.148.59","Google Chrome","70.0.3538.102","windows","2018-11-21 17:00:12");
INSERT INTO registro_acesso VALUES("896","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-21 17:01:03");
INSERT INTO registro_acesso VALUES("897","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 17:01:06");
INSERT INTO registro_acesso VALUES("898","vando","1","177.22.178.11","Google Chrome","70.0.3538.80","linux","2018-11-21 17:03:52");
INSERT INTO registro_acesso VALUES("899","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 17:08:59");
INSERT INTO registro_acesso VALUES("900","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 17:22:36");
INSERT INTO registro_acesso VALUES("901","Admin","1","188.166.234.249","Google Chrome","70.0.3538.102","windows","2018-11-21 17:30:06");
INSERT INTO registro_acesso VALUES("902","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-21 17:32:10");
INSERT INTO registro_acesso VALUES("903","jose44","1","179.127.238.99","Google Chrome","70.0.3538.80","linux","2018-11-21 17:34:57");
INSERT INTO registro_acesso VALUES("904","lucy","1","191.39.13.48","Google Chrome","70.0.3538.80","linux","2018-11-21 17:51:30");
INSERT INTO registro_acesso VALUES("905","Admin","1","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-21 18:24:00");
INSERT INTO registro_acesso VALUES("906","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-21 18:40:10");
INSERT INTO registro_acesso VALUES("907","alexandre","1","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 18:44:53");
INSERT INTO registro_acesso VALUES("908","alexandre","2","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 18:47:10");
INSERT INTO registro_acesso VALUES("909","alexandre","1","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 18:49:18");
INSERT INTO registro_acesso VALUES("910","alexandre","2","167.250.91.233","Google Chrome","70.0.3538.102","windows","2018-11-21 18:49:55");
INSERT INTO registro_acesso VALUES("911","Admin","1","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-21 19:10:32");
INSERT INTO registro_acesso VALUES("912","Admin","2","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-21 19:21:04");
INSERT INTO registro_acesso VALUES("914","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-21 20:23:39");
INSERT INTO registro_acesso VALUES("915","Admin","1","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-21 20:43:35");
INSERT INTO registro_acesso VALUES("916","Admin","2","45.63.115.19","Google Chrome","70.0.3538.102","windows","2018-11-21 20:46:46");
INSERT INTO registro_acesso VALUES("917","ronaldo","1","186.219.138.37","Google Chrome","70.0.3538.80","linux","2018-11-21 21:11:02");
INSERT INTO registro_acesso VALUES("918","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-21 21:15:27");
INSERT INTO registro_acesso VALUES("919","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-21 21:21:05");
INSERT INTO registro_acesso VALUES("920","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-21 21:38:33");
INSERT INTO registro_acesso VALUES("921","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-21 23:11:46");
INSERT INTO registro_acesso VALUES("922","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-21 23:14:57");
INSERT INTO registro_acesso VALUES("923","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-21 23:16:25");
INSERT INTO registro_acesso VALUES("924","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-21 23:26:00");
INSERT INTO registro_acesso VALUES("925","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-22 00:05:17");
INSERT INTO registro_acesso VALUES("926","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-22 07:04:12");
INSERT INTO registro_acesso VALUES("927","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-22 07:18:11");
INSERT INTO registro_acesso VALUES("928","vando","2","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-22 07:49:43");
INSERT INTO registro_acesso VALUES("929","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-22 07:49:45");
INSERT INTO registro_acesso VALUES("930","vando","1","177.22.178.11","Google Chrome","70.0.3538.80","linux","2018-11-22 07:50:25");
INSERT INTO registro_acesso VALUES("931","messias","2","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-22 07:51:54");
INSERT INTO registro_acesso VALUES("932","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-22 07:52:06");
INSERT INTO registro_acesso VALUES("933","lucy","1","191.39.38.68","Google Chrome","70.0.3538.80","linux","2018-11-22 10:48:27");
INSERT INTO registro_acesso VALUES("934","lucy","2","66.249.85.52","Google Chrome","70.0.3538.80","linux","2018-11-22 11:00:39");
INSERT INTO registro_acesso VALUES("935","anderson81","1","177.87.2.147","Google Chrome","70.0.3538.80","linux","2018-11-22 11:41:31");
INSERT INTO registro_acesso VALUES("936","marcos","1","189.92.232.34","Google Chrome","70.0.3538.80","linux","2018-11-22 13:05:41");
INSERT INTO registro_acesso VALUES("937","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-22 13:14:08");
INSERT INTO registro_acesso VALUES("938","marcos","1","189.92.232.34","Google Chrome","70.0.3538.80","linux","2018-11-22 13:18:11");
INSERT INTO registro_acesso VALUES("939","marco17","1","131.255.69.1","Google Chrome","70.0.3538.80","linux","2018-11-22 15:19:06");
INSERT INTO registro_acesso VALUES("940","Admin","1","179.241.221.45","Google Chrome","70.0.3538.80","linux","2018-11-22 15:25:03");
INSERT INTO registro_acesso VALUES("941","marco17","1","189.92.100.1","Google Chrome","70.0.3538.80","linux","2018-11-22 15:55:07");
INSERT INTO registro_acesso VALUES("942","messias","1","170.78.62.98","Google Chrome","70.0.3538.102","windows","2018-11-22 16:23:51");
INSERT INTO registro_acesso VALUES("943","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-22 19:48:57");
INSERT INTO registro_acesso VALUES("944","Admin","1","187.26.150.241","Google Chrome","70.0.3538.80","linux","2018-11-22 20:14:56");
INSERT INTO registro_acesso VALUES("945","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-22 21:14:45");
INSERT INTO registro_acesso VALUES("946","Admin","1","187.73.148.59","Google Chrome","70.0.3538.102","windows","2018-11-22 22:38:04");
INSERT INTO registro_acesso VALUES("947","Admin","2","187.73.148.59","Google Chrome","70.0.3538.102","windows","2018-11-22 22:46:24");
INSERT INTO registro_acesso VALUES("948","messias","1","170.78.62.99","Google Chrome","70.0.3538.102","windows","2018-11-22 23:30:38");
INSERT INTO registro_acesso VALUES("949","marcos","1","177.75.57.180","Google Chrome","70.0.3538.80","linux","2018-11-23 07:32:16");
INSERT INTO registro_acesso VALUES("950","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-23 09:18:35");
INSERT INTO registro_acesso VALUES("951","Admin","2","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-23 09:19:30");
INSERT INTO registro_acesso VALUES("952","marco17","1","168.205.42.245","Google Chrome","70.0.3538.80","linux","2018-11-23 09:34:55");
INSERT INTO registro_acesso VALUES("953","marcos","1","200.163.84.89","Google Chrome","70.0.3538.80","linux","2018-11-23 12:10:55");
INSERT INTO registro_acesso VALUES("954","marcos","1","200.163.84.89","Google Chrome","70.0.3538.80","linux","2018-11-23 12:11:25");
INSERT INTO registro_acesso VALUES("955","marcos","1","200.163.84.89","Google Chrome","70.0.3538.80","linux","2018-11-23 12:11:39");
INSERT INTO registro_acesso VALUES("956","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-23 13:59:22");
INSERT INTO registro_acesso VALUES("957","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-23 15:33:57");
INSERT INTO registro_acesso VALUES("958","marco17","1","187.26.133.103","Google Chrome","70.0.3538.80","linux","2018-11-23 16:12:55");
INSERT INTO registro_acesso VALUES("959","vando","1","189.58.236.122","Google Chrome","70.0.3538.102","windows","2018-11-23 18:24:09");
INSERT INTO registro_acesso VALUES("960","messias","1","170.78.62.99","Google Chrome","70.0.3538.102","windows","2018-11-23 18:25:23");
INSERT INTO registro_acesso VALUES("961","lucy","1","177.125.36.59","Google Chrome","70.0.3538.80","linux","2018-11-23 20:08:29");
INSERT INTO registro_acesso VALUES("962","Admin","1","187.73.148.59","Google Chrome","70.0.3538.102","windows","2018-11-23 20:09:15");
INSERT INTO registro_acesso VALUES("963","lucy","2","191.39.76.57","Google Chrome","70.0.3538.80","linux","2018-11-23 20:19:13");
INSERT INTO registro_acesso VALUES("964","messias","1","170.78.62.99","Google Chrome","70.0.3538.102","windows","2018-11-23 21:36:35");
INSERT INTO registro_acesso VALUES("965","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-23 22:59:51");
INSERT INTO registro_acesso VALUES("966","marcos","1","189.94.118.42","Google Chrome","70.0.3538.80","linux","2018-11-24 09:58:37");
INSERT INTO registro_acesso VALUES("967","marcos","1","177.75.57.188","Google Chrome","70.0.3538.80","linux","2018-11-24 13:11:50");
INSERT INTO registro_acesso VALUES("968","jose44","1","179.127.238.246","Google Chrome","70.0.3538.80","linux","2018-11-24 14:26:33");
INSERT INTO registro_acesso VALUES("969","marcos","1","189.94.118.42","Google Chrome","70.0.3538.80","linux","2018-11-24 14:47:50");
INSERT INTO registro_acesso VALUES("970","marcos","1","189.94.118.42","Google Chrome","70.0.3538.80","linux","2018-11-24 14:49:41");
INSERT INTO registro_acesso VALUES("971","marco17","1","191.5.102.226","Google Chrome","70.0.3538.80","linux","2018-11-24 17:44:36");
INSERT INTO registro_acesso VALUES("972","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-24 18:03:52");
INSERT INTO registro_acesso VALUES("973","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-24 18:19:52");
INSERT INTO registro_acesso VALUES("974","marco17","1","191.5.102.226","Google Chrome","70.0.3538.80","linux","2018-11-24 18:57:01");
INSERT INTO registro_acesso VALUES("975","lucy","1","191.39.5.87","Google Chrome","70.0.3538.80","linux","2018-11-24 20:20:47");
INSERT INTO registro_acesso VALUES("976","lucy","2","66.249.85.52","Google Chrome","70.0.3538.80","linux","2018-11-24 20:25:07");
INSERT INTO registro_acesso VALUES("977","messias","1","170.247.114.165","Google Chrome","70.0.3538.102","windows","2018-11-24 23:14:57");
INSERT INTO registro_acesso VALUES("978","Admin","1","187.73.148.59","Google Chrome","70.0.3538.102","windows","2018-11-25 00:28:32");
INSERT INTO registro_acesso VALUES("979","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-25 10:49:20");
INSERT INTO registro_acesso VALUES("980","vando","1","201.22.229.212","Google Chrome","70.0.3538.102","windows","2018-11-25 11:38:44");
INSERT INTO registro_acesso VALUES("981","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-25 11:58:57");
INSERT INTO registro_acesso VALUES("982","messias","1","170.247.114.165","Google Chrome","70.0.3538.102","windows","2018-11-25 13:36:01");
INSERT INTO registro_acesso VALUES("983","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-25 15:45:18");
INSERT INTO registro_acesso VALUES("984","marco17","1","177.58.182.21","Google Chrome","70.0.3538.80","linux","2018-11-25 17:52:34");
INSERT INTO registro_acesso VALUES("985","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-25 19:24:34");
INSERT INTO registro_acesso VALUES("986","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-25 21:00:17");
INSERT INTO registro_acesso VALUES("987","jose44","1","179.127.239.55","Google Chrome","70.0.3538.80","linux","2018-11-25 22:44:16");
INSERT INTO registro_acesso VALUES("988","marco17","1","191.5.102.226","Google Chrome","70.0.3538.80","linux","2018-11-25 22:57:21");
INSERT INTO registro_acesso VALUES("989","vando","1","177.22.178.11","Google Chrome","70.0.3538.80","linux","2018-11-26 07:01:27");
INSERT INTO registro_acesso VALUES("990","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-26 08:42:23");
INSERT INTO registro_acesso VALUES("991","messias","1","170.247.114.165","Google Chrome","70.0.3538.102","windows","2018-11-26 09:09:55");
INSERT INTO registro_acesso VALUES("992","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-26 09:46:38");
INSERT INTO registro_acesso VALUES("993","marcos","1","201.87.244.10","Google Chrome","70.0.3538.80","linux","2018-11-26 09:51:06");
INSERT INTO registro_acesso VALUES("994","marcos","1","189.92.255.94","Google Chrome","70.0.3538.80","linux","2018-11-26 10:30:15");
INSERT INTO registro_acesso VALUES("995","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-26 11:12:03");
INSERT INTO registro_acesso VALUES("996","vando","1","179.177.209.228","Google Chrome","70.0.3538.102","windows","2018-11-26 12:11:08");
INSERT INTO registro_acesso VALUES("997","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-26 12:40:54");
INSERT INTO registro_acesso VALUES("998","vando","1","187.111.157.236","Google Chrome","70.0.3538.80","linux","2018-11-26 13:30:11");
INSERT INTO registro_acesso VALUES("999","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-26 13:49:54");
INSERT INTO registro_acesso VALUES("1000","marco17","1","187.26.66.58","Google Chrome","70.0.3538.80","linux","2018-11-26 15:07:03");
INSERT INTO registro_acesso VALUES("1001","marco17","1","187.26.66.58","Google Chrome","70.0.3538.80","linux","2018-11-26 15:27:39");
INSERT INTO registro_acesso VALUES("1002","alexandre","1","191.246.0.23","Google Chrome","46.0.2490.76","linux","2018-11-26 17:15:39");
INSERT INTO registro_acesso VALUES("1003","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:30:06");
INSERT INTO registro_acesso VALUES("1004","Admin","1","187.73.148.59","Google Chrome","70.0.3538.80","linux","2018-11-26 18:32:54");
INSERT INTO registro_acesso VALUES("1005","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:35:59");
INSERT INTO registro_acesso VALUES("1006","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:41:43");
INSERT INTO registro_acesso VALUES("1007","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:49:09");
INSERT INTO registro_acesso VALUES("1008","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:55:38");
INSERT INTO registro_acesso VALUES("1009","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:57:38");
INSERT INTO registro_acesso VALUES("1010","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-26 18:59:28");
INSERT INTO registro_acesso VALUES("1011","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-26 20:32:30");
INSERT INTO registro_acesso VALUES("1012","messias","1","170.247.114.165","Google Chrome","70.0.3538.110","windows","2018-11-27 09:23:05");
INSERT INTO registro_acesso VALUES("1013","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-27 09:55:19");
INSERT INTO registro_acesso VALUES("1014","vando","1","189.40.68.14","Google Chrome","70.0.3538.80","linux","2018-11-27 10:06:34");
INSERT INTO registro_acesso VALUES("1015","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-27 10:09:24");
INSERT INTO registro_acesso VALUES("1016","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-27 10:09:29");
INSERT INTO registro_acesso VALUES("1017","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-27 10:12:25");
INSERT INTO registro_acesso VALUES("1018","messias","1","170.247.114.165","Google Chrome","70.0.3538.80","linux","2018-11-27 10:49:02");
INSERT INTO registro_acesso VALUES("1019","marcos","1","179.241.248.5","Google Chrome","70.0.3538.80","linux","2018-11-27 10:59:36");
INSERT INTO registro_acesso VALUES("1020","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-11-27 12:46:42");
INSERT INTO registro_acesso VALUES("1021","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-27 12:57:33");
INSERT INTO registro_acesso VALUES("1022","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-27 12:59:33");
INSERT INTO registro_acesso VALUES("1023","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-27 13:16:10");
INSERT INTO registro_acesso VALUES("1024","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-27 15:30:22");
INSERT INTO registro_acesso VALUES("1025","marcos","1","179.241.248.42","Google Chrome","70.0.3538.110","linux","2018-11-27 17:13:00");
INSERT INTO registro_acesso VALUES("1026","marcos","1","179.241.248.42","Google Chrome","70.0.3538.110","linux","2018-11-27 17:13:29");
INSERT INTO registro_acesso VALUES("1027","marcos","1","179.241.248.42","Google Chrome","70.0.3538.110","linux","2018-11-27 17:29:42");
INSERT INTO registro_acesso VALUES("1028","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-27 17:31:14");
INSERT INTO registro_acesso VALUES("1029","marco17","1","131.255.69.1","Google Chrome","70.0.3538.80","linux","2018-11-27 17:55:36");
INSERT INTO registro_acesso VALUES("1030","marcos","1","177.75.57.188","Google Chrome","70.0.3538.110","linux","2018-11-27 18:59:11");
INSERT INTO registro_acesso VALUES("1031","lucy","1","177.125.36.181","Google Chrome","70.0.3538.110","linux","2018-11-27 19:19:54");
INSERT INTO registro_acesso VALUES("1032","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-27 19:25:09");
INSERT INTO registro_acesso VALUES("1033","lucy","1","177.125.36.181","Google Chrome","70.0.3538.102","windows","2018-11-27 21:25:33");
INSERT INTO registro_acesso VALUES("1034","vando","1","177.22.178.11","Google Chrome","70.0.3538.102","windows","2018-11-27 21:26:10");
INSERT INTO registro_acesso VALUES("1035","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.80","linux","2018-11-27 21:52:43");
INSERT INTO registro_acesso VALUES("1036","biju","1","179.241.199.51","Google Chrome","70.0.3538.80","linux","2018-11-27 22:31:37");
INSERT INTO registro_acesso VALUES("1037","messias","1","170.78.62.99","Google Chrome","70.0.3538.80","linux","2018-11-28 07:52:46");
INSERT INTO registro_acesso VALUES("1038","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-28 08:06:44");
INSERT INTO registro_acesso VALUES("1039","alexandre","1","200.34.161.234","Google Chrome","70.0.3538.110","windows","2018-11-28 10:35:37");
INSERT INTO registro_acesso VALUES("1040","marco17","1","131.255.69.1","Google Chrome","44.0.2403.133","linux","2018-11-28 12:55:21");
INSERT INTO registro_acesso VALUES("1041","lucy","1","177.125.36.193","Google Chrome","70.0.3538.110","windows","2018-11-28 13:27:17");
INSERT INTO registro_acesso VALUES("1042","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-28 13:33:22");
INSERT INTO registro_acesso VALUES("1043","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-28 13:53:23");
INSERT INTO registro_acesso VALUES("1044","lucy","2","177.125.36.193","Google Chrome","70.0.3538.110","windows","2018-11-28 14:11:14");
INSERT INTO registro_acesso VALUES("1045","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-11-28 17:01:39");
INSERT INTO registro_acesso VALUES("1046","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-11-28 19:00:57");
INSERT INTO registro_acesso VALUES("1047","lucy","1","177.125.36.193","Google Chrome","70.0.3538.110","windows","2018-11-28 19:22:35");
INSERT INTO registro_acesso VALUES("1048","lucy","2","177.125.36.193","Google Chrome","70.0.3538.110","windows","2018-11-28 19:27:47");
INSERT INTO registro_acesso VALUES("1049","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-28 20:44:53");
INSERT INTO registro_acesso VALUES("1050","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-28 21:10:54");
INSERT INTO registro_acesso VALUES("1051","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-28 22:56:41");
INSERT INTO registro_acesso VALUES("1052","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-29 09:04:45");
INSERT INTO registro_acesso VALUES("1053","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-29 11:04:35");
INSERT INTO registro_acesso VALUES("1054","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-29 12:24:56");
INSERT INTO registro_acesso VALUES("1055","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-29 12:57:38");
INSERT INTO registro_acesso VALUES("1056","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-29 12:58:44");
INSERT INTO registro_acesso VALUES("1057","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-11-29 14:14:50");
INSERT INTO registro_acesso VALUES("1058","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-11-29 15:03:27");
INSERT INTO registro_acesso VALUES("1059","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-11-29 15:04:14");
INSERT INTO registro_acesso VALUES("1060","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-11-29 15:06:46");
INSERT INTO registro_acesso VALUES("1061","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-11-29 20:00:33");
INSERT INTO registro_acesso VALUES("1062","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-29 20:01:40");
INSERT INTO registro_acesso VALUES("1063","alexandre","1","200.34.161.234","Google Chrome","46.0.2490.76","linux","2018-11-29 20:32:15");
INSERT INTO registro_acesso VALUES("1064","alexandre","2","200.34.161.234","Google Chrome","46.0.2490.76","linux","2018-11-29 20:33:22");
INSERT INTO registro_acesso VALUES("1065","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-30 08:13:37");
INSERT INTO registro_acesso VALUES("1066","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-30 09:33:54");
INSERT INTO registro_acesso VALUES("1067","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-11-30 09:34:35");
INSERT INTO registro_acesso VALUES("1068","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-11-30 09:36:12");
INSERT INTO registro_acesso VALUES("1069","marcos","1","179.241.251.84","Google Chrome","70.0.3538.110","linux","2018-11-30 12:03:38");
INSERT INTO registro_acesso VALUES("1070","lucy","1","177.125.36.8","Google Chrome","70.0.3538.110","windows","2018-11-30 12:04:41");
INSERT INTO registro_acesso VALUES("1071","lucy","2","177.125.36.8","Google Chrome","70.0.3538.110","windows","2018-11-30 12:05:36");
INSERT INTO registro_acesso VALUES("1072","marcos","1","179.241.251.84","Google Chrome","70.0.3538.110","linux","2018-11-30 12:23:49");
INSERT INTO registro_acesso VALUES("1073","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-11-30 13:27:15");
INSERT INTO registro_acesso VALUES("1074","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-11-30 14:09:46");
INSERT INTO registro_acesso VALUES("1075","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-11-30 16:59:25");
INSERT INTO registro_acesso VALUES("1076","Admin","1","177.58.175.48","Google Chrome","70.0.3538.110","linux","2018-11-30 17:57:03");
INSERT INTO registro_acesso VALUES("1077","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-11-30 20:20:58");
INSERT INTO registro_acesso VALUES("1078","biju","1","187.26.203.148","Google Chrome","70.0.3538.80","linux","2018-11-30 23:30:16");
INSERT INTO registro_acesso VALUES("1079","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-01 09:44:06");
INSERT INTO registro_acesso VALUES("1080","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-01 10:01:35");
INSERT INTO registro_acesso VALUES("1081","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-01 14:13:06");
INSERT INTO registro_acesso VALUES("1082","marcos","1","189.94.114.114","Google Chrome","70.0.3538.110","linux","2018-12-01 14:27:57");
INSERT INTO registro_acesso VALUES("1083","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-01 16:20:54");
INSERT INTO registro_acesso VALUES("1084","alexandre","1","187.111.157.220","Google Chrome","70.0.3538.110","windows","2018-12-01 17:54:38");
INSERT INTO registro_acesso VALUES("1085","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-01 18:13:35");
INSERT INTO registro_acesso VALUES("1086","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-01 19:18:20");
INSERT INTO registro_acesso VALUES("1087","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-01 20:37:15");
INSERT INTO registro_acesso VALUES("1088","jose44","1","179.127.239.110","Google Chrome","70.0.3538.80","linux","2018-12-01 21:32:54");
INSERT INTO registro_acesso VALUES("1089","vando","1","186.219.128.213","Google Chrome","70.0.3538.110","windows","2018-12-01 21:59:02");
INSERT INTO registro_acesso VALUES("1090","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-01 22:29:28");
INSERT INTO registro_acesso VALUES("1091","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-02 06:33:31");
INSERT INTO registro_acesso VALUES("1092","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-02 06:34:57");
INSERT INTO registro_acesso VALUES("1093","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-02 07:32:49");
INSERT INTO registro_acesso VALUES("1094","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-02 10:07:46");
INSERT INTO registro_acesso VALUES("1095","biju","1","189.92.127.69","Google Chrome","70.0.3538.80","linux","2018-12-02 15:17:43");
INSERT INTO registro_acesso VALUES("1096","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-02 18:23:38");
INSERT INTO registro_acesso VALUES("1097","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-02 18:44:29");
INSERT INTO registro_acesso VALUES("1098","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-02 19:44:34");
INSERT INTO registro_acesso VALUES("1099","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-02 21:41:20");
INSERT INTO registro_acesso VALUES("1100","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-03 09:54:39");
INSERT INTO registro_acesso VALUES("1101","marcos","1","179.242.28.31","Google Chrome","70.0.3538.110","linux","2018-12-03 10:07:26");
INSERT INTO registro_acesso VALUES("1102","marcos","1","179.242.28.31","Google Chrome","70.0.3538.110","linux","2018-12-03 10:08:22");
INSERT INTO registro_acesso VALUES("1104","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-03 13:20:05");
INSERT INTO registro_acesso VALUES("1105","alexandre","1","187.26.206.20","Google Chrome","46.0.2490.76","linux","2018-12-03 13:37:05");
INSERT INTO registro_acesso VALUES("1107","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-03 13:47:17");
INSERT INTO registro_acesso VALUES("1108","alexandre","1","187.26.206.20","Google Chrome","46.0.2490.76","linux","2018-12-03 14:14:49");
INSERT INTO registro_acesso VALUES("1109","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-12-03 14:15:51");
INSERT INTO registro_acesso VALUES("1110","vando","1","189.40.89.58","Google Chrome","70.0.3538.110","linux","2018-12-03 14:29:01");
INSERT INTO registro_acesso VALUES("1111","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-12-03 15:07:06");
INSERT INTO registro_acesso VALUES("1112","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-12-03 15:34:02");
INSERT INTO registro_acesso VALUES("1113","vando","1","189.40.89.133","Google Chrome","70.0.3538.110","linux","2018-12-03 16:54:53");
INSERT INTO registro_acesso VALUES("1114","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-03 17:47:50");
INSERT INTO registro_acesso VALUES("1115","marcos","1","189.92.217.46","Google Chrome","70.0.3538.110","linux","2018-12-03 18:10:38");
INSERT INTO registro_acesso VALUES("1116","marcos","1","189.92.217.46","Google Chrome","70.0.3538.110","linux","2018-12-03 18:11:44");
INSERT INTO registro_acesso VALUES("1117","marcos","1","177.75.57.194","Google Chrome","70.0.3538.110","linux","2018-12-03 18:34:08");
INSERT INTO registro_acesso VALUES("1118","marcos","1","177.75.57.194","Google Chrome","70.0.3538.110","linux","2018-12-03 18:34:55");
INSERT INTO registro_acesso VALUES("1119","marcos","1","177.75.57.194","Google Chrome","70.0.3538.110","linux","2018-12-03 18:35:26");
INSERT INTO registro_acesso VALUES("1120","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-03 19:51:09");
INSERT INTO registro_acesso VALUES("1121","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-03 19:56:48");
INSERT INTO registro_acesso VALUES("1123","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-12-03 20:36:30");
INSERT INTO registro_acesso VALUES("1124","marco17","1","177.79.24.201","Google Chrome","59.0.3071.125","linux","2018-12-03 20:38:59");
INSERT INTO registro_acesso VALUES("1125","lucy","1","177.125.36.29","Google Chrome","70.0.3538.110","windows","2018-12-03 20:49:25");
INSERT INTO registro_acesso VALUES("1126","ronaldo","1","186.219.139.46","Google Chrome","70.0.3538.110","linux","2018-12-03 20:52:15");
INSERT INTO registro_acesso VALUES("1127","lucy","2","177.125.36.29","Google Chrome","70.0.3538.110","windows","2018-12-03 21:37:57");
INSERT INTO registro_acesso VALUES("1128","marco17","1","191.5.102.226","Google Chrome","59.0.3071.125","linux","2018-12-03 21:44:15");
INSERT INTO registro_acesso VALUES("1129","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-03 22:40:47");
INSERT INTO registro_acesso VALUES("1130","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-03 22:45:52");
INSERT INTO registro_acesso VALUES("1131","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-03 22:49:29");
INSERT INTO registro_acesso VALUES("1132","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 07:18:37");
INSERT INTO registro_acesso VALUES("1133","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-04 11:04:38");
INSERT INTO registro_acesso VALUES("1134","vando","1","189.40.70.48","Google Chrome","70.0.3538.110","linux","2018-12-04 12:10:09");
INSERT INTO registro_acesso VALUES("1135","marcos","1","189.94.82.104","Google Chrome","70.0.3538.110","linux","2018-12-04 13:36:46");
INSERT INTO registro_acesso VALUES("1136","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-04 17:20:06");
INSERT INTO registro_acesso VALUES("1137","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 17:34:20");
INSERT INTO registro_acesso VALUES("1138","marcos","1","189.94.82.104","Google Chrome","70.0.3538.110","linux","2018-12-04 17:41:32");
INSERT INTO registro_acesso VALUES("1139","marcos","1","189.94.82.104","Google Chrome","70.0.3538.110","linux","2018-12-04 17:43:04");
INSERT INTO registro_acesso VALUES("1140","marcos","1","189.94.82.104","Google Chrome","70.0.3538.110","linux","2018-12-04 17:53:24");
INSERT INTO registro_acesso VALUES("1141","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-04 18:35:11");
INSERT INTO registro_acesso VALUES("1142","biju","1","179.241.202.12","Google Chrome","70.0.3538.80","linux","2018-12-04 20:57:22");
INSERT INTO registro_acesso VALUES("1143","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 20:59:16");
INSERT INTO registro_acesso VALUES("1144","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-04 21:01:33");
INSERT INTO registro_acesso VALUES("1145","ronaldo","1","186.219.139.46","Google Chrome","70.0.3538.110","linux","2018-12-04 21:15:08");
INSERT INTO registro_acesso VALUES("1146","alexandre","1","187.26.204.90","Google Chrome","46.0.2490.76","linux","2018-12-04 21:36:43");
INSERT INTO registro_acesso VALUES("1147","messias","1","189.40.94.250","Google Chrome","70.0.3538.110","linux","2018-12-04 22:06:21");
INSERT INTO registro_acesso VALUES("1148","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 22:18:32");
INSERT INTO registro_acesso VALUES("1149","vando","2","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 22:22:16");
INSERT INTO registro_acesso VALUES("1150","lucy","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 22:22:23");
INSERT INTO registro_acesso VALUES("1151","lucy","1","170.245.218.159","Google Chrome","70.0.3538.80","linux","2018-12-04 22:23:53");
INSERT INTO registro_acesso VALUES("1152","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","windows","2018-12-04 22:37:55");
INSERT INTO registro_acesso VALUES("1153","lucy","2","170.245.218.159","Google Chrome","70.0.3538.80","linux","2018-12-04 22:38:32");
INSERT INTO registro_acesso VALUES("1154","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-04 22:53:04");
INSERT INTO registro_acesso VALUES("1155","lucy","2","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 23:07:21");
INSERT INTO registro_acesso VALUES("1156","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-04 23:07:25");
INSERT INTO registro_acesso VALUES("1157","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-04 23:30:58");
INSERT INTO registro_acesso VALUES("1158","exclusiverio","1","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-04 23:35:40");
INSERT INTO registro_acesso VALUES("1159","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-05 00:09:58");
INSERT INTO registro_acesso VALUES("1160","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-05 00:10:05");
INSERT INTO registro_acesso VALUES("1161","exclusiverio","2","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-05 00:17:20");
INSERT INTO registro_acesso VALUES("1162","exclusiverio","1","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-05 00:17:23");
INSERT INTO registro_acesso VALUES("1163","exclusiverio","1","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-05 00:36:18");
INSERT INTO registro_acesso VALUES("1164","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-05 07:15:29");
INSERT INTO registro_acesso VALUES("1165","exclusiverio","1","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-05 08:14:34");
INSERT INTO registro_acesso VALUES("1166","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-05 08:30:16");
INSERT INTO registro_acesso VALUES("1167","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-05 08:30:26");
INSERT INTO registro_acesso VALUES("1168","alexandre","1","187.26.204.90","Google Chrome","46.0.2490.76","linux","2018-12-05 08:40:45");
INSERT INTO registro_acesso VALUES("1169","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-05 09:02:28");
INSERT INTO registro_acesso VALUES("1170","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-05 09:15:38");
INSERT INTO registro_acesso VALUES("1171","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 09:25:51");
INSERT INTO registro_acesso VALUES("1172","marcos","1","189.94.52.62","Google Chrome","70.0.3538.110","linux","2018-12-05 09:34:21");
INSERT INTO registro_acesso VALUES("1173","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-12-05 10:24:36");
INSERT INTO registro_acesso VALUES("1174","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-05 12:45:20");
INSERT INTO registro_acesso VALUES("1175","marcos","1","177.75.57.188","Google Chrome","70.0.3538.110","linux","2018-12-05 12:54:48");
INSERT INTO registro_acesso VALUES("1176","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-05 13:21:06");
INSERT INTO registro_acesso VALUES("1177","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 13:35:12");
INSERT INTO registro_acesso VALUES("1178","Admin","1","177.68.201.251","Google Chrome","70.0.3538.110","linux","2018-12-05 13:39:19");
INSERT INTO registro_acesso VALUES("1179","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-05 14:22:38");
INSERT INTO registro_acesso VALUES("1180","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 14:30:27");
INSERT INTO registro_acesso VALUES("1181","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 15:37:33");
INSERT INTO registro_acesso VALUES("1182","Admin","1","177.58.164.35","Google Chrome","70.0.3538.110","linux","2018-12-05 16:32:16");
INSERT INTO registro_acesso VALUES("1183","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-05 17:18:54");
INSERT INTO registro_acesso VALUES("1184","vando","1","189.40.68.192","Google Chrome","71.0.3578.83","linux","2018-12-05 17:58:31");
INSERT INTO registro_acesso VALUES("1185","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-05 18:58:06");
INSERT INTO registro_acesso VALUES("1186","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-05 19:31:17");
INSERT INTO registro_acesso VALUES("1187","exclusiverio","1","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-05 19:33:13");
INSERT INTO registro_acesso VALUES("1188","Admin","1","187.26.205.60","Google Chrome","70.0.3538.110","linux","2018-12-05 19:46:10");
INSERT INTO registro_acesso VALUES("1189","lucy","1","177.125.33.160","Google Chrome","70.0.3538.80","linux","2018-12-05 20:23:13");
INSERT INTO registro_acesso VALUES("1190","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-05 20:56:45");
INSERT INTO registro_acesso VALUES("1191","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-05 22:13:56");
INSERT INTO registro_acesso VALUES("1192","messias","1","189.40.95.133","Google Chrome","70.0.3538.110","linux","2018-12-05 22:20:29");
INSERT INTO registro_acesso VALUES("1193","ronaldo","1","186.219.139.14","Google Chrome","70.0.3538.110","linux","2018-12-05 22:46:14");
INSERT INTO registro_acesso VALUES("1194","jose44","1","179.127.239.77","Google Chrome","70.0.3538.110","linux","2018-12-05 23:08:49");
INSERT INTO registro_acesso VALUES("1195","ronaldo","1","186.219.139.14","Google Chrome","70.0.3538.110","linux","2018-12-05 23:19:26");
INSERT INTO registro_acesso VALUES("1196","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 23:42:31");
INSERT INTO registro_acesso VALUES("1197","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 23:42:51");
INSERT INTO registro_acesso VALUES("1198","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-05 23:44:04");
INSERT INTO registro_acesso VALUES("1199","exclusiverio","1","152.250.34.202","Google Chrome","70.0.3538.110","windows","2018-12-06 02:05:51");
INSERT INTO registro_acesso VALUES("1200","messias","1","189.40.94.77","Google Chrome","70.0.3538.110","linux","2018-12-06 06:29:19");
INSERT INTO registro_acesso VALUES("1201","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-06 09:48:16");
INSERT INTO registro_acesso VALUES("1202","vando","1","189.40.69.117","Google Chrome","71.0.3578.83","linux","2018-12-06 11:11:19");
INSERT INTO registro_acesso VALUES("1203","marcos","1","201.87.244.10","Google Chrome","70.0.3538.110","linux","2018-12-06 12:02:53");
INSERT INTO registro_acesso VALUES("1204","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 13:10:44");
INSERT INTO registro_acesso VALUES("1205","vando","1","189.40.70.100","Google Chrome","71.0.3578.83","linux","2018-12-06 14:12:48");
INSERT INTO registro_acesso VALUES("1206","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 14:28:12");
INSERT INTO registro_acesso VALUES("1207","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 14:34:53");
INSERT INTO registro_acesso VALUES("1208","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 14:35:09");
INSERT INTO registro_acesso VALUES("1209","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 14:37:33");
INSERT INTO registro_acesso VALUES("1210","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 15:08:50");
INSERT INTO registro_acesso VALUES("1211","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-06 17:35:39");
INSERT INTO registro_acesso VALUES("1212","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 18:29:49");
INSERT INTO registro_acesso VALUES("1213","marcos","1","189.94.102.18","Google Chrome","70.0.3538.110","linux","2018-12-06 18:33:22");
INSERT INTO registro_acesso VALUES("1214","marcos","1","177.75.57.180","Google Chrome","70.0.3538.110","linux","2018-12-06 20:33:47");
INSERT INTO registro_acesso VALUES("1215","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-06 20:38:58");
INSERT INTO registro_acesso VALUES("1216","alexandre","1","187.26.152.3","Google Chrome","46.0.2490.76","linux","2018-12-06 21:40:01");
INSERT INTO registro_acesso VALUES("1217","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-06 21:41:15");
INSERT INTO registro_acesso VALUES("1218","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-06 22:29:26");
INSERT INTO registro_acesso VALUES("1219","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-06 22:44:33");
INSERT INTO registro_acesso VALUES("1220","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-06 22:51:55");
INSERT INTO registro_acesso VALUES("1221","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-06 23:11:09");
INSERT INTO registro_acesso VALUES("1222","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-07 06:57:10");
INSERT INTO registro_acesso VALUES("1223","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-07 07:31:04");
INSERT INTO registro_acesso VALUES("1224","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-07 08:15:37");
INSERT INTO registro_acesso VALUES("1225","marcos","1","189.94.102.18","Google Chrome","71.0.3578.83","linux","2018-12-07 08:43:50");
INSERT INTO registro_acesso VALUES("1226","vando","1","189.40.70.50","Google Chrome","71.0.3578.83","linux","2018-12-07 11:08:59");
INSERT INTO registro_acesso VALUES("1227","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-07 12:54:46");
INSERT INTO registro_acesso VALUES("1228","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-07 14:27:03");
INSERT INTO registro_acesso VALUES("1230","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-07 19:16:29");
INSERT INTO registro_acesso VALUES("1231","biju","1","189.92.97.79","Google Chrome","70.0.3538.80","linux","2018-12-07 20:21:03");
INSERT INTO registro_acesso VALUES("1232","Admin","1","177.58.166.71","Google Chrome","70.0.3538.110","linux","2018-12-07 20:57:57");
INSERT INTO registro_acesso VALUES("1233","Admin","1","177.58.166.71","Google Chrome","70.0.3538.110","linux","2018-12-07 20:58:07");
INSERT INTO registro_acesso VALUES("1235","alessandromp","1","192.12.113.71","Google Chrome","70.0.3538.110","linux","2018-12-07 21:06:21");
INSERT INTO registro_acesso VALUES("1236","Admin","1","177.58.166.71","Google Chrome","70.0.3538.110","linux","2018-12-07 21:39:08");
INSERT INTO registro_acesso VALUES("1237","Admin","1","177.58.166.71","Google Chrome","70.0.3538.110","linux","2018-12-07 21:39:19");
INSERT INTO registro_acesso VALUES("1238","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-08 01:32:50");
INSERT INTO registro_acesso VALUES("1239","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-08 08:28:07");
INSERT INTO registro_acesso VALUES("1240","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-08 09:18:45");
INSERT INTO registro_acesso VALUES("1241","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-08 09:57:00");
INSERT INTO registro_acesso VALUES("1242","marcos","1","179.242.17.1","Google Chrome","71.0.3578.83","linux","2018-12-08 10:27:43");
INSERT INTO registro_acesso VALUES("1243","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-08 11:13:55");
INSERT INTO registro_acesso VALUES("1244","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-08 11:17:36");
INSERT INTO registro_acesso VALUES("1245","marco17","1","177.58.228.45","Google Chrome","59.0.3071.125","linux","2018-12-08 11:19:56");
INSERT INTO registro_acesso VALUES("1246","biju","1","187.26.65.108","Google Chrome","70.0.3538.80","linux","2018-12-08 12:53:28");
INSERT INTO registro_acesso VALUES("1247","alessandromp","1","192.12.113.88","Google Chrome","71.0.3578.83","linux","2018-12-08 14:12:44");
INSERT INTO registro_acesso VALUES("1248","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 16:21:50");
INSERT INTO registro_acesso VALUES("1249","lucy","2","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 16:24:52");
INSERT INTO registro_acesso VALUES("1250","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-08 16:48:20");
INSERT INTO registro_acesso VALUES("1251","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-08 18:31:20");
INSERT INTO registro_acesso VALUES("1252","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-08 19:10:12");
INSERT INTO registro_acesso VALUES("1253","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-08 19:10:53");
INSERT INTO registro_acesso VALUES("1254","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 19:41:42");
INSERT INTO registro_acesso VALUES("1255","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 19:41:45");
INSERT INTO registro_acesso VALUES("1256","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 19:41:53");
INSERT INTO registro_acesso VALUES("1257","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 20:02:40");
INSERT INTO registro_acesso VALUES("1258","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 20:02:56");
INSERT INTO registro_acesso VALUES("1259","lucy","1","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 21:25:14");
INSERT INTO registro_acesso VALUES("1260","lucy","2","170.245.217.210","Google Chrome","70.0.3538.80","linux","2018-12-08 21:26:33");
INSERT INTO registro_acesso VALUES("1261","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-08 21:31:52");
INSERT INTO registro_acesso VALUES("1262","ronaldo","1","186.219.139.10","Google Chrome","70.0.3538.110","linux","2018-12-08 23:39:35");
INSERT INTO registro_acesso VALUES("1263","Admin","1","187.73.148.59","Google Chrome","70.0.3538.110","linux","2018-12-09 00:34:02");
INSERT INTO registro_acesso VALUES("1264","messias","1","189.40.95.246","Google Chrome","70.0.3538.110","linux","2018-12-09 11:01:44");
INSERT INTO registro_acesso VALUES("1265","salsicha","1","201.71.251.131","Apple Safari","12.0","mac","2018-12-09 11:52:04");
INSERT INTO registro_acesso VALUES("1266","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-09 12:09:03");
INSERT INTO registro_acesso VALUES("1267","messias","1","189.40.95.55","Google Chrome","70.0.3538.110","linux","2018-12-09 13:09:28");
INSERT INTO registro_acesso VALUES("1268","messias","1","189.40.95.55","Google Chrome","70.0.3538.110","linux","2018-12-09 13:42:02");
INSERT INTO registro_acesso VALUES("1269","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-09 13:49:37");
INSERT INTO registro_acesso VALUES("1270","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-09 13:51:40");
INSERT INTO registro_acesso VALUES("1271","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-09 18:02:43");
INSERT INTO registro_acesso VALUES("1272","Admin","1","187.73.148.59","Google Chrome","71.0.3578.80","windows","2018-12-09 18:06:35");
INSERT INTO registro_acesso VALUES("1273","vando","1","177.22.181.56","Google Chrome","70.0.3538.110","windows","2018-12-09 20:53:39");
INSERT INTO registro_acesso VALUES("1274","marco17","1","191.5.102.226","Google Chrome","59.0.3071.125","linux","2018-12-09 21:09:36");
INSERT INTO registro_acesso VALUES("1275","marco17","1","191.5.102.226","Google Chrome","59.0.3071.125","linux","2018-12-09 21:11:07");
INSERT INTO registro_acesso VALUES("1276","Admin","1","187.73.148.59","Google Chrome","71.0.3578.80","windows","2018-12-09 21:20:01");
INSERT INTO registro_acesso VALUES("1277","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-09 21:54:41");
INSERT INTO registro_acesso VALUES("1278","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-10 05:59:15");
INSERT INTO registro_acesso VALUES("1279","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-10 06:24:14");
INSERT INTO registro_acesso VALUES("1280","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-10 09:48:55");
INSERT INTO registro_acesso VALUES("1281","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-10 10:53:13");
INSERT INTO registro_acesso VALUES("1282","biju","1","189.92.99.55","Google Chrome","70.0.3538.80","linux","2018-12-10 11:16:34");
INSERT INTO registro_acesso VALUES("1283","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-10 12:29:42");
INSERT INTO registro_acesso VALUES("1284","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-10 14:33:57");
INSERT INTO registro_acesso VALUES("1285","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-10 15:01:55");
INSERT INTO registro_acesso VALUES("1286","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-10 17:06:24");
INSERT INTO registro_acesso VALUES("1287","jose44","1","179.127.236.19","Google Chrome","71.0.3578.83","linux","2018-12-10 17:22:40");
INSERT INTO registro_acesso VALUES("1288","jose44","1","179.127.236.19","Google Chrome","71.0.3578.83","linux","2018-12-10 17:28:16");
INSERT INTO registro_acesso VALUES("1289","jose44","1","179.127.236.19","Google Chrome","71.0.3578.83","linux","2018-12-10 17:40:53");
INSERT INTO registro_acesso VALUES("1290","Admin","1","187.26.159.179","Google Chrome","71.0.3578.83","linux","2018-12-10 17:57:43");
INSERT INTO registro_acesso VALUES("1291","salsicha","1","45.70.0.252","Apple Safari","12.0","mac","2018-12-10 18:28:53");
INSERT INTO registro_acesso VALUES("1292","lucy","1","177.125.36.169","Google Chrome","70.0.3538.110","windows","2018-12-10 19:32:22");
INSERT INTO registro_acesso VALUES("1293","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-10 20:10:31");
INSERT INTO registro_acesso VALUES("1294","salsicha","1","45.70.0.244","Apple Safari","12.0","mac","2018-12-10 20:16:03");
INSERT INTO registro_acesso VALUES("1295","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-10 21:31:59");
INSERT INTO registro_acesso VALUES("1296","jose44","1","179.127.236.19","Google Chrome","71.0.3578.83","linux","2018-12-10 22:10:26");
INSERT INTO registro_acesso VALUES("1297","jose44","1","179.127.236.19","Google Chrome","71.0.3578.83","linux","2018-12-10 22:52:28");
INSERT INTO registro_acesso VALUES("1298","lucy","1","177.125.36.169","Google Chrome","70.0.3538.110","windows","2018-12-10 22:55:31");
INSERT INTO registro_acesso VALUES("1299","lucy","2","177.125.36.169","Google Chrome","70.0.3538.110","windows","2018-12-10 22:59:50");
INSERT INTO registro_acesso VALUES("1300","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-10 23:01:35");
INSERT INTO registro_acesso VALUES("1301","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-10 23:03:28");
INSERT INTO registro_acesso VALUES("1302","alexandre","1","167.250.91.228","Google Chrome","46.0.2490.76","linux","2018-12-10 23:13:47");
INSERT INTO registro_acesso VALUES("1303","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-10 23:22:17");
INSERT INTO registro_acesso VALUES("1304","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-10 23:30:09");
INSERT INTO registro_acesso VALUES("1305","Admin","1","187.73.148.59","Google Chrome","71.0.3578.80","windows","2018-12-11 00:04:12");
INSERT INTO registro_acesso VALUES("1306","lucy","1","170.245.219.219","Google Chrome","70.0.3538.110","windows","2018-12-11 12:10:26");
INSERT INTO registro_acesso VALUES("1307","lucy","2","170.245.219.219","Google Chrome","70.0.3538.110","windows","2018-12-11 12:14:22");
INSERT INTO registro_acesso VALUES("1308","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-11 14:17:16");
INSERT INTO registro_acesso VALUES("1309","lucy","1","170.245.219.219","Google Chrome","70.0.3538.110","windows","2018-12-11 16:44:33");
INSERT INTO registro_acesso VALUES("1310","jose44","1","179.127.239.148","Google Chrome","71.0.3578.83","linux","2018-12-11 16:46:10");
INSERT INTO registro_acesso VALUES("1311","lucy","2","170.245.219.219","Google Chrome","70.0.3538.110","windows","2018-12-11 16:48:17");
INSERT INTO registro_acesso VALUES("1312","jose44","1","179.127.239.148","Google Chrome","71.0.3578.83","linux","2018-12-11 17:57:11");
INSERT INTO registro_acesso VALUES("1313","ronaldo","1","186.219.139.10","Google Chrome","70.0.3538.110","linux","2018-12-11 20:33:19");
INSERT INTO registro_acesso VALUES("1314","Admin","1","170.83.121.28","Google Chrome","71.0.3578.83","linux","2018-12-11 20:38:40");
INSERT INTO registro_acesso VALUES("1315","vando","1","189.40.68.88","Google Chrome","71.0.3578.83","linux","2018-12-11 20:46:39");
INSERT INTO registro_acesso VALUES("1316","jose44","1","179.127.239.148","Google Chrome","71.0.3578.83","linux","2018-12-11 21:01:50");
INSERT INTO registro_acesso VALUES("1317","lucy","1","170.245.219.219","Google Chrome","70.0.3538.110","windows","2018-12-11 21:21:01");
INSERT INTO registro_acesso VALUES("1318","lucy","2","170.245.219.219","Google Chrome","70.0.3538.110","windows","2018-12-11 21:29:24");
INSERT INTO registro_acesso VALUES("1319","marcos","1","177.75.57.180","Google Chrome","71.0.3578.83","linux","2018-12-11 21:32:09");
INSERT INTO registro_acesso VALUES("1320","vando","1","189.40.68.88","Google Chrome","71.0.3578.83","linux","2018-12-11 21:48:54");
INSERT INTO registro_acesso VALUES("1321","messias","1","170.247.114.165","Google Chrome","70.0.3538.110","windows","2018-12-11 21:55:56");
INSERT INTO registro_acesso VALUES("1322","Admin","1","187.73.148.59","Google Chrome","71.0.3578.80","windows","2018-12-11 22:03:23");
INSERT INTO registro_acesso VALUES("1323","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-11 22:06:29");
INSERT INTO registro_acesso VALUES("1324","vando","2","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-11 22:20:38");
INSERT INTO registro_acesso VALUES("1325","ronaldo","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-11 22:22:09");
INSERT INTO registro_acesso VALUES("1326","ronaldo","2","186.219.139.10","Google Chrome","70.0.3538.110","linux","2018-12-11 22:24:46");
INSERT INTO registro_acesso VALUES("1327","ronaldo","1","186.219.139.10","Google Chrome","70.0.3538.110","linux","2018-12-11 22:24:49");
INSERT INTO registro_acesso VALUES("1328","ronaldo","2","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-11 22:40:50");
INSERT INTO registro_acesso VALUES("1329","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-11 22:40:54");
INSERT INTO registro_acesso VALUES("1330","caiquecs","1","177.79.9.29","Google Chrome","70.0.3538.80","linux","2018-12-12 06:59:18");
INSERT INTO registro_acesso VALUES("1331","marcos","1","179.242.31.19","Google Chrome","71.0.3578.83","linux","2018-12-12 08:18:58");
INSERT INTO registro_acesso VALUES("1332","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-12 08:25:52");
INSERT INTO registro_acesso VALUES("1333","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-12 10:03:16");
INSERT INTO registro_acesso VALUES("1334","jose44","1","179.127.239.127","Google Chrome","71.0.3578.83","linux","2018-12-12 11:28:33");
INSERT INTO registro_acesso VALUES("1335","jose44","1","179.127.239.127","Google Chrome","71.0.3578.83","linux","2018-12-12 11:28:34");
INSERT INTO registro_acesso VALUES("1336","jose44","1","179.127.239.127","Google Chrome","71.0.3578.83","linux","2018-12-12 11:39:56");
INSERT INTO registro_acesso VALUES("1337","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-12 11:46:01");
INSERT INTO registro_acesso VALUES("1338","vando","1","200.34.161.253","Google Chrome","71.0.3578.83","linux","2018-12-12 13:41:56");
INSERT INTO registro_acesso VALUES("1339","Admin","1","189.92.126.78","Google Chrome","71.0.3578.83","linux","2018-12-12 13:51:54");
INSERT INTO registro_acesso VALUES("1340","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-12 14:20:10");
INSERT INTO registro_acesso VALUES("1341","marcos","1","189.92.215.32","Google Chrome","71.0.3578.83","linux","2018-12-12 14:30:04");
INSERT INTO registro_acesso VALUES("1342","messias","1","170.247.114.165","Google Chrome","70.0.3538.110","linux","2018-12-12 14:55:30");
INSERT INTO registro_acesso VALUES("1343","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-12 16:00:41");
INSERT INTO registro_acesso VALUES("1344","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-12 16:18:16");
INSERT INTO registro_acesso VALUES("1345","marcos","1","201.87.244.10","Google Chrome","71.0.3578.83","linux","2018-12-12 16:27:02");
INSERT INTO registro_acesso VALUES("1346","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-12 18:32:46");
INSERT INTO registro_acesso VALUES("1347","caiquecs","1","177.79.12.154","Google Chrome","70.0.3538.80","linux","2018-12-12 19:55:04");
INSERT INTO registro_acesso VALUES("1348","Admin","1","189.92.126.78","Google Chrome","71.0.3578.83","linux","2018-12-12 19:56:07");
INSERT INTO registro_acesso VALUES("1349","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-12 20:41:34");
INSERT INTO registro_acesso VALUES("1350","caiquecs","1","201.95.2.104","Google Chrome","70.0.3538.80","linux","2018-12-12 20:45:36");
INSERT INTO registro_acesso VALUES("1351","caiquecs","1","201.95.2.104","Google Chrome","70.0.3538.80","linux","2018-12-12 20:45:43");
INSERT INTO registro_acesso VALUES("1352","messias","1","170.247.114.165","Google Chrome","70.0.3538.110","windows","2018-12-12 21:31:16");
INSERT INTO registro_acesso VALUES("1353","vando","1","189.40.69.81","Google Chrome","71.0.3578.83","linux","2018-12-12 21:35:12");
INSERT INTO registro_acesso VALUES("1354","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-12 22:59:39");
INSERT INTO registro_acesso VALUES("1355","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-12 23:01:38");
INSERT INTO registro_acesso VALUES("1356","lucy","1","177.125.36.87","Google Chrome","70.0.3538.110","windows","2018-12-13 00:11:54");
INSERT INTO registro_acesso VALUES("1357","lucy","1","177.125.36.87","Google Chrome","70.0.3538.80","linux","2018-12-13 00:23:53");
INSERT INTO registro_acesso VALUES("1358","lucy","2","177.125.36.87","Google Chrome","70.0.3538.80","linux","2018-12-13 00:53:18");
INSERT INTO registro_acesso VALUES("1359","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-13 06:52:59");
INSERT INTO registro_acesso VALUES("1360","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-13 07:12:14");
INSERT INTO registro_acesso VALUES("1361","Admin","1","177.58.239.91","Google Chrome","71.0.3578.83","linux","2018-12-13 07:19:55");
INSERT INTO registro_acesso VALUES("1362","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-13 07:49:08");
INSERT INTO registro_acesso VALUES("1363","marcos","1","200.96.218.211","Google Chrome","71.0.3578.83","linux","2018-12-13 07:58:46");
INSERT INTO registro_acesso VALUES("1364","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-13 08:46:28");
INSERT INTO registro_acesso VALUES("1365","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-13 09:01:48");
INSERT INTO registro_acesso VALUES("1366","marcos","1","179.241.252.56","Google Chrome","71.0.3578.83","linux","2018-12-13 09:07:22");
INSERT INTO registro_acesso VALUES("1367","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-13 10:40:19");
INSERT INTO registro_acesso VALUES("1368","vando","1","177.156.231.236","Google Chrome","71.0.3578.98","linux","2018-12-13 11:35:46");
INSERT INTO registro_acesso VALUES("1369","marcos","1","179.241.253.31","Google Chrome","71.0.3578.83","linux","2018-12-13 12:04:53");
INSERT INTO registro_acesso VALUES("1370","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-13 12:31:19");
INSERT INTO registro_acesso VALUES("1371","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-13 12:44:36");
INSERT INTO registro_acesso VALUES("1372","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-13 13:34:21");
INSERT INTO registro_acesso VALUES("1373","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-13 13:56:04");
INSERT INTO registro_acesso VALUES("1374","marco17","1","187.119.230.221","Google Chrome","59.0.3071.125","linux","2018-12-13 14:27:22");
INSERT INTO registro_acesso VALUES("1375","caiquecs","1","177.79.25.145","Google Chrome","70.0.3538.80","linux","2018-12-13 14:41:08");
INSERT INTO registro_acesso VALUES("1376","vando","1","189.40.68.94","Google Chrome","71.0.3578.98","linux","2018-12-13 17:57:41");
INSERT INTO registro_acesso VALUES("1377","Admin","1","177.58.233.99","Google Chrome","71.0.3578.83","linux","2018-12-13 18:06:59");
INSERT INTO registro_acesso VALUES("1378","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-13 19:27:15");
INSERT INTO registro_acesso VALUES("1379","vando","1","177.22.178.21","Google Chrome","70.0.3538.110","windows","2018-12-13 20:16:50");
INSERT INTO registro_acesso VALUES("1380","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-13 20:46:10");
INSERT INTO registro_acesso VALUES("1381","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-13 22:24:59");
INSERT INTO registro_acesso VALUES("1382","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-13 22:43:33");
INSERT INTO registro_acesso VALUES("1383","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-13 23:16:07");
INSERT INTO registro_acesso VALUES("1384","caiquecs","1","177.79.28.94","Google Chrome","70.0.3538.80","linux","2018-12-14 09:12:30");
INSERT INTO registro_acesso VALUES("1385","vando","1","189.40.69.176","Google Chrome","71.0.3578.98","linux","2018-12-14 09:52:27");
INSERT INTO registro_acesso VALUES("1386","Admin","1","177.58.242.62","Google Chrome","71.0.3578.83","linux","2018-12-14 13:01:30");
INSERT INTO registro_acesso VALUES("1387","vando","1","177.22.178.14","Google Chrome","70.0.3538.110","windows","2018-12-14 13:15:35");
INSERT INTO registro_acesso VALUES("1388","caiquecs","1","177.78.7.208","Google Chrome","70.0.3538.80","linux","2018-12-14 16:49:52");
INSERT INTO registro_acesso VALUES("1389","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-14 18:34:13");
INSERT INTO registro_acesso VALUES("1390","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-14 19:00:30");
INSERT INTO registro_acesso VALUES("1391","marcos","1","179.241.195.94","Google Chrome","71.0.3578.83","linux","2018-12-14 20:24:39");
INSERT INTO registro_acesso VALUES("1392","vando","1","143.202.133.127","Google Chrome","70.0.3538.110","windows","2018-12-14 20:41:11");
INSERT INTO registro_acesso VALUES("1393","vando","1","143.202.133.127","Google Chrome","70.0.3538.110","windows","2018-12-14 20:41:20");
INSERT INTO registro_acesso VALUES("1394","jose44","1","177.220.166.189","Google Chrome","71.0.3578.83","linux","2018-12-14 20:45:18");
INSERT INTO registro_acesso VALUES("1395","jose44","1","177.220.166.189","Google Chrome","71.0.3578.83","linux","2018-12-14 20:49:04");
INSERT INTO registro_acesso VALUES("1396","jose44","1","177.220.166.189","Google Chrome","71.0.3578.83","linux","2018-12-14 20:51:28");
INSERT INTO registro_acesso VALUES("1397","Admin","1","179.241.217.92","Google Chrome","71.0.3578.83","linux","2018-12-14 21:57:54");
INSERT INTO registro_acesso VALUES("1398","vando","1","200.34.161.180","Google Chrome","71.0.3578.98","linux","2018-12-14 22:39:21");
INSERT INTO registro_acesso VALUES("1399","marco17","1","177.79.27.68","Google Chrome","59.0.3071.125","linux","2018-12-14 22:41:20");
INSERT INTO registro_acesso VALUES("1400","lucy","1","191.39.93.10","Google Chrome","70.0.3538.80","linux","2018-12-14 22:41:21");
INSERT INTO registro_acesso VALUES("1401","vando","1","177.18.49.34","Google Chrome","70.0.3538.110","windows","2018-12-15 07:36:21");
INSERT INTO registro_acesso VALUES("1402","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-15 09:59:12");
INSERT INTO registro_acesso VALUES("1403","marco17","1","191.246.1.16","Google Chrome","59.0.3071.125","linux","2018-12-15 16:31:18");
INSERT INTO registro_acesso VALUES("1404","caiquecs","1","187.119.233.95","Google Chrome","70.0.3538.80","linux","2018-12-15 16:34:57");
INSERT INTO registro_acesso VALUES("1405","marcos","1","177.1.241.72","Google Chrome","71.0.3578.98","linux","2018-12-15 16:54:33");
INSERT INTO registro_acesso VALUES("1406","vando","1","143.202.133.97","Google Chrome","70.0.3538.110","windows","2018-12-15 17:04:16");
INSERT INTO registro_acesso VALUES("1407","marcos","1","201.87.244.10","Google Chrome","71.0.3578.98","linux","2018-12-15 17:41:25");
INSERT INTO registro_acesso VALUES("1408","marcos","1","201.87.244.10","Google Chrome","71.0.3578.98","linux","2018-12-15 17:42:39");
INSERT INTO registro_acesso VALUES("1409","lucy","1","191.39.90.150","Google Chrome","70.0.3538.80","linux","2018-12-15 17:45:29");
INSERT INTO registro_acesso VALUES("1410","lucy","1","191.39.87.176","Google Chrome","70.0.3538.80","linux","2018-12-15 17:51:42");
INSERT INTO registro_acesso VALUES("1411","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-15 17:52:16");
INSERT INTO registro_acesso VALUES("1412","marco17","1","191.246.1.16","Google Chrome","59.0.3071.125","linux","2018-12-15 17:53:35");
INSERT INTO registro_acesso VALUES("1413","lucy","1","177.125.36.175","Google Chrome","70.0.3538.110","windows","2018-12-15 18:13:42");
INSERT INTO registro_acesso VALUES("1414","marcos","1","179.242.16.51","Google Chrome","71.0.3578.98","linux","2018-12-15 18:30:48");
INSERT INTO registro_acesso VALUES("1415","lucy","1","177.125.36.175","Google Chrome","70.0.3538.110","windows","2018-12-15 19:02:37");
INSERT INTO registro_acesso VALUES("1416","lucy","2","177.125.36.175","Google Chrome","70.0.3538.110","windows","2018-12-15 19:04:09");
INSERT INTO registro_acesso VALUES("1417","lucy","1","177.125.36.175","Google Chrome","70.0.3538.80","linux","2018-12-15 19:05:27");
INSERT INTO registro_acesso VALUES("1418","lucy","2","191.39.93.75","Google Chrome","70.0.3538.80","linux","2018-12-15 19:07:27");
INSERT INTO registro_acesso VALUES("1419","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-15 20:27:23");
INSERT INTO registro_acesso VALUES("1420","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-15 20:27:52");
INSERT INTO registro_acesso VALUES("1421","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-15 21:39:59");
INSERT INTO registro_acesso VALUES("1422","marcos","1","191.217.21.174","Google Chrome","71.0.3578.98","linux","2018-12-15 22:11:14");
INSERT INTO registro_acesso VALUES("1423","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-15 22:23:06");
INSERT INTO registro_acesso VALUES("1424","messias","1","170.247.114.165","Google Chrome","70.0.3538.110","linux","2018-12-15 23:12:03");
INSERT INTO registro_acesso VALUES("1425","lucy","1","177.125.36.175","Google Chrome","70.0.3538.110","windows","2018-12-15 23:26:15");
INSERT INTO registro_acesso VALUES("1426","lucy","2","177.125.36.175","Google Chrome","70.0.3538.110","windows","2018-12-15 23:31:29");
INSERT INTO registro_acesso VALUES("1427","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-16 00:43:56");
INSERT INTO registro_acesso VALUES("1428","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-16 00:46:04");
INSERT INTO registro_acesso VALUES("1429","vando","1","143.202.133.97","Google Chrome","70.0.3538.110","windows","2018-12-16 08:49:13");
INSERT INTO registro_acesso VALUES("1430","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-16 09:14:43");
INSERT INTO registro_acesso VALUES("1431","salsicha","1","187.73.151.164","Apple Safari","12.0","mac","2018-12-16 09:20:03");
INSERT INTO registro_acesso VALUES("1432","marcos","1","179.242.1.3","Google Chrome","71.0.3578.98","linux","2018-12-16 09:22:38");
INSERT INTO registro_acesso VALUES("1433","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-16 11:10:04");
INSERT INTO registro_acesso VALUES("1434","salsicha","1","177.58.175.52","Apple Safari","12.0","mac","2018-12-16 11:31:53");
INSERT INTO registro_acesso VALUES("1435","biju","1","143.202.133.7","Google Chrome","71.0.3578.98","linux","2018-12-16 17:01:39");
INSERT INTO registro_acesso VALUES("1436","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-16 18:11:26");
INSERT INTO registro_acesso VALUES("1437","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","windows","2018-12-16 19:34:16");
INSERT INTO registro_acesso VALUES("1438","marco17","1","191.5.102.226","Google Chrome","59.0.3071.125","linux","2018-12-16 20:56:01");
INSERT INTO registro_acesso VALUES("1439","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-16 21:22:12");
INSERT INTO registro_acesso VALUES("1440","vando","1","189.40.71.158","Google Chrome","71.0.3578.98","linux","2018-12-17 08:22:57");
INSERT INTO registro_acesso VALUES("1441","marcos","1","179.252.92.181","Google Chrome","71.0.3578.98","linux","2018-12-17 09:02:16");
INSERT INTO registro_acesso VALUES("1442","marcos","1","189.92.202.80","Google Chrome","71.0.3578.98","linux","2018-12-17 10:15:12");
INSERT INTO registro_acesso VALUES("1443","marcos","1","189.92.202.80","Google Chrome","71.0.3578.98","linux","2018-12-17 10:51:39");
INSERT INTO registro_acesso VALUES("1444","marcos","1","189.92.202.80","Google Chrome","71.0.3578.98","linux","2018-12-17 12:33:23");
INSERT INTO registro_acesso VALUES("1445","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-17 16:17:24");
INSERT INTO registro_acesso VALUES("1446","Admin","1","170.83.121.28","Google Chrome","71.0.3578.83","linux","2018-12-17 18:46:35");
INSERT INTO registro_acesso VALUES("1447","messias","1","170.78.60.208","Google Chrome","70.0.3538.110","linux","2018-12-17 19:40:23");
INSERT INTO registro_acesso VALUES("1448","lucy","1","170.245.217.131","Google Chrome","70.0.3538.80","linux","2018-12-17 23:02:19");
INSERT INTO registro_acesso VALUES("1449","vando","1","143.202.133.97","Google Chrome","70.0.3538.110","windows","2018-12-17 23:20:18");
INSERT INTO registro_acesso VALUES("1450","lucy","1","170.245.217.131","Google Chrome","70.0.3538.80","linux","2018-12-18 06:53:47");
INSERT INTO registro_acesso VALUES("1451","vando","1","186.215.19.250","Google Chrome","70.0.3538.110","windows","2018-12-18 07:10:41");
INSERT INTO registro_acesso VALUES("1452","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-18 08:04:40");
INSERT INTO registro_acesso VALUES("1453","marcos","1","201.87.244.10","Google Chrome","71.0.3578.98","linux","2018-12-18 09:18:06");
INSERT INTO registro_acesso VALUES("1454","marco17","1","177.58.181.31","Google Chrome","59.0.3071.125","linux","2018-12-18 11:42:11");
INSERT INTO registro_acesso VALUES("1455","messias","1","170.78.62.99","Google Chrome","71.0.3578.98","windows","2018-12-18 12:25:52");
INSERT INTO registro_acesso VALUES("1456","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-18 12:48:59");
INSERT INTO registro_acesso VALUES("1457","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-18 15:27:04");
INSERT INTO registro_acesso VALUES("1458","messias","1","170.78.62.99","Google Chrome","71.0.3578.98","windows","2018-12-18 17:29:06");
INSERT INTO registro_acesso VALUES("1459","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-18 18:57:03");
INSERT INTO registro_acesso VALUES("1460","marcos","1","179.241.192.67","Google Chrome","71.0.3578.98","linux","2018-12-18 19:09:23");
INSERT INTO registro_acesso VALUES("1461","caiquecs","1","177.102.157.53","Google Chrome","70.0.3538.80","linux","2018-12-18 20:13:22");
INSERT INTO registro_acesso VALUES("1462","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-18 20:16:55");
INSERT INTO registro_acesso VALUES("1463","caiquecs","1","177.102.157.53","Google Chrome","70.0.3538.80","linux","2018-12-18 20:19:49");
INSERT INTO registro_acesso VALUES("1464","Admin","1","187.26.152.79","Google Chrome","71.0.3578.83","linux","2018-12-18 20:39:07");
INSERT INTO registro_acesso VALUES("1465","marcos","1","177.75.57.180","Google Chrome","71.0.3578.98","linux","2018-12-18 21:50:24");
INSERT INTO registro_acesso VALUES("1466","marcos","1","177.75.57.180","Google Chrome","71.0.3578.98","linux","2018-12-19 08:42:22");
INSERT INTO registro_acesso VALUES("1467","vando","1","177.74.136.81","Google Chrome","71.0.3578.98","linux","2018-12-19 09:33:02");
INSERT INTO registro_acesso VALUES("1468","anderson81","1","170.82.86.142","Google Chrome","70.0.3538.110","linux","2018-12-19 10:15:18");
INSERT INTO registro_acesso VALUES("1469","biju","1","143.202.133.56","Google Chrome","71.0.3578.98","linux","2018-12-19 11:06:49");
INSERT INTO registro_acesso VALUES("1470","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-19 12:39:40");
INSERT INTO registro_acesso VALUES("1471","messias","1","170.78.62.99","Google Chrome","71.0.3578.98","windows","2018-12-19 13:26:20");
INSERT INTO registro_acesso VALUES("1472","marcos","1","189.92.232.64","Google Chrome","71.0.3578.98","linux","2018-12-19 15:18:32");
INSERT INTO registro_acesso VALUES("1473","vando","1","200.34.161.250","Google Chrome","71.0.3578.98","linux","2018-12-19 16:37:45");
INSERT INTO registro_acesso VALUES("1474","vando","1","189.40.68.134","Google Chrome","71.0.3578.98","linux","2018-12-19 16:38:56");
INSERT INTO registro_acesso VALUES("1475","marcos","1","189.94.67.48","Google Chrome","71.0.3578.98","linux","2018-12-19 17:56:15");
INSERT INTO registro_acesso VALUES("1476","anderson81","1","168.121.112.22","Google Chrome","70.0.3538.110","linux","2018-12-19 18:56:41");
INSERT INTO registro_acesso VALUES("1477","Admin","1","177.58.164.117","Google Chrome","71.0.3578.83","linux","2018-12-19 21:44:20");
INSERT INTO registro_acesso VALUES("1478","messias","1","170.78.62.99","Google Chrome","71.0.3578.98","windows","2018-12-19 21:53:01");
INSERT INTO registro_acesso VALUES("1479","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-19 22:00:42");
INSERT INTO registro_acesso VALUES("1480","anderson81","1","168.121.112.22","Google Chrome","71.0.3578.99","linux","2018-12-20 00:30:19");
INSERT INTO registro_acesso VALUES("1481","vando","1","189.58.235.228","Google Chrome","71.0.3578.98","windows","2018-12-20 07:23:38");
INSERT INTO registro_acesso VALUES("1482","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-20 09:28:45");
INSERT INTO registro_acesso VALUES("1483","vando","1","189.58.235.228","Google Chrome","71.0.3578.98","windows","2018-12-20 11:26:40");
INSERT INTO registro_acesso VALUES("1484","marcos","1","201.87.244.10","Google Chrome","71.0.3578.99","linux","2018-12-20 11:59:48");
INSERT INTO registro_acesso VALUES("1485","marco17","1","187.26.152.93","Google Chrome","59.0.3071.125","linux","2018-12-20 12:01:50");
INSERT INTO registro_acesso VALUES("1486","marco17","1","187.26.152.93","Google Chrome","59.0.3071.125","linux","2018-12-20 12:02:35");
INSERT INTO registro_acesso VALUES("1487","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-20 13:28:18");
INSERT INTO registro_acesso VALUES("1488","Admin","1","187.26.222.214","Google Chrome","71.0.3578.83","linux","2018-12-20 13:53:23");
INSERT INTO registro_acesso VALUES("1489","marcos","1","201.87.244.10","Google Chrome","71.0.3578.99","linux","2018-12-20 15:55:51");
INSERT INTO registro_acesso VALUES("1490","marcos","1","201.87.244.10","Google Chrome","71.0.3578.99","linux","2018-12-20 15:58:29");
INSERT INTO registro_acesso VALUES("1491","anderson81","1","168.121.112.22","Google Chrome","71.0.3578.99","linux","2018-12-20 19:19:49");
INSERT INTO registro_acesso VALUES("1492","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-20 19:58:24");
INSERT INTO registro_acesso VALUES("1493","lucy","1","177.125.36.76","Google Chrome","70.0.3538.80","linux","2018-12-20 20:34:25");
INSERT INTO registro_acesso VALUES("1494","caiquecs","1","201.75.171.63","Google Chrome","70.0.3538.80","linux","2018-12-20 20:52:59");
INSERT INTO registro_acesso VALUES("1495","lucy","2","177.125.36.76","Google Chrome","70.0.3538.80","linux","2018-12-20 21:01:42");
INSERT INTO registro_acesso VALUES("1496","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-20 22:04:16");
INSERT INTO registro_acesso VALUES("1497","messias","1","170.78.62.99","Google Chrome","71.0.3578.98","windows","2018-12-20 22:32:53");
INSERT INTO registro_acesso VALUES("1498","marcos","1","177.75.57.180","Google Chrome","71.0.3578.99","linux","2018-12-20 22:35:31");
INSERT INTO registro_acesso VALUES("1499","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-20 22:53:26");
INSERT INTO registro_acesso VALUES("1500","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-20 23:38:04");
INSERT INTO registro_acesso VALUES("1501","messias","1","170.78.62.99","Google Chrome","70.0.3538.110","linux","2018-12-21 11:45:46");
INSERT INTO registro_acesso VALUES("1502","Admin","1","177.58.244.7","Google Chrome","71.0.3578.83","linux","2018-12-21 12:29:19");
INSERT INTO registro_acesso VALUES("1503","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:45:12");
INSERT INTO registro_acesso VALUES("1504","vando","1","189.58.235.228","Google Chrome","71.0.3578.98","windows","2018-12-21 12:46:10");
INSERT INTO registro_acesso VALUES("1505","Admin","2","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:50:23");
INSERT INTO registro_acesso VALUES("1506","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:51:03");
INSERT INTO registro_acesso VALUES("1507","Admin","2","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:53:59");
INSERT INTO registro_acesso VALUES("1508","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:54:09");
INSERT INTO registro_acesso VALUES("1509","Admin","2","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:56:33");
INSERT INTO registro_acesso VALUES("1510","edinhocs","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-21 12:56:39");
INSERT INTO registro_acesso VALUES("1511","edinhocs","1","187.95.227.82","Google Chrome","59.0.3071.125","linux","2018-12-21 12:57:37");
INSERT INTO registro_acesso VALUES("1512","edinhocs","1","187.95.227.82","Google Chrome","59.0.3071.125","linux","2018-12-21 13:01:08");
INSERT INTO registro_acesso VALUES("1513","caiquecs","1","152.251.37.176","Google Chrome","70.0.3538.80","linux","2018-12-21 14:34:11");
INSERT INTO registro_acesso VALUES("1514","Admin","1","177.58.242.73","Google Chrome","71.0.3578.83","linux","2018-12-21 16:00:23");
INSERT INTO registro_acesso VALUES("1515","vando","1","189.58.235.228","Google Chrome","71.0.3578.98","windows","2018-12-21 16:15:11");
INSERT INTO registro_acesso VALUES("1516","caiquecs","1","177.79.24.233","Google Chrome","70.0.3538.80","linux","2018-12-21 18:29:04");
INSERT INTO registro_acesso VALUES("1517","messias","1","170.78.62.99","Google Chrome","71.0.3578.98","windows","2018-12-21 18:30:15");
INSERT INTO registro_acesso VALUES("1518","marco17","1","131.255.69.1","Google Chrome","59.0.3071.125","linux","2018-12-21 21:43:28");
INSERT INTO registro_acesso VALUES("1519","messias","1","170.247.114.165","Google Chrome","71.0.3578.98","windows","2018-12-21 22:16:33");
INSERT INTO registro_acesso VALUES("1520","vando","1","143.202.133.97","Google Chrome","71.0.3578.98","windows","2018-12-21 22:19:35");
INSERT INTO registro_acesso VALUES("1521","Admin","1","187.73.148.59","Google Chrome","71.0.3578.83","linux","2018-12-21 23:32:49");
INSERT INTO registro_acesso VALUES("1522","messias","1","170.247.114.165","Google Chrome","70.0.3538.110","linux","2018-12-22 00:17:12");
INSERT INTO registro_acesso VALUES("1523","vando","1","177.18.48.13","Google Chrome","71.0.3578.98","windows","2018-12-22 06:45:14");
INSERT INTO registro_acesso VALUES("1524","biju","1","177.22.178.5","Google Chrome","71.0.3578.98","linux","2018-12-22 12:22:05");
INSERT INTO registro_acesso VALUES("1525","Admin","1","187.73.148.59","Google Chrome","71.0.3578.99","linux","2018-12-22 13:21:06");
INSERT INTO registro_acesso VALUES("1526","marco17","1","187.26.171.91","Google Chrome","63.0.3239.111","linux","2018-12-22 13:36:13");
INSERT INTO registro_acesso VALUES("1527","vando","1","189.40.88.227","Google Chrome","71.0.3578.99","linux","2018-12-22 14:56:41");
INSERT INTO registro_acesso VALUES("1528","Admin","1","187.73.148.59","Google Chrome","71.0.3578.98","windows","2018-12-22 15:18:36");
INSERT INTO registro_acesso VALUES("1529","Admin","1","186.227.220.78","Google Chrome","71.0.3578.98","windows","2018-12-22 15:20:22");
INSERT INTO registro_acesso VALUES("1530","Admin","1","192.141.253.222","Google Chrome","71.0.3578.98","windows","2019-02-07 12:36:48");
INSERT INTO registro_acesso VALUES("1531","admin","1","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:01:16");
INSERT INTO registro_acesso VALUES("1532","admin","2","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:26:10");
INSERT INTO registro_acesso VALUES("1533","admin","1","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:26:18");
INSERT INTO registro_acesso VALUES("1534","admin","2","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:26:59");
INSERT INTO registro_acesso VALUES("1535","luiz01","1","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:27:19");
INSERT INTO registro_acesso VALUES("1536","luiz01","2","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:44:16");
INSERT INTO registro_acesso VALUES("1537","admin","1","138.97.42.94","Google Chrome","119.0.0.0","windows","2023-11-07 10:44:36");


DROP TABLE IF EXISTS server;

CREATE TABLE `server` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(250) DEFAULT NULL,
  `ip` mediumtext,
  `porta` mediumtext NOT NULL,
  `user` mediumtext NOT NULL,
  `senha` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS site_config;

CREATE TABLE `site_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `NomePainel` varchar(250) DEFAULT 'CSPainel',
  `LegendaPainel` varchar(250) DEFAULT 'Gerenciador de Painel',
  `TemaPainel` varchar(250) NOT NULL DEFAULT 'theme-default',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sms;

CREATE TABLE `sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `user` varchar(250) DEFAULT NULL,
  `senha` varchar(250) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO sms VALUES("1","Admin","Admin","12345678","N");


DROP TABLE IF EXISTS sms_modelo;

CREATE TABLE `sms_modelo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `tipo` varchar(250) DEFAULT 'Painel',
  `assunto` varchar(250) DEFAULT NULL,
  `mensagem` longtext,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS sms_preferencias;

CREATE TABLE `sms_preferencias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(250) DEFAULT NULL,
  `DadosDeAcesso` int(11) DEFAULT NULL,
  `DadosDeAcessoTeste` int(11) DEFAULT NULL,
  `Vencimento` int(11) DEFAULT NULL,
  `Renovacao` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS status_servidor;

CREATE TABLE `status_servidor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(11) NOT NULL DEFAULT 'N',
  `celular` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO status_servidor VALUES("1","S","(17) 99162-6615","bbcstvdigital@gmail.com");


DROP TABLE IF EXISTS suporte;

CREATE TABLE `suporte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `UserEmissor` varchar(250) DEFAULT NULL,
  `UserReceptor` varchar(250) DEFAULT NULL,
  `Assunto` varchar(250) DEFAULT NULL,
  `data` varchar(250) DEFAULT NULL,
  `anexo` varchar(250) DEFAULT NULL,
  `Mensagem` longtext,
  `LidaEmissor` varchar(11) NOT NULL DEFAULT 'N',
  `LidaReceptor` varchar(11) NOT NULL DEFAULT 'N',
  `PastaEmissor` int(11) NOT NULL DEFAULT '2',
  `PastaReceptor` int(11) NOT NULL DEFAULT '1',
  `Marcacao` int(11) NOT NULL DEFAULT '5',
  `Estrela` varchar(11) NOT NULL DEFAULT 'N',
  `ExcluirEmissor` varchar(11) NOT NULL DEFAULT 'N',
  `ExcluirReceptor` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS suporteresp;

CREATE TABLE `suporteresp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_suporte` int(11) DEFAULT NULL,
  `UserEmissor` varchar(250) DEFAULT NULL,
  `mensagem` longtext,
  `anexo` varchar(250) DEFAULT NULL,
  `data` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS tempoteste;

CREATE TABLE `tempoteste` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tempo` int(11) NOT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO tempoteste VALUES("2","2","N");
INSERT INTO tempoteste VALUES("3","1","N");


DROP TABLE IF EXISTS tempovencimento;

CREATE TABLE `tempovencimento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tempo` int(11) DEFAULT NULL,
  `bloqueado` varchar(11) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS urlteste;

CREATE TABLE `urlteste` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CadUser` varchar(2500) DEFAULT NULL,
  `status` varchar(11) NOT NULL DEFAULT 'N',
  `tempo` int(11) DEFAULT NULL,
  `cemail` varchar(11) NOT NULL DEFAULT 'N',
  `email` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO urlteste VALUES("1","vando","N","1","N","");
INSERT INTO urlteste VALUES("3","exclusiverio","S","1","N","");


DROP TABLE IF EXISTS versao;

CREATE TABLE `versao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versao` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO versao VALUES("1","2.8");


