/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CacheCoveragePlugin;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ClusteredCache;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.GHttpConstants;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.session.CacheDummySession;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.SimpleTlvBlob;
import com.bowman.cardserv.util.TimedAverageList;
import com.bowman.cardserv.web.FileFetcher;
import com.bowman.util.Base64Encoder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CacheForwarder
implements XmlConfigurable,
GHttpConstants {
    private static final int RETRY_WAIT = 2000;
    private static final int RECORD_SIZE = 28;
    private static final int MAX_QSIZE = 2000;
    private static final int INSTANCE_MAXAGE = 1200000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String CRLF = "\r\n";
    private FeederThread[] threads = new FeederThread[2];
    private TimedAverageList latency = new TimedAverageList(60);
    private TimedAverageList msgSize = new TimedAverageList(60);
    private Map remoteInstances = Collections.synchronizedMap(new HashMap());
    private final List singleQ = Collections.synchronizedList(new ArrayList());
    private final String name;
    private final CacheCoveragePlugin parent;
    private boolean ssl;
    private String host;
    private String prefix;
    private String passwd;
    private int port;
    private boolean connected;
    private boolean redundant;
    private int counter;
    private int reconnects;
    private int errors;
    private int ecmForwards;
    private int delayAlerts;
    private int filtered;
    private int maxDelay;
    private Set profiles;
    private long bytesOut;
    private long bytesIn;
    private TimedAverageList sentAvg = new TimedAverageList(10);
    private TimedAverageList recvAvg = new TimedAverageList(10);
    private CacheDummySession dummySession = new CacheDummySession(this);

    public CacheForwarder(CacheCoveragePlugin parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String urlStr = xml.getStringValue("url");
        try {
            URL url = new URL(urlStr);
            if (!url.getProtocol().startsWith("http")) {
                throw new ConfigException(xml.getFullName(), "url", "Non-http url: " + urlStr);
            }
            this.ssl = "https".equals(url.getProtocol());
            this.host = url.getHost();
            this.port = url.getPort();
            if (this.port == -1) {
                this.port = this.ssl ? 443 : 80;
            }
            this.prefix = url.getPath();
            if (this.prefix == null) {
                this.prefix = "";
            }
            if (!this.prefix.endsWith("/")) {
                this.prefix = this.prefix + "/";
            }
        }
        catch (MalformedURLException e) {
            throw new ConfigException(xml.getFullName(), "url", "Malformed url: " + urlStr);
        }
        if ("true".equalsIgnoreCase(xml.getStringValue("enabled", "true"))) {
            this.passwd = xml.getStringValue("password");
            this.redundant = "true".equalsIgnoreCase(xml.getStringValue("redundant-forwarding", "false"));
            this.maxDelay = xml.getTimeValue("max-delay", 200, "ms");
            String profileStr = xml.getStringValue("profiles", "").trim().toLowerCase();
            this.profiles = profileStr.length() > 0 ? new HashSet<String>(Arrays.asList(profileStr.split(" "))) : null;
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i] = new FeederThread(i);
                this.threads[i].start();
            }
        } else {
            this.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getAvgLatency() {
        return this.latency.getAverage(true);
    }

    public int getPeakLatency() {
        if (this.redundant) {
            return Math.min(this.threads[0].peakLatency, this.threads[1].peakLatency);
        }
        return Math.max(this.threads[0].peakLatency, this.threads[1].peakLatency);
    }

    public int getAvgMsgSize() {
        return this.msgSize.getAverage(true);
    }

    public int getPeakMsgSize() {
        return this.msgSize.getMaxValue();
    }

    public int getCount() {
        return this.counter;
    }

    public int getReconnects() {
        return this.reconnects;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getSendQSize() {
        if (this.redundant) {
            return this.threads[0].localQ.size() + this.threads[1].localQ.size();
        }
        return this.singleQ.size();
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public long getSentAvg() {
        return this.sentAvg.getTotal(true) / 10;
    }

    public long getRecvAvg() {
        return this.recvAvg.getTotal(true) / 10;
    }

    public int getEcmForwards() {
        return this.ecmForwards;
    }

    public int getDelayAlerts() {
        return this.delayAlerts;
    }

    public int getFiltered() {
        return this.filtered;
    }

    public Map getRemoteInstances() {
        long now = System.currentTimeMillis();
        Iterator iter = this.remoteInstances.keySet().iterator();
        while (iter.hasNext()) {
            String instance = (String)iter.next();
            Properties p = (Properties)this.remoteInstances.get(instance);
            long timeStamp = Long.parseLong(p.getProperty("tstamp"));
            if (now - timeStamp <= 1200000L) continue;
            iter.remove();
        }
        return this.remoteInstances;
    }

    private void sentBytes(int count) {
        this.bytesOut += (long)count;
        this.sentAvg.addRecord(count);
    }

    private void recvBytes(int count) {
        this.bytesIn += (long)count;
        this.recvAvg.addRecord(count);
    }

    public void close() {
        if (this.threads != null) {
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.threads[i] == null) continue;
                this.threads[i].interrupt();
            }
            this.threads = null;
        }
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardReply(CamdNetMessage req, CamdNetMessage reply) {
        if (this.threads != null && this.connected && reply.getDataLength() == 16) {
            if (!(this.profiles == null || req.getProfileName() != null && this.profiles.contains(req.getProfileName().toLowerCase()))) {
                ++this.filtered;
                return;
            }
            if (this.redundant) {
                this.forwardRedundant(req, reply);
            } else {
                List list = this.singleQ;
                synchronized (list) {
                    if (this.singleQ.size() > 2000) {
                        this.singleQ.clear();
                        this.parent.logger.warning("CacheForwarder[" + this.name + "] discarding sendQ, no working connections?");
                    }
                    this.singleQ.add(new RequestReplyPair(req, reply));
                    this.singleQ.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardRedundant(CamdNetMessage req, CamdNetMessage reply) {
        for (int i = 0; i < this.threads.length; ++i) {
            List list = this.threads[i].localQ;
            synchronized (list) {
                if (this.threads[i].localQ.size() > 2000) {
                    this.threads[i].localQ.clear();
                    this.parent.logger.warning("CacheForwarder[" + this.name + "] discarding sendQ, no working connections?");
                }
                this.threads[i].localQ.add(new RequestReplyPair(req, reply));
                this.threads[i].localQ.notifyAll();
                continue;
            }
        }
    }

    private class FeederThread
    extends Thread {
        private final List localQ;
        private Socket conn;
        private DataOutputStream dos;
        private BufferedReader br;
        private String sessionId;
        protected int peakLatency;

        public FeederThread(int i) {
            super("GHttpFeederThread-" + i);
            this.localQ = Collections.synchronizedList(new ArrayList());
        }

        private void initConn() throws IOException {
            this.conn = CacheForwarder.this.ssl ? FileFetcher.socketFactory.createSocket() : new Socket();
            this.conn.connect(new InetSocketAddress(CacheForwarder.this.host, CacheForwarder.this.port), 10000);
            this.dos = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
            this.br = new BufferedReader(new InputStreamReader(this.conn.getInputStream(), "ISO-8859-1"));
            CacheForwarder.this.connected = true;
        }

        private void httpPost(List sendQ) throws IOException {
            CacheForwarder.this.counter++;
            long start = System.currentTimeMillis();
            int size = this.dos.size();
            String path = "api/f/" + (this.sessionId == null ? "" : this.sessionId);
            this.dos.writeBytes("POST " + CacheForwarder.this.prefix + path + " HTTP/1.1" + CacheForwarder.CRLF);
            this.dos.writeBytes("Host: " + CacheForwarder.this.host + CacheForwarder.CRLF);
            this.dos.writeBytes("Content-Length: " + 28 * sendQ.size() + CacheForwarder.CRLF);
            if (this.sessionId == null) {
                String auth = Integer.toHexString(ProxyConfig.getInstance().getProxyOriginId()) + ":" + CacheForwarder.this.passwd;
                auth = new String(Base64Encoder.encode((byte[])auth.getBytes("ISO-8859-1")));
                this.dos.writeBytes("Authorization: Basic " + auth + CacheForwarder.CRLF);
            }
            this.dos.writeBytes(CacheForwarder.CRLF);
            CacheForwarder.this.msgSize.addRecord(sendQ.size());
            Iterator iter = sendQ.iterator();
            while (iter.hasNext()) {
                RequestReplyPair pair = (RequestReplyPair)iter.next();
                ClusteredCache.writeCacheReq((DataOutputStream)this.dos, (CamdNetMessage)pair.request, (boolean)false);
                ClusteredCache.writeCacheRpl((DataOutputStream)this.dos, (CamdNetMessage)pair.reply, (boolean)false);
            }
            this.dos.flush();
            CacheForwarder.this.sentBytes(this.dos.size() - size);
            String resp = this.br.readLine();
            if (resp == null) {
                ((CacheForwarder)CacheForwarder.this).parent.logger.warning("CacheForwarder[" + CacheForwarder.this.name + "] connection closed after post.");
                this.handleError(sendQ, true);
                return;
            }
            HttpReply reply = new HttpReply(resp);
            do {
                reply.addHeader(this.br.readLine());
            } while (!reply.headerEnd);
            if ("chunked".equalsIgnoreCase(reply.getHeader("Transfer-Encoding"))) {
                String line;
                StringBuffer sb = new StringBuffer();
                do {
                    line = this.br.readLine();
                    sb.append(line).append(CacheForwarder.CRLF);
                } while (!"".equals(line));
                reply.body = sb.toString().toCharArray();
            } else {
                reply.body = new char[reply.getContentLength()];
                if (this.br.read(reply.body) != reply.body.length) {
                    throw new IOException("Assertation failed");
                }
            }
            CacheForwarder.this.recvBytes(reply.getSize());
            String sessionCookie = reply.getCookie("GSSID");
            if (sessionCookie != null) {
                this.sessionId = sessionCookie;
            }
            switch (reply.code) {
                case 200: 
                case 204: {
                    sendQ.clear();
                    int time = (int)(System.currentTimeMillis() - start);
                    if (time > this.peakLatency) {
                        this.peakLatency = time;
                    }
                    CacheForwarder.this.latency.addRecord(time);
                    if (reply.body.length <= 0) break;
                    this.handleReply(reply.getContentAsTlv());
                    break;
                }
                case 401: {
                    ((CacheForwarder)CacheForwarder.this).parent.logger.warning("CacheForwarder[" + CacheForwarder.this.name + "] session expired.");
                    this.sessionId = null;
                    break;
                }
                case 400: {
                    ((CacheForwarder)CacheForwarder.this).parent.logger.warning("CacheForwarder[" + CacheForwarder.this.name + "] received bad request error, disabling: " + reply.getContentAsString());
                    CacheForwarder.this.close();
                    return;
                }
                case 403: {
                    ((CacheForwarder)CacheForwarder.this).parent.logger.warning("CacheForwarder[" + CacheForwarder.this.name + "] invalid password, disabling.");
                    CacheForwarder.this.close();
                    return;
                }
                default: {
                    ((CacheForwarder)CacheForwarder.this).parent.logger.warning("CacheForwarder[" + CacheForwarder.this.name + "] received error reply: " + resp);
                    this.handleError(sendQ, true);
                }
            }
        }

        void handleReply(SimpleTlvBlob tb) {
            String instance = null;
            Iterator iter = tb.keySet().iterator();
            block10: while (iter.hasNext()) {
                int key = (Integer)iter.next();
                switch (key) {
                    case 0: {
                        instance = new String(tb.getSingle(key));
                        break;
                    }
                    case 3: {
                        Properties p = new Properties();
                        p.setProperty("tstamp", String.valueOf(System.currentTimeMillis()));
                        int[] stats = tb.getIntArray(key);
                        for (int i = 0; i < stats.length; ++i) {
                            p.setProperty(GHttpConstants.STAT_KEYS[i], String.valueOf(stats[i]));
                        }
                        if (CacheForwarder.this.remoteInstances.put(instance, p) != null) continue block10;
                        ((CacheForwarder)CacheForwarder.this).parent.logger.fine("CacheForwarder[" + CacheForwarder.this.name + "] encountered new remote instance: " + instance + " (" + CacheForwarder.this.getRemoteInstances().size() + ")");
                        break;
                    }
                    case 1: {
                        List ecms = tb.get(key);
                        ((CacheForwarder)CacheForwarder.this).parent.logger.fine("CacheForwarder[" + CacheForwarder.this.name + "] received " + ecms.size() + " ecm requests...");
                        Iterator i = ecms.iterator();
                        while (i.hasNext()) {
                            try {
                                CamdNetMessage ecmReq = CamdNetMessage.parseGHttpReq((DataInputStream)new DataInputStream(new ByteArrayInputStream((byte[])i.next())), (String)this.conn.getInetAddress().getHostAddress(), (boolean)false);
                                ecmReq.setNetworkId(40999);
                                System.out.println(ecmReq.hashCodeStr());
                                ((CacheForwarder)CacheForwarder.this).parent.proxy.messageReceived((ProxySession)CacheForwarder.this.dummySession, ecmReq);
                                CacheForwarder.this.ecmForwards++;
                            }
                            catch (IOException e) {
                                ((CacheForwarder)CacheForwarder.this).parent.logger.throwing((Throwable)e);
                            }
                        }
                        continue block10;
                    }
                    case 2: {
                        if (!(((CacheForwarder)CacheForwarder.this).parent.cache instanceof ClusteredCache)) continue block10;
                        List delayed = tb.get(key);
                        ((CacheForwarder)CacheForwarder.this).parent.logger.fine("CacheForwarder[" + CacheForwarder.this.name + "] received " + delayed.size() + " cache requests for resend...");
                        Iterator i = delayed.iterator();
                        while (i.hasNext()) {
                            try {
                                CamdNetMessage req = CamdNetMessage.parseCacheReq((DataInputStream)new DataInputStream(new ByteArrayInputStream((byte[])i.next())), (boolean)false);
                                ((ClusteredCache)((CacheForwarder)CacheForwarder.this).parent.cache).delayAlert(-1, req, false, -1L);
                                CacheForwarder.this.delayAlerts++;
                            }
                            catch (IOException e) {
                                ((CacheForwarder)CacheForwarder.this).parent.logger.throwing((Throwable)e);
                            }
                        }
                        continue block10;
                    }
                    default: {
                        ((CacheForwarder)CacheForwarder.this).parent.logger.fine("CacheForwarder[" + CacheForwarder.this.name + "] received unknown TLV field in reply: " + key);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList myQ = new ArrayList();
            while (CacheForwarder.this.threads != null) {
                try {
                    List list;
                    if (this.conn == null) {
                        this.initConn();
                    }
                    if (CacheForwarder.this.redundant) {
                        list = this.localQ;
                        synchronized (list) {
                            while (this.localQ.isEmpty()) {
                                this.localQ.wait();
                            }
                            if (!this.localQ.isEmpty()) {
                                myQ.addAll(this.localQ);
                                this.localQ.clear();
                            }
                        }
                    }
                    list = CacheForwarder.this.singleQ;
                    synchronized (list) {
                        while (CacheForwarder.this.singleQ.isEmpty()) {
                            CacheForwarder.this.singleQ.wait();
                        }
                        if (!CacheForwarder.this.singleQ.isEmpty()) {
                            myQ.addAll(CacheForwarder.this.singleQ);
                            CacheForwarder.this.singleQ.clear();
                        }
                    }
                    if (myQ.isEmpty()) continue;
                    try {
                        this.httpPost(myQ);
                        if (CacheForwarder.this.maxDelay <= 0) continue;
                        Thread.sleep(CacheForwarder.this.maxDelay);
                    }
                    catch (SocketException se) {
                        ((CacheForwarder)CacheForwarder.this).parent.logger.throwing((Throwable)se);
                        this.initConn();
                        CacheForwarder.this.reconnects++;
                    }
                }
                catch (IOException e) {
                    ((CacheForwarder)CacheForwarder.this).parent.logger.warning("CacheForwarder[" + CacheForwarder.this.name + "] disconnected: " + e);
                    ((CacheForwarder)CacheForwarder.this).parent.logger.throwing((Throwable)e);
                    e.printStackTrace();
                    this.handleError(myQ, false);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        private void handleError(List sendQ, boolean disconnect) {
            if (!sendQ.isEmpty()) {
                this.localQ.addAll(sendQ);
                sendQ.clear();
            }
            CacheForwarder.this.errors++;
            if (disconnect) {
                this.disconnect();
            } else {
                this.conn = null;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }

        public void disconnect() {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.conn = null;
            }
        }

        public void interrupt() {
            this.disconnect();
            super.interrupt();
        }
    }

    private static class HttpReply {
        int code;
        int hdrSize;
        String msg;
        Properties headers = new Properties();
        Properties cookies = new Properties();
        char[] body;
        boolean headerEnd;

        private HttpReply(String line) {
            this.hdrSize += line.length() + 2;
            String[] s = line.split(" ");
            this.code = Integer.parseInt(s[1]);
            this.msg = s[2];
        }

        void addHeader(String line) {
            this.hdrSize += line.length() + 2;
            if ("".equals(line)) {
                this.headerEnd = true;
            } else {
                String[] s = line.split(": ");
                this.headers.setProperty(s[0], s[1]);
                if (s[0].equals("Set-Cookie")) {
                    s = s[1].split("=");
                    this.cookies.setProperty(s[0], s[1]);
                }
            }
        }

        String getCookie(String name) {
            return this.cookies.getProperty(name);
        }

        String getHeader(String name) {
            return this.headers.getProperty(name);
        }

        int getContentLength() {
            return Integer.parseInt(this.headers.getProperty("Content-Length", "-1"));
        }

        String getContentType() {
            return this.headers.getProperty("Content-Type");
        }

        String getContentAsString() {
            return new String(this.body);
        }

        SimpleTlvBlob getContentAsTlv() {
            try {
                return new SimpleTlvBlob(this.getContentAsString().getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }

        int getSize() {
            return this.hdrSize + this.body.length;
        }
    }

    private static class RequestReplyPair {
        CamdNetMessage request;
        CamdNetMessage reply;

        private RequestReplyPair(CamdNetMessage request, CamdNetMessage reply) {
            this.request = request;
            this.reply = reply;
        }
    }
}

