/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc;

import com.bowman.irc.IrcServerInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IrcConnInfo {
    private IrcServerInfo bouncer;
    private boolean useBouncer = false;
    private String bncPass;
    private String nick;
    private String altNick;
    private String ident;
    private String name;
    private String realName;
    private Hashtable servers;
    private Vector channels;
    private Vector serverHosts;
    private Enumeration servEnum;

    public IrcConnInfo(String nick, String server, int port) {
        this(nick, nick + "_", nick, server, port);
    }

    public IrcConnInfo(String nick, String altNick, String name, String server, int port) {
        this(nick, altNick, name);
        this.addServer(server, port);
    }

    public IrcConnInfo(String nick, String altNick, String name) {
        this.nick = nick;
        this.altNick = altNick;
        this.name = name;
        this.servers = new Hashtable();
        this.serverHosts = new Vector();
        this.channels = new Vector();
    }

    public void addServer(String server, int port) {
        this.addServer(server, new int[]{port});
    }

    public void addServer(String server, int[] ports) {
        this.serverHosts.addElement(server.toLowerCase());
        this.servers.put(server, new IrcServerInfo(server.toLowerCase(), ports));
    }

    public void setBouncer(String server, int port, String pass) {
        this.bouncer = new IrcServerInfo(server, port);
        this.bncPass = pass;
        this.useBouncer = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChannel(String channel) {
        if (!channel.startsWith("#")) {
            channel = "#" + channel;
        }
        if (!this.channels.contains(channel)) {
            this.channels.addElement(channel);
        }
    }

    public void removeChannel(String channel) {
        if (!channel.startsWith("#")) {
            channel = "#" + channel;
        }
        this.channels.removeElement(channel);
    }

    public IrcServerInfo getServer() {
        if (this.servEnum == null) {
            this.servEnum = this.serverHosts.elements();
        }
        if (!this.servEnum.hasMoreElements()) {
            this.servEnum = this.serverHosts.elements();
            return null;
        }
        return (IrcServerInfo)this.servers.get(this.servEnum.nextElement());
    }

    public boolean moveServerToTop(String host) {
        if (this.serverHosts.contains(host = host.toLowerCase())) {
            this.serverHosts.removeElement(host);
            this.serverHosts.insertElementAt(host, 0);
            this.servEnum = this.serverHosts.elements();
            return true;
        }
        return false;
    }

    public boolean disableServer(String host) {
        if (this.serverHosts.contains(host = host.toLowerCase())) {
            this.serverHosts.removeElement(host);
            return true;
        }
        return false;
    }

    public boolean enableServer(String host) {
        if (this.servers.containsKey(host = host.toLowerCase())) {
            this.serverHosts.addElement(host);
            return true;
        }
        return false;
    }

    public Enumeration getServers() {
        return this.servers.elements();
    }

    public Enumeration getChannels() {
        return this.channels.elements();
    }

    public String getAltNick() {
        return this.altNick;
    }

    public void setAltNick(String altNick) {
        this.altNick = altNick;
    }

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public String getName() {
        return this.name;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }
}

