/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class TelnetDaemonConnection {
    private static final int IAC = 255;
    private static final int GA = 249;
    private static final int WILL = 251;
    private static final int WONT = 252;
    private static final int DO = 253;
    private static final int DONT = 254;
    private static final int SB = 250;
    private static final int SE = 240;
    private static final int NOP = 241;
    private static final int DM = 242;
    private static final int BRK = 243;
    private static final int IP = 244;
    private static final int AO = 245;
    private static final int AYT = 246;
    private static final int EC = 247;
    private static final int EL = 248;
    private static final int ECHO = 1;
    private static final int SUPGA = 3;
    private static final int NAWS = 31;
    private static final int TTYPE = 24;
    private static final int IS = 0;
    private static final int SEND = 1;
    private static final int LOGOUT = 18;
    private static final int SMALLEST_BELIEVABLE_WIDTH = 20;
    private static final int SMALLEST_BELIEVABLE_HEIGHT = 6;
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_HEIGHT = 25;
    private Socket conn;
    private DataOutputStream outstream;
    private DataInputStream instream;
    private IACHandler iach;
    private InetAddress localAddy;
    private boolean NOIAC = false;
    private boolean initializing;
    private boolean closing;
    private boolean cr;
    private boolean nl;

    public TelnetDaemonConnection(Socket conn) {
        try {
            this.iach = new IACHandler();
            this.instream = new DataInputStream(conn.getInputStream());
            this.outstream = new DataOutputStream(new BufferedOutputStream(conn.getOutputStream()));
            this.closing = false;
            this.cr = false;
            this.initTelnetCommunication();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(byte b) {
        try {
            if (!this.cr && b == 10) {
                this.outstream.write(13);
            }
            if (this.cr && b != 10) {
                this.outstream.write(10);
            }
            this.outstream.write(b);
            this.cr = b == 13;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(int i) {
        this.write((byte)i);
    }

    public void write(byte[] sequence) {
        for (int i = 0; i < sequence.length; ++i) {
            this.write(sequence[i]);
        }
    }

    public void write(int[] sequence) {
        for (int i = 0; i < sequence.length; ++i) {
            this.write((byte)sequence[i]);
        }
    }

    public void write(char ch) {
        this.write((byte)ch);
    }

    public void write(String str) {
        this.write(str.getBytes());
    }

    public void flush() {
        try {
            this.outstream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeOutput() {
        this.closing = true;
        this.write(255);
        this.write(253);
        this.write(18);
        try {
            this.outstream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int read() {
        int c = this.rawread();
        this.NOIAC = false;
        while (c == 255 && !this.NOIAC) {
            c = this.rawread();
            if (c != 255) {
                this.iach.handleC(c);
                c = this.rawread();
                continue;
            }
            this.NOIAC = true;
        }
        return c;
    }

    public void closeInput() {
        try {
            this.instream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int read16int() {
        try {
            int c = this.instream.readUnsignedShort();
            return c;
        }
        catch (EOFException e) {
            return -2;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int rawread() {
        int b = 0;
        try {
            b = this.instream.readUnsignedByte();
            return b;
        }
        catch (EOFException e) {
            return -2;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int stripCRSeq(int input) {
        if (input == 13) {
            this.rawread();
            return 10;
        }
        return input;
    }

    private void initTelnetCommunication() {
        this.initializing = true;
        try {
            this.iach.doInit();
            int i = this.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializing = false;
    }

    private void IamHere() {
        this.write("[" + this.localAddy.toString() + ":Yes]");
        this.flush();
    }

    private void setTerminalGeometry(int width, int height) {
        if (width < 20) {
            width = 80;
        }
        if (height < 6) {
            height = 25;
        }
    }

    private class IACHandler {
        private int c = 0;
        private boolean UNDEFINED = false;
        private boolean SUPPORTED = false;
        private boolean DO_ECHO = false;
        private boolean DO_SUPGA = false;
        private boolean DO_NAWS = false;
        private boolean DO_TTYPE = false;
        private String subnstring;
        private String terminalStr;
        private int[] buffer = new int[2];
        private byte[] sendbuffer;
        private boolean WAIT_DO_REPLY_SUPGA = false;
        private boolean WAIT_DO_REPLY_ECHO = false;
        private boolean WAIT_DO_REPLY_NAWS = false;
        private boolean WAIT_DO_REPLY_TTYPE = false;
        private boolean WAIT_WILL_REPLY_SUPGA = false;
        private boolean WAIT_WILL_REPLY_ECHO = false;
        private boolean WAIT_WILL_REPLY_NAWS = false;
        private boolean WAIT_WILL_REPLY_TTYPE = false;
        private int width = 0;
        private int height = 0;

        private IACHandler() {
        }

        public void handleC(int i) {
            this.buffer[0] = i;
            if (!this.parseTWO(this.buffer)) {
                this.buffer[1] = TelnetDaemonConnection.this.rawread();
                this.parse(this.buffer);
            }
            this.buffer[0] = 0;
            this.buffer[1] = 0;
        }

        public void doInit() {
            this.sendCommand(251, 1, true);
            this.sendCommand(254, 1, true);
            this.sendCommand(253, 31, true);
            this.sendCommand(251, 3, true);
            this.sendCommand(253, 3, true);
            this.sendCommand(253, 24, true);
            this.getTTYPE();
        }

        private boolean parseTWO(int[] buffer) {
            switch (buffer[0]) {
                case 255: {
                    break;
                }
                case 246: {
                    TelnetDaemonConnection.this.IamHere();
                    break;
                }
                case 244: 
                case 245: 
                case 247: 
                case 248: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void parse(int[] buffer) {
            block0 : switch (buffer[0]) {
                case 251: {
                    if (this.supported(buffer[1]) && this.isEnabled(buffer[1])) break;
                    if (this.waitDOreply(buffer[1]) && this.supported(buffer[1])) {
                        this.enable(buffer[1]);
                        this.setWait(253, buffer[1], false);
                        break;
                    }
                    if (this.supported(buffer[1])) {
                        this.sendCommand(253, buffer[1], false);
                        this.enable(buffer[1]);
                        break;
                    }
                    this.sendCommand(254, buffer[1], false);
                    break;
                }
                case 252: {
                    if (this.waitDOreply(buffer[1]) && this.supported(buffer[1])) {
                        this.setWait(253, buffer[1], false);
                        break;
                    }
                    if (!this.supported(buffer[1]) || !this.isEnabled(buffer[1])) break;
                    this.enable(buffer[1]);
                    break;
                }
                case 253: {
                    if (this.supported(buffer[1]) && this.isEnabled(buffer[1])) break;
                    if (this.waitWILLreply(buffer[1]) && this.supported(buffer[1])) {
                        this.enable(buffer[1]);
                        this.setWait(251, buffer[1], false);
                        break;
                    }
                    if (this.supported(buffer[1])) {
                        this.sendCommand(251, buffer[1], false);
                        this.enable(buffer[1]);
                        break;
                    }
                    this.sendCommand(252, buffer[1], false);
                    break;
                }
                case 254: {
                    if (this.waitWILLreply(buffer[1]) && this.supported(buffer[1])) {
                        this.setWait(251, buffer[1], false);
                        break;
                    }
                    if (!this.supported(buffer[1]) || !this.isEnabled(buffer[1])) break;
                    this.enable(buffer[1]);
                    break;
                }
                case 242: {
                    break;
                }
                case 250: {
                    if (!this.supported(buffer[1]) || !this.isEnabled(buffer[1])) break;
                    switch (buffer[1]) {
                        case 31: {
                            this.handleNAWS();
                            break block0;
                        }
                        case 24: {
                            this.handleTTYPE();
                            break block0;
                        }
                    }
                }
            }
        }

        private String readIACSETerminatedString() {
            int where = 0;
            char[] buffer = new char[40];
            int b = 32;
            boolean cont = true;
            do {
                int i = TelnetDaemonConnection.this.rawread();
                switch (i) {
                    case 255: {
                        i = TelnetDaemonConnection.this.rawread();
                        if (i != 240) break;
                        cont = false;
                        break;
                    }
                    case -1: {
                        return new String("default");
                    }
                }
                if (!cont) continue;
                b = (char)i;
                if (b == 10 || b == 13) {
                    cont = false;
                    continue;
                }
                buffer[where++] = b;
            } while (cont);
            return new String(buffer, 0, where);
        }

        private void handleNAWS() {
            this.width = TelnetDaemonConnection.this.read16int();
            if (this.width == 255) {
                this.width = TelnetDaemonConnection.this.read16int();
            }
            this.height = TelnetDaemonConnection.this.read16int();
            if (this.height == 255) {
                this.height = TelnetDaemonConnection.this.read16int();
            }
            if (TelnetDaemonConnection.this.rawread() != 255 && TelnetDaemonConnection.this.rawread() != 240) {
                TelnetDaemonConnection.this.setTerminalGeometry(this.width, this.height);
            }
        }

        private void handleTTYPE() {
            String tmpstr = "";
            TelnetDaemonConnection.this.rawread();
            tmpstr = this.readIACSETerminatedString();
        }

        public void getTTYPE() {
            if (this.isEnabled(24)) {
                TelnetDaemonConnection.this.write(255);
                TelnetDaemonConnection.this.write(250);
                TelnetDaemonConnection.this.write(24);
                TelnetDaemonConnection.this.write(1);
                TelnetDaemonConnection.this.write(255);
                TelnetDaemonConnection.this.write(240);
                TelnetDaemonConnection.this.flush();
            }
        }

        private boolean supported(int i) {
            switch (i) {
                case 1: 
                case 3: 
                case 24: 
                case 31: {
                    return true;
                }
            }
            return false;
        }

        private void sendCommand(int i, int j, boolean localInit) {
            TelnetDaemonConnection.this.write(255);
            TelnetDaemonConnection.this.write(i);
            TelnetDaemonConnection.this.write(j);
            if (i == 253 && localInit) {
                this.setWait(253, j, true);
            }
            if (i == 251 && localInit) {
                this.setWait(251, j, true);
            }
            TelnetDaemonConnection.this.flush();
        }

        private void enable(int i) {
            switch (i) {
                case 3: {
                    if (this.DO_SUPGA) {
                        this.DO_SUPGA = false;
                        break;
                    }
                    this.DO_SUPGA = true;
                    break;
                }
                case 1: {
                    if (this.DO_ECHO) {
                        this.DO_ECHO = false;
                        break;
                    }
                    this.DO_ECHO = true;
                    break;
                }
                case 31: {
                    if (this.DO_NAWS) {
                        this.DO_NAWS = false;
                        break;
                    }
                    this.DO_NAWS = true;
                    break;
                }
                case 24: {
                    if (this.DO_TTYPE) {
                        this.DO_TTYPE = false;
                        break;
                    }
                    this.DO_TTYPE = true;
                    this.getTTYPE();
                }
            }
        }

        private boolean isEnabled(int i) {
            switch (i) {
                case 3: {
                    return this.DO_SUPGA;
                }
                case 1: {
                    return this.DO_ECHO;
                }
                case 31: {
                    return this.DO_NAWS;
                }
                case 24: {
                    return this.DO_TTYPE;
                }
            }
            return false;
        }

        private boolean waitWILLreply(int i) {
            switch (i) {
                case 3: {
                    return this.WAIT_WILL_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_WILL_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_WILL_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_WILL_REPLY_TTYPE;
                }
            }
            return false;
        }

        private boolean waitDOreply(int i) {
            switch (i) {
                case 3: {
                    return this.WAIT_DO_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_DO_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_DO_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_DO_REPLY_TTYPE;
                }
            }
            return false;
        }

        private void setWait(int WHAT, int OPTION, boolean WAIT) {
            switch (WHAT) {
                case 253: {
                    switch (OPTION) {
                        case 3: {
                            this.WAIT_DO_REPLY_SUPGA = WAIT;
                        }
                        case 1: {
                            this.WAIT_DO_REPLY_ECHO = WAIT;
                        }
                        case 31: {
                            this.WAIT_DO_REPLY_NAWS = WAIT;
                        }
                        case 24: {
                            this.WAIT_DO_REPLY_TTYPE = WAIT;
                        }
                    }
                    break;
                }
                case 251: {
                    switch (OPTION) {
                        case 3: {
                            this.WAIT_WILL_REPLY_SUPGA = WAIT;
                        }
                        case 1: {
                            this.WAIT_WILL_REPLY_ECHO = WAIT;
                        }
                        case 31: {
                            this.WAIT_WILL_REPLY_NAWS = WAIT;
                        }
                        case 24: {
                            this.WAIT_WILL_REPLY_TTYPE = WAIT;
                        }
                    }
                }
            }
        }
    }
}

