/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.rmi.AbstractStatus;
import com.bowman.cardserv.rmi.SessionStatus;
import com.bowman.cardserv.tv.TvService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserStatus
extends AbstractStatus
implements Serializable {
    private static final long serialVersionUID = -4091190186183181716L;
    private final String userName;
    private final String displayName;
    private final String startDate;
    private final String expireDate;
    private final boolean admin;
    private final int maxSessions;
    private final List sessions = new ArrayList();

    public UserStatus(String userName, String displayName, String startDate, String expireDate, int maxSessions, boolean admin) {
        this.userName = userName;
        this.displayName = displayName;
        this.admin = admin;
        this.startDate = startDate;
        this.expireDate = expireDate;
        this.maxSessions = maxSessions;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public int getSessionCount(String profileName) {
        if (profileName == null) {
            return this.sessions.size();
        }
        int count = 0;
        Iterator iter = this.sessions.iterator();
        while (iter.hasNext()) {
            if (!profileName.equals(((SessionStatus)iter.next()).getProfileName())) continue;
            ++count;
        }
        return count;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    void addSession(ProxySession session) {
        this.sessions.add(new SessionStatus(session));
    }

    public TvService[] getServices() {
        if (this.sessions == null || this.sessions.isEmpty()) {
            return new TvService[0];
        }
        TvService[] services = new TvService[this.sessions.size()];
        for (int i = 0; i < services.length; ++i) {
            services[i] = ((SessionStatus)this.sessions.get(i)).getCurrentService();
        }
        return services;
    }

    public String[] getRemoteHosts() {
        if (this.sessions == null || this.sessions.isEmpty()) {
            return new String[0];
        }
        String[] hosts = new String[this.sessions.size()];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = ((SessionStatus)this.sessions.get(i)).getRemoteHost();
        }
        return hosts;
    }

    public SessionStatus[] getSessions() {
        if (this.sessions == null || this.sessions.isEmpty()) {
            return new SessionStatus[0];
        }
        return this.sessions.toArray(new SessionStatus[this.sessions.size()]);
    }
}

