/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.session.AbstractSession;
import com.bowman.cardserv.session.SessionManager;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;

public class RadegastSession
extends AbstractSession {
    private Socket conn;
    private DataInputStream is;
    private BufferedOutputStream os;
    private int caId;

    public RadegastSession(Socket conn, ListenPort listenPort, CamdMessageListener listener) {
        super(listenPort, listener);
        this.conn = conn;
        this.sessionThread = new Thread((Runnable)this, "RadegastSessionThread-" + this.sessionId);
        this.sessionThread.start();
    }

    public void run() {
        this.logger.fine("Starting...");
        this.alive = true;
        this.remoteAddress = this.conn.getInetAddress().getHostAddress();
        int originId = ProxyConfig.getInstance().getProxyOriginId();
        boolean first = true;
        try {
            this.is = new DataInputStream(this.conn.getInputStream());
            this.os = new BufferedOutputStream(this.conn.getOutputStream());
            Thread.currentThread().setName(Thread.currentThread().getName() + "[" + this.getUser() + "]");
            while (this.alive) {
                boolean checksOk;
                CamdNetMessage msg = this.readMessage();
                if (msg == null) {
                    this.alive = false;
                    this.logger.info("Connection closed");
                    continue;
                }
                msg.setOriginId(originId);
                if (first) {
                    if ("0.0.0.0".equals(this.getRemoteAddress())) {
                        this.close();
                        return;
                    }
                    SessionManager.getInstance().addSession(this);
                    first = false;
                }
                checksOk = (checksOk = this.checkLimits(msg)) && this.handleMessage(msg);
                this.fireCamdMessage(msg, false);
                if (checksOk) continue;
                this.setFlag(msg, 'B');
                if (!this.isConnected()) continue;
                this.sendEcmReply(msg, msg.getEmptyReply());
            }
        }
        catch (Exception e) {
            this.logger.throwing("Exception reading/parsing message: " + e, e);
            this.alive = false;
        }
        this.endSession();
    }

    private boolean handleMessage(CamdNetMessage msg) {
        CaProfile profile = this.getProfile();
        if (profile.getCaId() != msg.getCaId()) {
            msg.setFilteredBy("Wrong ca-id in request: " + DESUtil.intToHexString(msg.getCaId(), 4) + " (expected: " + DESUtil.intToHexString(profile.getCaId(), 4) + ")");
            return false;
        }
        if (!profile.getProviderSet().contains(new Integer(msg.getProviderIdent()))) {
            msg.setFilteredBy("Unknown provider-ident in request: " + DESUtil.intToByteString(msg.getProviderIdent(), 3));
            return false;
        }
        return true;
    }

    CamdNetMessage readMessage() throws IOException {
        int i = this.is.read();
        if (i == -1) {
            return null;
        }
        if (i != 1) {
            throw new IOException("Unexpected header byte from rdg client: " + i);
        }
        i = this.is.read();
        byte[] buf = new byte[i];
        this.is.readFully(buf);
        this.logger.finer("Received message: " + DESUtil.bytesToString(buf));
        int commandTag = -1;
        int sid = 0;
        int caId = 0;
        byte[] providerId = new byte[8];
        byte[] keyNr = new byte[4];
        byte[] caData = null;
        block8: for (int n = 0; n < buf.length; ++n) {
            switch (buf[n]) {
                case 2: 
                case 8: 
                case 9: 
                case 16: {
                    ++n;
                    n += buf[n];
                    continue block8;
                }
                case 10: {
                    if (buf[++n] != 2) {
                        throw new IOException("Unexpected caid length: " + buf[2]);
                    }
                    caId = (buf[n + 1] & 0xFF) * 256 + (buf[n + 2] & 0xFF);
                    n += buf[n];
                    continue block8;
                }
                case 6: {
                    if (buf[++n] != 8) {
                        throw new IOException("Unexpected providerid length: " + buf[n]);
                    }
                    System.arraycopy(buf, n + 1, providerId, 0, 8);
                    n += buf[n];
                    continue block8;
                }
                case 7: {
                    if (buf[++n] != 4) {
                        throw new IOException("Unexpected keynr length: " + buf[n]);
                    }
                    System.arraycopy(buf, n + 1, keyNr, 0, 4);
                    n += buf[n];
                    continue block8;
                }
                case 3: {
                    commandTag = buf[++n + 1] & 0xFF;
                    int len = buf[n] & 0xFF;
                    caData = new byte[len - 3];
                    System.arraycopy(buf, n + 4, caData, 0, caData.length);
                    n += caData.length + 3;
                    continue block8;
                }
                case 33: {
                    ++n;
                    if (!"false".equalsIgnoreCase(this.listenPort.getStringProperty("sid-in-0x21"))) {
                        if (buf[n] != 2) {
                            this.logger.fine("Radegast field 0x21 is " + buf[n] + " bytes, expected 2 for sid (ignoring).");
                        } else {
                            sid |= (buf[n + 1] & 0xFF) << 8;
                            sid |= buf[n + 2] & 0xFF;
                        }
                    }
                    n += buf[n];
                    continue block8;
                }
                default: {
                    this.logger.fine("Unknown radegast field @ offset " + n + ": " + DESUtil.byteToString(buf[n]) + " len: " + buf[n + 1] + " data: " + DESUtil.bytesToString(buf, n + 2, buf[n + 1]));
                    ++n;
                    n += buf[n];
                }
            }
        }
        if (commandTag == -1) {
            throw new IOException("Bad radegast request: " + DESUtil.bytesToString(buf));
        }
        byte[] full = new byte[buf.length + 2];
        full[0] = 1;
        full[1] = (byte)buf.length;
        System.arraycopy(buf, 0, full, 2, buf.length);
        CamdNetMessage msg = CamdNetMessage.parseRadegast(commandTag, caData, full, this.getRemoteAddress());
        msg.setRdgProviderId(providerId);
        msg.setRdgKeyNumber(keyNr);
        msg.setCaId(caId);
        msg.setNetworkId(this.getProfile().getNetworkId());
        ++this.msgCount;
        if (msg.isEcm()) {
            ++this.ecmCount;
            if (sid != 0) {
                msg.setServiceId(sid);
            }
            this.caId = msg.getCaId();
        }
        return msg;
    }

    public String getUser() {
        return "rdg@" + this.getRemoteAddress();
    }

    public String getClientId() {
        return "Unknown[rdg]";
    }

    public String getProtocol() {
        return "Radegast";
    }

    public String getLastContext() {
        if (this.caId == 0) {
            return "?";
        }
        String s = Integer.toHexString(this.caId);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return "CaID [" + s + "] Providers [" + this.getProfile().getProviderSet().size() + "] " + ProxyConfig.providerIdentsToString(this.getProfile().getProviderSet());
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.sessionThread != null) {
            this.sessionThread.interrupt();
        }
    }

    public boolean isConnected() {
        return this.sessionThread != null;
    }

    public boolean isTempUser() {
        return true;
    }

    public int sendMessage(CamdNetMessage msg) {
        return -1;
    }

    public synchronized int sendEcmReplyNative(CamdNetMessage ecmRequest, CamdNetMessage ecmReply) {
        int status = -1;
        byte[] buf = new byte[4 + ecmReply.getDataLength()];
        buf[0] = 2;
        buf[1] = (byte)(buf.length - 2);
        if (ecmReply.isEmpty()) {
            buf[2] = 4;
            buf[3] = 0;
        } else {
            buf[2] = 5;
            buf[3] = (byte)ecmReply.getDataLength();
            System.arraycopy(ecmReply.getCustomData(), 0, buf, 4, ecmReply.getDataLength());
        }
        this.logger.finer("Sending reply: " + DESUtil.bytesToString(buf));
        try {
            this.os.write(buf);
            this.os.flush();
            ecmReply.setSent(this.getRemoteAddress(), buf, this.getProtocol());
            status = 1;
        }
        catch (IOException e) {
            this.logger.throwing("Connection closed while sending", e);
            this.close();
        }
        this.endTransaction(ecmRequest, ecmReply, status);
        return status;
    }
}

