/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.BoxMetaData;
import com.bowman.cardserv.BoxOperation;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.DreamboxPlugin;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.httpd.HttpRequest;
import com.bowman.httpd.HttpRequestListener;
import com.bowman.httpd.HttpResponse;
import com.bowman.httpd.PseudoHttpd;
import com.bowman.util.Base64Encoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class AgentWeb
implements HttpRequestListener,
XmlConfigurable {
    static final String[] PATTERNS = new String[]{"/login", "/checkin", "/output*", "/installer.sh", "/open/*"};
    private PseudoHttpd httpd;
    private ProxyLogger httpdLogger;
    private DreamboxPlugin parent;
    private String frontendHost;
    private int frontendPort;
    private boolean altConnect;

    public AgentWeb(DreamboxPlugin parent) {
        this.parent = parent;
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        InetAddress bindAddr = null;
        String bindIp = null;
        try {
            bindIp = xml.getStringValue("bind-ip");
            bindAddr = InetAddress.getByName(bindIp);
        }
        catch (ConfigException e) {
        }
        catch (UnknownHostException e) {
            throw new ConfigException(xml.getFullName(), "bind-ip", "Invalid status-web bind-ip: " + bindIp);
        }
        int listenPort = xml.getPortValue("listen-port", 8081);
        this.frontendPort = xml.getPortValue("frontend-port", listenPort);
        try {
            this.frontendHost = xml.getStringValue("frontend-host");
        }
        catch (ConfigException e) {
            this.frontendHost = null;
        }
        this.altConnect = "true".equalsIgnoreCase(xml.getStringValue("alternative-connect", "false"));
        if (this.httpd != null) {
            if (this.httpd.getListenPort() != listenPort) {
                this.httpd.stop();
                this.httpd = new PseudoHttpd(listenPort, bindAddr);
            }
        } else {
            this.httpd = new PseudoHttpd(listenPort, bindAddr);
        }
        try {
            this.httpd.setWar(new File("plugins/dreamboxplugin.jar"));
            this.httpd.setWarRoot("web");
        }
        catch (IOException e) {
            throw new ConfigException(xml.getFullName(), "Httpd failed to read/find plugin jar 'dreamboxplugin.jar': " + e, (Throwable)e);
        }
        this.httpd.setSilent(true);
        String logFile = null;
        int count = 0;
        int limit = 0;
        try {
            ProxyXmlConfig logXml = xml.getSubConfig("log-file");
            count = logXml.getIntValue("rotate-count");
            if (count < 1) {
                count = 0;
            }
            if ((limit = logXml.getIntValue("rotate-max-size")) < 1) {
                limit = 0;
            }
        }
        catch (ConfigException e) {
            // empty catch block
        }
        try {
            if (this.httpdLogger != null) {
                this.httpdLogger.close();
            }
            logFile = xml.getFileValue("log-file", true);
            if (count > 0 && limit > 0) {
                new File(logFile).delete();
            }
            this.httpdLogger = ProxyLogger.getFileLogger((String)"AgentWeb", (File)new File(logFile), (String)"FINER", (int)count, (int)limit, (boolean)true);
            this.httpd.setLogger(this.httpdLogger.getWrappedLogger());
        }
        catch (ConfigException e) {
            this.httpd.setLogger(null);
        }
        catch (IOException e) {
            throw new ConfigException(xml.getSubConfig("log-file").getFullName(), "Unable to assign log-file: " + logFile, (Throwable)e);
        }
        this.httpd.addHttpRequestListener(PATTERNS, (HttpRequestListener)this);
    }

    public void stop() {
        this.httpd.stop();
        if (this.httpdLogger != null) {
            this.httpdLogger.close();
        }
    }

    public void start() {
        try {
            this.httpd.start();
        }
        catch (IOException e) {
            this.parent.logger.severe("Unable to start httpd: " + e, (Throwable)e);
        }
    }

    public HttpResponse doGet(String s, HttpRequest req) {
        if (s.equals("/installer.sh")) {
            return this.doGetInstaller(req);
        }
        if (s.equals("/login")) {
            return this.doGetLogin(req);
        }
        if (s.equals("/checkin")) {
            return this.doGetCheckin(req);
        }
        if (s.startsWith("/open/")) {
            byte[] buf = this.parent.getFile(req.getQueryString().substring(6));
            System.out.println(req.getQueryString().substring(6));
            if (buf != null) {
                return HttpResponse.getFileResponse((byte[])buf, (String)s, (PseudoHttpd)this.httpd);
            }
        }
        return null;
    }

    private HttpResponse doGetInstaller(HttpRequest req) {
        String user = this.checkBasicAuth(req);
        if (user != null) {
            try {
                String installer = new String(this.parent.getResource("installer-template.sh", false), "ISO-8859-1");
                String fh = this.frontendHost;
                if (fh == null) {
                    fh = req.getHeader("host");
                }
                installer = installer.replaceFirst("\\{0\\}", fh);
                installer = installer.replaceFirst("\\{1\\}", String.valueOf(this.frontendPort));
                installer = installer.replaceFirst("\\{2\\}", user);
                installer = installer.replaceFirst("\\{3\\}", String.valueOf(this.parent.checkInterval));
                installer = installer.replaceFirst("\\{4\\}", this.parent.getAgentVersion());
                HttpResponse resp = new HttpResponse(installer, "application/x-sh");
                resp.setHeader("Content-Disposition", "attachment; filename=installer-" + user + ".sh");
                return resp;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return HttpResponse.getAuthReqResponse((String)this.parent.getName());
    }

    private HttpResponse doGetLogin(HttpRequest req) {
        BoxMetaData box;
        BoxMetaData[] existingBoxes;
        String user = req.getHeader("csp-user");
        if (this.parent.proxy.getUserPasswd(user) == null) {
            return HttpResponse.getErrorResponse((int)403, (String)("Unknown user: " + user));
        }
        String seed = req.getHeader("csp-seed");
        String macAddr = req.getHeader("csp-mac");
        if (ProxyConfig.getInstance().getUserManager().isDebug(user)) {
            System.out.println(req.getHeaders());
        }
        if ((existingBoxes = this.parent.findBox(macAddr, user)).length > 1) {
            this.parent.logger.warning("Multiple boxes with mac '" + macAddr + "' for user: " + user);
            return HttpResponse.getErrorResponse((int)403, (String)("Ambigious box identity: mac=" + macAddr + " user=" + user));
        }
        if (existingBoxes.length == 1) {
            box = existingBoxes[0];
        } else {
            box = new BoxMetaData(macAddr, user, seed, null);
            this.parent.registerBox(box);
        }
        String type = req.getHeader("csp-boxtype");
        if (type != null) {
            type = type.toLowerCase();
        }
        box.setProperty("type", type);
        box.setProperty("local-ip", req.getHeader("csp-local-ip"));
        box.setProperty("agent-version", req.getHeader("csp-agent-version"));
        box.setProperty("kernel-version", req.getHeader("csp-kernel-version"));
        box.setProperty("image-guess", req.getHeader("csp-img-guess"));
        box.setProperty("image-info", req.getHeader("csp-img-info"));
        if (req.getHeader("csp-osd-type") != null) {
            box.setProperty("osd-type", req.getHeader("csp-osd-type"));
        }
        if (req.getHeader("csp-osd-version") != null) {
            box.setProperty("osd-version", req.getHeader("csp-osd-version"));
        }
        if (req.getHeader("csp-uname-m") != null) {
            box.setProperty("machine", req.getHeader("csp-uname-m"));
        }
        box.setProperty("external-ip", req.getRemoteAddress());
        box.checkin(Integer.parseInt(req.getHeader("csp-iv")));
        return new HttpResponse(box.getBoxId(), "text/plain");
    }

    private HttpResponse doGetCheckin(HttpRequest req) {
        String localIp;
        String onid;
        String boxId = req.getHeader("csp-boxid");
        if (boxId == null) {
            return HttpResponse.getErrorResponse((int)403, (String)"Missing boxid");
        }
        BoxMetaData box = this.parent.getBox(boxId);
        if (box == null) {
            return HttpResponse.getErrorResponse((int)403, (String)("Invalid/unknown boxid: " + boxId));
        }
        if (ProxyConfig.getInstance().getUserManager().isDebug(box.getUser())) {
            System.out.println(req.getHeaders());
        }
        box.setProperty("external-ip", req.getRemoteAddress());
        String sid = req.getHeader("csp-sid");
        if (sid != null) {
            if (sid.endsWith("h")) {
                sid = String.valueOf(Integer.parseInt(sid.substring(0, sid.length() - 1), 16));
            }
            box.setProperty("sid", sid);
        }
        if ((onid = req.getHeader("csp-onid")) != null) {
            if (onid.endsWith("h")) {
                onid = String.valueOf(Integer.parseInt(onid.substring(0, onid.length() - 1), 16));
            }
            box.setProperty("onid", onid);
        }
        box.setProperty("uptime", req.getHeader("csp-uptime"));
        String agentV = req.getHeader("csp-agent-version");
        if (agentV != null) {
            box.setProperty("agent-version", agentV);
        }
        if ((localIp = req.getHeader("csp-local-ip")) != null) {
            box.setProperty("local-ip", localIp);
        }
        box.checkin(Integer.parseInt(req.getHeader("csp-iv")));
        if (box.getPendingOperation() != null) {
            return new HttpResponse(this.generateOperationScript(box), "text/plain");
        }
        return new HttpResponse("", "text/plain");
    }

    protected String generateOperationScript(BoxMetaData box) {
        BoxOperation op = box.getPendingOperation();
        if (op != null) {
            String s = null;
            if (op.isScript()) {
                byte[] buf = this.parent.getFile("scripts/" + op.getScriptName());
                if (buf == null) {
                    this.parent.logger.warning("Operation '" + op + "' was queued for box '" + box.getBoxId() + "', but no such script was found in /web/open/scripts/");
                } else {
                    try {
                        s = this.loadScript(buf);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                s = op.getCmdLine();
            }
            if (s != null) {
                s = this.resolveContextVars(s, box, op);
                StringBuffer script = new StringBuffer("#!/bin/ash\n");
                script.append("echo \"");
                if (this.altConnect) {
                    script.append("XCNT");
                } else {
                    script.append("CONNECT");
                }
                script.append(" /output?boxId=").append(box.getBoxId()).append("&opId=").append(op.getId());
                if (op.getOutFile() != null) {
                    script.append("&fileName=").append(op.getOutFile());
                }
                script.append("\n\n").append("\"");
                script.append("\n");
                script.append(s);
                System.out.println(script);
                box.runPendingOperation();
                return script.toString();
            }
        }
        return "";
    }

    protected String loadScript(byte[] buf) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buf), "ISO-8859-1"));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#!/")) continue;
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    protected String resolveContextVars(String s, BoxMetaData box, BoxOperation op) {
        if (s.indexOf("{TUNNELPORT}") != -1) {
            s = s.replaceFirst("\\{TUNNELPORT\\}", String.valueOf(this.parent.getTunnelPort()));
        }
        s = s.replaceFirst("\\{SSHDPORT\\}", String.valueOf(this.parent.getSshdPort()));
        s = s.replaceFirst("\\{CPUARCH\\}", DreamboxPlugin.getBoxCpuArch(box));
        s = s.replaceFirst("\\{USERNAME\\}", box.getUser());
        s = s.replaceFirst("\\{PASSWORD\\}", this.parent.getUserPasswd(box.getUser()));
        s = s.replaceFirst("\\{IMAGE\\}", box.getProperty("image-guess"));
        s = s.replaceFirst("\\{BOXTYPE\\}", box.getProperty("type"));
        s = s.replaceFirst("\\{PARAMS\\}", op.getParams());
        return s;
    }

    public HttpResponse doPost(String s, HttpRequest req) {
        System.out.println(s + " - " + req);
        return null;
    }

    public HttpResponse doConnect(String urlPattern, HttpRequest connectRequest) {
        if (urlPattern.equals("/output*")) {
            System.out.println(connectRequest.getQueryString());
            BoxMetaData box = this.parent.getBox(connectRequest.getParameter("boxId"));
            String fileName = connectRequest.getParameter("fileName");
            String opIdStr = connectRequest.getParameter("opId");
            BoxOperation op = null;
            if (opIdStr != null) {
                op = box.getOperation(Integer.parseInt(opIdStr));
            }
            File target = null;
            if (fileName != null) {
                if (box == null || !box.isUploadAllowed(fileName)) {
                    this.parent.logger.warning("File upload from unknown/deleted/unauthorized box: " + connectRequest.getQueryString());
                    if (op == null) {
                        return HttpResponse.getErrorResponse((int)401);
                    }
                } else {
                    String targetPath = box.getUploadPath(fileName);
                    target = new File(targetPath);
                    if (target.isDirectory()) {
                        target = new File(target, fileName);
                    }
                    if (target.exists() && !target.canWrite() || target.isDirectory()) {
                        try {
                            this.parent.logger.warning("Unable to write file upload from: " + box.getUser() + " (" + target.getCanonicalPath() + ")");
                            target = null;
                            if (op == null) {
                                return HttpResponse.getErrorResponse((int)404);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (box == null || op == null && target == null) {
                this.parent.logger.warning("Connect request from unknown/deleted box or operation: " + connectRequest.getQueryString());
                return HttpResponse.getErrorResponse((int)401);
            }
            new OutputReaderThread(connectRequest.getConnection(), box, op, target);
            return HttpResponse.CONNECT_RESPONSE;
        }
        return HttpResponse.getErrorResponse((int)405, (String)connectRequest.getMethod());
    }

    private String checkBasicAuth(HttpRequest req) {
        String userPass;
        int idx;
        String basicAuth = req.getHeader("authorization");
        if (basicAuth != null && basicAuth.toLowerCase().startsWith("basic ") && (idx = (userPass = new String(Base64Encoder.decode((char[])basicAuth.substring(6).toCharArray()))).indexOf(":")) > 1) {
            String pass;
            String user = userPass.substring(0, idx);
            if (this.parent.proxy.authenticateUser(user, pass = userPass.substring(idx + 1))) {
                return user;
            }
            this.parent.logger.warning("Http auth failed for user '" + user + "' (" + CustomFormatter.formatAddress((String)req.getRemoteAddress()) + ").");
            return null;
        }
        return null;
    }

    public String getFrontendHost() {
        return this.frontendHost;
    }

    public int getFrontendPort() {
        return this.frontendPort;
    }

    private static class OutputReaderThread
    extends Thread {
        Socket conn;
        BoxMetaData box;
        BoxOperation op;
        File target;

        OutputReaderThread(Socket conn, BoxMetaData box, BoxOperation op, File target) {
            super("OutputReaderThread[" + (op == null ? target.getPath() : String.valueOf(op.getId())) + "]");
            this.conn = conn;
            this.box = box;
            this.op = op;
            this.target = target;
            this.start();
        }

        @Override
        public void run() {
            boolean first = true;
            if (this.op != null) {
                this.op.start(this.conn);
            }
            PrintWriter pw = null;
            try {
                String line;
                if (this.target != null) {
                    pw = this.getFileWriter();
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
                while ((line = br.readLine()) != null) {
                    if (this.op != null) {
                        if (pw != null && first) {
                            this.op.appendOutput("(Writing output to: " + this.target.getPath() + ")");
                        }
                        System.out.println(this.op.getId() + " - " + line);
                        if (line.indexOf(0) == -1) {
                            this.op.appendOutput(line);
                        }
                    }
                    if (pw == null) continue;
                    if (first) {
                        first = false;
                        if ("".equals(line)) continue;
                    }
                    if (this.op == null) {
                        System.out.println(this.target.getPath() + " - " + line);
                    }
                    if (line.indexOf(0) != -1) continue;
                    pw.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (pw != null) {
                pw.flush();
            }
            if (this.op != null) {
                this.op.end();
            }
        }

        private PrintWriter getFileWriter() {
            try {
                return new PrintWriter((Writer)new FileWriter(this.target, false), false);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.op != null) {
                    this.op.appendOutput("(Writing output file failed: " + e + ")");
                }
                return null;
            }
        }
    }
}

