/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.BoxOperation;
import com.bowman.cardserv.FileUploadPermission;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class BoxMetaData
implements Serializable {
    private String macAddr;
    private String user;
    private String boxId;
    private String tag;
    private int interval;
    private long createTimeStamp;
    private long lastCheckinTimeStamp;
    private transient int tunnelPort;
    private transient BoxOperation pendingOperation;
    private transient Map executedOperations;
    private transient FileUploadPermission uploadPermissions;
    private Properties boxProperties = new Properties();

    public BoxMetaData(String macAddr, String user, String seed, String salt) {
        this.macAddr = macAddr;
        this.user = user;
        this.boxId = BoxMetaData.generateBoxId(macAddr, user, seed, salt);
        this.createTimeStamp = System.currentTimeMillis();
    }

    public String getMacAddr() {
        return this.macAddr;
    }

    public String getUser() {
        return this.user;
    }

    public String getBoxId() {
        return this.boxId;
    }

    public int getTunnelPort() {
        return this.tunnelPort;
    }

    public void setTunnelPort(int tunnelPort) {
        this.tunnelPort = tunnelPort;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public BoxOperation getPendingOperation() {
        return this.pendingOperation;
    }

    public void setPendingOperation(BoxOperation pendingOperation) {
        this.pendingOperation = pendingOperation;
    }

    public void runPendingOperation() {
        if (this.pendingOperation != null) {
            if (this.executedOperations == null) {
                this.executedOperations = new LinkedHashMap();
            }
            this.executedOperations.put(new Integer(this.pendingOperation.getId()), this.pendingOperation);
            this.pendingOperation = null;
        }
    }

    public long getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    public long getLastCheckinTimeStamp() {
        return this.lastCheckinTimeStamp;
    }

    public int getInterval() {
        return this.interval;
    }

    public void checkin(int interval) {
        this.interval = interval;
        this.lastCheckinTimeStamp = System.currentTimeMillis();
    }

    public void setProperty(String name, String value) {
        this.boxProperties.setProperty(name, value);
        if ("uptime".equals(name) && value != null && value.indexOf(", load average: ") != -1) {
            String load = value.split(", load average: ")[1];
            this.boxProperties.setProperty("load", load);
            String[] n = load.split(", ");
            if (n.length == 3) {
                if (!(n[0].startsWith("0") || n[1].startsWith("0") || n[2].startsWith("0"))) {
                    this.boxProperties.setProperty("cpu-warn", "true");
                } else {
                    this.boxProperties.setProperty("cpu-warn", "false");
                }
            }
        }
    }

    public String getProperty(String name) {
        return this.boxProperties.getProperty(name);
    }

    public Properties getProperties() {
        return this.boxProperties;
    }

    public BoxOperation getOperation(int opId) {
        if (this.executedOperations == null) {
            return null;
        }
        return (BoxOperation)this.executedOperations.get(new Integer(opId));
    }

    public int getOperationCount() {
        if (this.executedOperations == null) {
            return 0;
        }
        return this.executedOperations.size();
    }

    public Collection getOperations() {
        if (this.executedOperations == null) {
            return null;
        }
        return this.executedOperations.values();
    }

    public int clearOperations() {
        int count = 0;
        if (this.executedOperations != null) {
            count = this.executedOperations.size();
            this.executedOperations.clear();
        }
        return count;
    }

    public boolean isActive() {
        return System.currentTimeMillis() - this.lastCheckinTimeStamp < (long)(this.interval * 2000);
    }

    public boolean isUploadAllowed(String fileName) {
        if (this.uploadPermissions == null) {
            return false;
        }
        return this.uploadPermissions.contains(fileName);
    }

    public void setFileUploadEntry(FileUploadPermission fue) {
        this.uploadPermissions = fue;
    }

    public String getUploadPath(String fileName) {
        if (this.uploadPermissions == null) {
            return null;
        }
        return this.uploadPermissions.getPath(fileName);
    }

    protected static String generateBoxId(String macAddr, String user, String seed, String salt) {
        seed = Integer.toString(Integer.parseInt(seed), 16);
        while (seed.length() < 8) {
            seed = '0' + seed;
        }
        return seed + BoxMetaData.hexMD5Hash(macAddr + user + (salt == null ? "" : salt));
    }

    private static String hexMD5Hash(String text) {
        try {
            MessageDigest md5Digest = MessageDigest.getInstance("MD5");
            md5Digest.reset();
            md5Digest.update(text.getBytes());
            byte[] md5 = md5Digest.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < md5.length; ++i) {
                String byteStr = Integer.toString(0xFF & md5[i], 16);
                if (byteStr.length() == 1) {
                    sb.append("0");
                }
                sb.append(byteStr);
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

